/**
 * JMUD for JamochaMUD is the "main" section for JamochaMUD
 * $Id: JMUD.java,v 1.21 2009/09/16 02:55:23 jeffnik Exp $
 */

/* JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2009 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package anecho.JamochaMUD;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;

import anecho.gui.JSyncFrame;
import anecho.gui.SyncFrame;
import anecho.gui.SyncFrameGroup;
import java.util.Hashtable;

/**
 *
 * @author jeffnik
 */
public class JMUD {

    /**
     * This class will handle all our connections
     */
    public transient CHandler connections;
    /**
     * This class contains all our settings
     */
    public transient JMConfig settings;
    /**
     * Our main text window
     */
    // public transient MuckMain mainProg;
    /**
     *
     */
    public transient Frame mainFrame;
    /**
     *
     */
    public transient DataIn inputFrame;
    /**
     *
     */
    // public transient EnumPlugIns plugEnum;
    /**
     *
     */
    public transient SyncFrameGroup frameGroup;   // Our SyncFrame group
    /**
     * This object represents the splash screen (using Swing), which can
     * be accessed by other classes while loading.  In this way plug-ins
     * and the like can pass status back to the user
     */
    private transient Object splash;
    /** Enables and disables debugging output */
    private static final boolean DEBUG = false;

    /**
     * The main method for JamochaMUD.  This is where it all begins!
     * @param args
     */
    public static void main(final String[] args) {
        // Create a new instance of our program for your running pleasure!
        // final JMUD proggy = new JMUD(args);
        new JMUD(args);
    // Bye-bye
    }

    /**
     *
     * @param args
     */
    public JMUD(final String[] args) {

        /* This is a hashtable of simple 2-part arguments */
        final Hashtable simpleArgs = new Hashtable();
        simpleArgs.put("-mudlist", JMConfig.EXTMUDLIST);
        simpleArgs.put("-listtype", JMConfig.MUDLISTTYPE);
        simpleArgs.put("-listtags", JMConfig.MANUALEXTLIST);
        simpleArgs.put("-mudimage", JMConfig.EXTMUDIMAGE);

        // Create our "settings" container
        settings = JMConfig.getInstance();
        String startTitle = "";
        String startWorld = "";
        int startPort = 0;

        // Let's put ourselves in the settings, so we're accessable for a QUIT or somethin'
        settings.setJMCore(this);

        // Set some defaults
        settings.setJMValue(JMConfig.USESWING, true);  // Use Swing components by default
        settings.setJMValue(JMConfig.USESWINGENTRY, true);  // Java 1.2 and 1.3 requestFocus is "broken"
        settings.setJMValue(JMConfig.BGPAINT, true);    // Paint background on Swing text component

        // Check to see if we're forcing "single user mode" or not
        if (args.length > 0) {
            String tempArg = "";
            for (int i = 0; i < args.length; i++) {
                tempArg = args[i].toLowerCase();
                if (tempArg.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-h")) || tempArg.equals(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-?"))) {
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUD_") + AboutBox.fullVerNum);
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("A_Java_MUD/Muck_client,_(C)2008_Jeff_Robinson."));
                    System.out.println();
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Current_accepted_arguments:"));
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-h/-?_____This_screen"));
                    System.out.println("-mudlist  Make a list of MU*s available from this address (include protocol such as http://)");
                    System.out.println("-listype  The type of list imported by via -mudlist.  Types available: MUDLISTS (default)");
                    System.out.println("-listtags Tags used to parse the list imported via -mudlist.  Tags must be separated by a colon and contain tags for World:Name:Address:Port (this is ignored if -mudlist is not specified)");
                    System.out.println("-mudimage The fully qualified URL for the image to be used in the JamochaMUD connector");
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-s________Force_single-user_mode"));
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-swing____Use_Java2_Swing_components_(default)"));
                    System.out.println("-t Assign a title to the MU* (only when launching a world from the command line)");
                    System.out.println("-quietrc Do not prompt the user for creation of a .jamocha.rc file, create it silently.");
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-noswing__Use_only_Java_1.1.x_AWT_components"));
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-nosentry_Use_Swing_except_for_the_text-entry_area"));
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-nobg_____Do_not_paint_text_background_colours_(default)"));
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-bg_______Paint_text_background_colours"));
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-v________Version_of_the_program"));

                    System.out.println("[world:port] (e.g. muck.foo.com:1234");
                    System.exit(0);
                    // Throw an exception instead of calling System.exit, otherwise JUnit will fail on tests
                    // throw new RuntimeException();
                }

                if (tempArg.equals("-s")) {
                    // Force single user mode
                    settings.setJMValue(JMConfig.SINGLEUSERMODE, true);
                }

                if (tempArg.equals("-v")) {
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUD_") + AboutBox.fullVerNum);
                    System.exit(0);
                    // Throw an exception instead of calling System.exit, otherwise JUnit will fail on tests
                    // throw new RuntimeException();

                }

                if (tempArg.equals("-swing")) {
                    settings.setJMValue(JMConfig.USESWING, true);
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("-swing_option_is_deprecated..._enabled_by_default."));
                }

                if (tempArg.equals("-noswing")) {
                    settings.setJMValue(JMConfig.USESWING, false);
                    settings.setJMValue(JMConfig.USESWINGENTRY, false);
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Disabling_use_of_Swing_components."));
                }

                if (tempArg.equals("-nosentry")) {
                    settings.setJMValue(JMConfig.USESWINGENTRY, false);
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Using_AWT_for_the_text_entry_area."));
                }

                if (tempArg.equals("-sentry")) {
                    settings.setJMValue(JMConfig.USESWINGENTRY, true);
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Forcing_Swing-based_text-entry_component."));
                }

                if (tempArg.equals("-nobg")) {
                    settings.setJMValue(JMConfig.BGPAINT, false);
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Background_text_painting_disabled."));
                }

                if (tempArg.equals("-bg")) {
                    settings.setJMValue(JMConfig.BGPAINT, true);
                    System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Background_text_painting_enabled."));
                }

                if (tempArg.equals("-t") && moreArgs(args, i)) {

                    if (DEBUG) {
                        System.err.println("Setting temporary connection title to: " + args[i + 1]);
                    }

                    startTitle = args[i + 1];
                }

                if (tempArg.equals("-quietrc")) {
                    settings.setJMValue(JMConfig.QUIETRC, true);
                    System.out.println("Creating .jamocha.rc file with-out user intervention.");
                }

                // Check our hashtable for matching arguments
                if (simpleArgs.containsKey(tempArg)) {
                    settings.setJMValue(simpleArgs.get(tempArg).toString(), args[i + 1]);
                }
            }
            // Check to see if the last argument was a world to connect.
            // This will cause us to skip the MU* Connector altogether

            if (tempArg != null) {
                // tempArg should be the last argument in our list
                if (DEBUG) {
                    System.err.println("JMUD.class checking " + tempArg + " for world information.");
                }

                final int colonSpot = tempArg.indexOf(':');

                if (colonSpot > 1 && colonSpot < tempArg.length()) {
                    startWorld = tempArg.substring(0, colonSpot);
                    try {
                        startPort = Integer.parseInt(tempArg.substring(colonSpot + 1));
                    } catch (Exception portExc) {
                        if (DEBUG) {
                            System.err.println("Error getting startPort from " + tempArg);
                            System.err.println(portExc);
                        }
                    }

                    if (DEBUG) {
                        System.err.println("JMUD starting world is " + startWorld + " " + startPort);
                    }
                }


            }

        }


        // Test the system to see if Swing is available (if chosen)
        boolean useSwing = settings.getJMboolean(JMConfig.USESWING);

        if (useSwing) {
            try {
                // Class swingTest = Class.forName("javax.swing.JButton");
                Class.forName(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("javax.swing.JButton"));
                if (DEBUG) {
                    System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Swing_test_passed.."));
                }

            } catch (Exception except) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Swing_is_not_currently_available,_switching_to_use_the_Java_AWT."));
                if (DEBUG) {
                    System.err.println(except);
                }

                settings.setJMValue(JMConfig.USESWING, false);
                settings.setJMValue(JMConfig.USESWINGENTRY, false);
                useSwing = false;
            }
        }

        // Create our SplashScreen
        if (useSwing) {
            splash = (Object) new anecho.gui.SplashScreen(null, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Getting_system_information"), new javax.swing.ImageIcon(JMainMenu.class.getResource(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JMUDSplash.png"))));
            ((anecho.gui.SplashScreen) splash).setVisible(true);
        }

        // Get our system information
        getSysInfo();

        // Do a sanity check on our user supplied arguments
        checkArguments();

        // Read in our "profile"
        if (useSwing) {
            ((anecho.gui.SplashScreen) splash).updateMessage(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Reading_JamochaMUD_settings..."));
        }
        getSettings();

        frameGroup = new SyncFrameGroup();

        if (useSwing) {
            ((anecho.gui.SplashScreen) splash).updateMessage(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Loading_main_program..."));
        }

        final MuckMain mainProg = MuckMain.getInstance();
        mainFrame = mainProg.getMainFrame();
        // mainFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        frameGroup.add(mainFrame);

        connections = CHandler.getInstance();

        inputFrame = new DataIn();
        frameGroup.add(inputFrame);
        settings.setDataInVariable(inputFrame);

        // Set the visual state of our components
        setupFrames();

        // Add our text-window to the main frame
        mainProg.setMainLayout();

        if (useSwing) {
            ((anecho.gui.SplashScreen) splash).updateMessage(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Loading_plug-ins..."));
        }
        loadPlugins();

        if (useSwing) {
            ((anecho.gui.SplashScreen) splash).setVisible(false);
        }

        if (DEBUG) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JMUD.JMUD_is_calling_connectToNewMU()"));
        }

        if (startPort == 0) {
            // Connect to the MU* and show the standard MU* Connector
            connections.connectToNewMU();
        } else {
            // Do a "World Check"
            // AddEditWorld tempAEW = new AddEditWorld();

            // Connect to the World with-out showing the MU* Connector
            // Hard-coded to use a character.  This could be bad, so we'll put a fix me XXX here.
            connections.connectToNewMU(startTitle, startWorld, startPort, 0, null);
        }

    }

    /**
     * Check to see if there are more arguments remaining in the given list
     * @param args The list of arguments
     * @param pos The position in the list to start checking from
     * @return <code>true</code> There is an additional argument available
     *          <code>false</code> There are no more arguments available
     */
    private boolean moreArgs(final String[] args, final int pos) {
        boolean retVal = false;

        if (pos + 1 < args.length && args[pos + 1] != null) {
            retVal = true;
        }

        return retVal;

    }

    /** Read in our settings.  We make this a separate method
     * in hopes that it will fall out of scope and destroy our
     * JMParseRC class when it is done... */
    private void getSettings() {
        // We'll pass our 'settings' variable to get things set up correctly
        new JMParseRC(splash);
    }

    /** Gather system-specific information about the platform
     * we're running on */
    private void getSysInfo() {
        new SysInfo();
    }

    /** Setup the visual elements for the user */
    private void setupFrames() {
        settings.setJMValue(JMConfig.MUCKMAINTITLE, "JamochaMUD");

        // Set the size of our windows
        Rectangle tempRect;
        tempRect = settings.getJMRectangle(JMConfig.MAINWINDOW);

        if (tempRect == null) {
            mainFrame.setBounds(new Rectangle(0, 10, 600, 355));
        } else {
            mainFrame.setBounds(settings.getJMRectangle(JMConfig.MAINWINDOW));
        }

        tempRect = settings.getJMRectangle(JMConfig.DATABAR);

//        if (tempRect != null) {
//            inputFrame.setBounds(settings.getJMRectangle(JMConfig.DATABAR));
//        } else {
//            inputFrame.setBounds(new Rectangle(0, 385, 600, 60));
//        }

        if (tempRect == null) {
            inputFrame.setBounds(new Rectangle(0, 385, 600, 60));
        } else {
            inputFrame.setBounds(settings.getJMRectangle(JMConfig.DATABAR));
        }

        boolean sync = false;
        if (settings.getJMboolean(JMConfig.SPLITVIEW)) {
            sync = settings.getJMboolean(JMConfig.SYNCWINDOWS);
        }

        // Do this for now, but fix the setGroupSync function in SyncFrame/SyncGroup!!!
        // Fix me XXX
        // ((SyncFrame)mainFrame).setSyncFrameGroup(frameGroup);
        inputFrame.setSyncFrameGroup(frameGroup);
        // ((SyncFrame)mainFrame).setSync(sync);
        inputFrame.setSync(sync);

        // Create our area that will hold our output "windows"
        if (settings.getJMboolean(JMConfig.USESWING)) {
            if (DEBUG) {
                System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Swing_being_used_by_JMUD."));
            }
            ((JSyncFrame) mainFrame).setSyncFrameGroup(frameGroup);
            ((JSyncFrame) mainFrame).setSync(sync);
        } else {
            if (DEBUG) {
                System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("We're_not_using_swing_in_JMUD."));
            }
            // anecho.JamochaMUD.legacy.JMTabPanel textPanel = new anecho.JamochaMUD.legacy.JMTabPanel();
            ((SyncFrame) mainFrame).setSyncFrameGroup(frameGroup);
            ((SyncFrame) mainFrame).setSync(sync);
        }

    }

    /**
     * This method calls the method to load all the JamochaMUD plug-ins
     */
    private void loadPlugins() {
        final EnumPlugIns plugEnum = EnumPlugIns.getInstance();
        settings.setPlugEnumerator(plugEnum);
        plugEnum.loadPlugIns(splash);
    }

    /** Tell our plug-ins that we are shutting down, so they better save their data! */
    private void haltPlugins() {
        // plugEnum.haltPlugIns();
        EnumPlugIns.getInstance().haltPlugIns();
    }

    /** This method collects all the data needed to write
     * a new .rc file of the user's settings, and do
     * any other necessary clean-up */
    public void quitJamochaMUD() {
        // Gather all our settings that remain.
        Rectangle test;

        test = mainFrame.getBounds();
        if (checkVisible(test)) {
            settings.setJMValue(JMConfig.MAINWINDOW, test);

        }

        test = inputFrame.getBounds();
        if (checkVisible(test)) {
            settings.setJMValue(JMConfig.DATABAR, test);
        }

        // final JMWriteRC done = new JMWriteRC(settings);
        final JMWriteRC done = new JMWriteRC();
        done.writeRCToFile();

        haltPlugins();

        System.exit(0);
        // Throw an exception instead of calling System.exit, otherwise JUnit will fail on tests
        // throw new RuntimeException();

    }

    /** Check the bounds of our rectangle to see if it is visible
     * or not.  This is basically a hack, but better'n nothing.
     */
    private boolean checkVisible(final Rectangle testRect) {
        int xAxis, yAxis;   // Our location on the screen
        boolean retVal = true;
        xAxis = testRect.x;
        yAxis = testRect.y;

        if (xAxis < 0 || yAxis < 0) {
            // Our object is probably minimised, so use the settings from JMConfig
            retVal = false;
        }

        // Our object is probably visible on-screen, so we'll return true
        return retVal;
    }

    /**
     * Change our fonts globally across all windows
     * @param newStyle
     */
    public void setAllFonts(final Font newStyle) {
        // Change the font style of all our connections
        connections.setAllFonts(newStyle);

        // Change the font style of the input bar
        inputFrame.setFont(newStyle);
    }

    /**
     * Change our colours globally across all windows
     * @param foreground
     * @param background
     */
    public void setAllColours(final Color foreground, final Color background) {
        // Change the colours of our connections
        connections.setAllColours(foreground, background);

        // set the colour of our input frame
        inputFrame.setBackgroundColour(background);
        inputFrame.setForegroundColour(foreground);
    }

    /**
     * Change the synchronisation status of our windows
     * @param sync
     */
    public void setAllSync(final boolean sync) {
        // Only change our Sync value if we're using split panes
        if (settings.getJMboolean(JMConfig.SPLITVIEW)) {
            settings.setJMValue(JMConfig.SYNCWINDOWS, sync);
            ((SyncFrame) mainFrame).setSync(sync);
            inputFrame.setSync(sync);
        }
    }

    /** Change the main title */
    public void setMainWindowTitle() {
        // mainProg.setWindowTitle();
        MuckMain.getInstance().setWindowTitle();
        inputFrame.setWindowTitle();
    }

    /**
     * This method is used to make certain that variables have sane defaults
     * based on user supplied arguments
     */
    private void checkArguments() {
        // Check the external mud list arguments
        final String mudListLoc = settings.getJMString(JMConfig.EXTMUDLIST);

        // if (!mudListLoc.equals("")) {
        if (!"".equals(mudListLoc)) {
            // If we are supplied a location for a remote list then we must
            // do a sanity check on our list options
            final String mudListType = settings.getJMString(JMConfig.MUDLISTTYPE);
            final String mudManualList = settings.getJMString(JMConfig.MANUALEXTLIST);

            // if (mudListType.equals("") && mudManualList.equals("")) {
            if ("".equals(mudListType) && "".equals(mudManualList)) {
                // We weren't supplied a Mud List type or manual type, so set the Mud List to default
                settings.setJMValue(JMConfig.MUDLISTTYPE, "MUDLISTS");
            }
        }
    }
}
