/*
 * ImportExport.java
 *
 * Created on January 14, 2006, 10:53 PM
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template inStrm the Source Editor.
 */

package anecho.JamochaMUD;

import anecho.util.FileUtils;
import anecho.util.SimpleFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 *  This class is used for the importing and exporting of JamochaMUD settings
 * @author jeffnik
 */
public class ImportExport {
    
    private static final boolean DEBUG = false;
    private static final int BUFFER = 2048;
    private static final int SUCCESSFUL = 0;
    private static final int ARCHIVE_ERROR = 1;
    private static ImportExport ieObj;
    private static final String ARCEXT = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString(".jsa");
    private File prefFile;
    
    /** Creates a new instance of ImportExport */
    private ImportExport() {
        File baseDir = getBaseDir();
        String sep = File.separator;
        prefFile = new File(baseDir + sep + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JMUDPrefs_backup.xml"));
        
    }
    
    /**
     * Returns an instance of ImportExport
     * @return Returns a running instance of ImportExport.
     */
    public static ImportExport getInstance() {
        if (ieObj == null) {
            ieObj = new ImportExport();
        }
        return ieObj;
    }
    
    /** Gather all our settings and export them to a file
     */
    public void exportSettings() {
        // Find out where to save the file when we are done
        if (DEBUG) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Entered_ImportExport.exportSettings"));
        }
        
        final JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Choose_a_name_and_location_to_save_your_settings."));
        chooser.setDialogType(JFileChooser.SAVE_DIALOG);
        
        final SimpleFilter filter = new SimpleFilter();
        filter.setFilters(new String[]{java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString(".jsa")});
        filter.setDescription(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUD_Settings_Archive_*.jsa"));
        
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        // final int returnVal = chooser.showDialog((JFrame)JMConfig.getInstance().getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Export"));
        final int returnVal = chooser.showDialog((JFrame)JMConfig.getInstance().getJMObject(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Export"));
        
        if (returnVal == JFileChooser.CANCEL_OPTION) {
            // User has chosen to abort export
            return;
        }
        
        File selFile = chooser.getSelectedFile();
        
        // Check to see if we need to add the .jsa extension to the file name
        try {
            final String checkName = selFile.getCanonicalFile().toString();
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("The_Canonical_File_is_") + checkName);
            }
            final int dot = checkName.lastIndexOf(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("."));
            if (dot < 0 || !checkName.substring(dot).equalsIgnoreCase(ARCEXT)) {
                selFile = new File(checkName + ARCEXT);
            }
        } catch (Exception exc) {
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("There_was_an_error_checking_for_the_.jsa_extension_") + exc);
            }
        }
        
        // Force a write to the .jamocha.rc file so that any changes since this start are saved
        final JMWriteRC jwr = new JMWriteRC();
        jwr.writeRCToFile();
        
        // Back-up our Java userprefs files into a separate archive (within the "base" dir)
        exportPrefFile();
        
        // Create a list of all the settings files
        final String[] fNames = gatherFiles();
        
        // zip the files, creating the archive inStrm the appropriate location
        zipFiles(selFile, fNames);
        
        // Delete the temporary PrefFile we created
        prefFile.delete();
    }
    
    /**
     * Import previously saved settings into JamochaMUD.
     * JamochaMUD will need to be shutdown before this can proceed, as
     * we keep some specific variable information inStrm our settings.
     */
    public void importSettings() {
        final JMConfig settings = JMConfig.getInstance();
        final java.awt.Frame muckMainFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
        final String message = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("impMessage");
        
        final int result = javax.swing.JOptionPane.showConfirmDialog(muckMainFrame,
                message,
                java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("importWarningTitle"),
                javax.swing.JOptionPane.YES_NO_OPTION,
                javax.swing.JOptionPane.QUESTION_MESSAGE);
        
        if (result == javax.swing.JOptionPane.NO_OPTION) {
            // The user does not want to restart at this time, so we cannot continue with the import
            return;
        }
        
        final JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Choose_a_the_settings_to_restore"));
        chooser.setDialogType(JFileChooser.OPEN_DIALOG);
        final SimpleFilter filter = new SimpleFilter();
        filter.setFilters(new String[]{ARCEXT});
        filter.setDescription(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("JamochaMUD_Settings_Archive"));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(filter);
        final int returnVal = chooser.showDialog((JFrame)JMConfig.getInstance().getJMFrame(JMConfig.MUCKMAINFRAME), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Import"));
        
        if (returnVal == JFileChooser.CANCEL_OPTION) {
            // User has chosen to abort export
            return;
        }
        
        final File selFile = chooser.getSelectedFile();
        
        final int zipResult = unZipFiles(selFile);
        
        
        // Figure out our result codes here
        if (zipResult == SUCCESSFUL) {
            // We can only import the Pref File if the jsa was unzipped successfully
            // Import the Java pref file
            importPrefFile();
            // Tell the user we were successful and that they'll have to restart
            // JamochaMUD.
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Everything_went_perfectly_fine."));
            }
            JOptionPane.showMessageDialog(null,
                    java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Import_successful_message"),
                    java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Import_successful"),
                    JOptionPane.INFORMATION_MESSAGE);
            System.exit(0);
        } else {
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("There_was_a_failure_with_the_zip_file."));
            }
            JOptionPane.showMessageDialog(null,
                    java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("An_error_has_occured_during_import\nYour_data_has_not_been_restored."),
                    java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Import_error"),
                    JOptionPane.ERROR_MESSAGE);
            
        }
        
        if (DEBUG) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Importing_Pref_file."));
        }
        
        prefFile.delete();
        
    }
    
    /**
     * Gather the name and path of all settings files.
     *  If things are done properly, all the settings files
     *  should be inStrm the JMConfig.USERDIRECTORY
     */
    private String[] gatherFiles() {
        // final Vector tempFiles = new Vector();
        String[] fList;
        final File baseDir = getBaseDir();
        
        final FileUtils fileU = new FileUtils(baseDir.toString());
        try {
            fList = fileU.recursiveList(false);
        } catch (Exception exc) {
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("recursiveList_Exception_") + exc);
            fList = new String[0];
        }
        
        return fList;
    }
    
    /**
     * Zip the given files inStrm an archive and return a file handle for the
     *  newly created zip archive
     */
    private void zipFiles(final File arcFile, final String [] fileList) {
        // String userDir = JMConfig.getInstance().getJMString(JMConfig.USERDIRECTORY);
        final File baseDir = getBaseDir();
        
        final String baseName = baseDir.toString() + File.separator;
        final int hackLen = baseName.length();
        
        // Create a BUFFER for reading the files
        final byte[] buf = new byte[BUFFER];
        
        try {
            // Create the ZIP file
            // final String outFilename = arcFile.toString() + ".jsa";
            final String outFilename = arcFile.toString();
            final ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            FileInputStream inStrm;
            
            // Compress the files
            for (int i = 0; i < fileList.length; i++) {
                // final FileInputStream inStrm = new FileInputStream(fileList[i]);
                inStrm = new FileInputStream(fileList[i]);
                
                // Add ZIP entry to output stream.
                if (DEBUG) {
                    System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Hacked_entry_name_") + fileList[i].substring(hackLen));
                }
                out.putNextEntry(new ZipEntry(fileList[i].substring(hackLen)));
                
                // Transfer bytes from the file to the ZIP file
                int len;
                while ((len = inStrm.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                
                // Complete the entry
                out.closeEntry();
                inStrm.close();
            }
            
            // Complete the ZIP file
            out.close();
        } catch (IOException exc) {
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ImportExport_error_creating_zip_file_") + exc);
            }
        }
    }
    
    /** Unzip the files into the proper directory
     */
    private int unZipFiles(final File arcFile) {
        int retVal = SUCCESSFUL;
        
        final File baseDir = getBaseDir();    // The base directory for unzipping the files
        
        final String pathSep = File.separator;
        
        try {
            BufferedOutputStream dest = null;
            final FileInputStream fis = new FileInputStream(arcFile);
            final ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            FileOutputStream fos;
            ZipEntry entry;
            byte data[];
            File testFile;
            int dotSpot;
            String testName;
            
            while((entry = zis.getNextEntry()) != null) {
                System.out.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Extracting:_") +entry);
                int count;
                // final byte data[] = new byte[BUFFER];
                data = new byte[BUFFER];
                // write the files to the disk
                // FileOutputStream fos = new FileOutputStream(entry.getName());
                testName = baseDir.getCanonicalPath() + pathSep + entry.getName();
                
                if (DEBUG) {
                    System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Going_after_") + testName);
                }
                
                dotSpot = testName.lastIndexOf(pathSep);
                testFile = new File(testName.substring(0, dotSpot));
                if (!testFile.exists()) {
                    if (DEBUG) {
                        System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("We've_determined_that_") + testFile.toString() + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_doesn't_exist."));
                    }
                    testFile.mkdir();
                }
                fos = new FileOutputStream(baseDir.getCanonicalPath() + pathSep + entry.getName());
                
                dest = new BufferedOutputStream(fos, BUFFER);
                while ((count = zis.read(data, 0, BUFFER)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        } catch(Exception e) {
            e.printStackTrace();
            // return ARCHIVE_ERROR;
            retVal = ARCHIVE_ERROR;
        }
        
        // return SUCCESSFUL;
        return retVal;
    }
    
    
    
    
    private File getBaseDir() {
        final String userDir = JMConfig.getInstance().getJMString(JMConfig.USERDIRECTORY);
//         File tempDir = new File(userDir);
//        File jmudDir = new File(tempDir.getParent());
//        File baseDir = new File(jmudDir.getParent());
//         File baseDir = new File(tempDir.getParent());
        final File baseDir = new File(userDir);
        return baseDir;
        
    }
    
    private void exportPrefFile() {
        
        final java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(this.getClass());
        try {
            final FileOutputStream out = new FileOutputStream(prefFile);
            prefs.exportNode(out);
            out.flush();
            out.close();
        } catch (Exception exc) {
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ImportExport.exportPrefFile()_error_") + exc);
            }
        }
    }
    
    private void importPrefFile() {
        
        final java.util.prefs.Preferences prefs = java.util.prefs.Preferences.userNodeForPackage(this.getClass());
        try {
            final FileInputStream inStrm = new FileInputStream(prefFile);
            // FileReader inStrm = new FileReader(prefFile);
            prefs.importPreferences(inStrm);
            inStrm.close();
        } catch (Exception exc) {
            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ImportExport.importPrefFile()_error_") + exc);
                exc.printStackTrace();
            }
        }
        
    }
    
}