/*
 * ExtWorldList.java
 *
 * Created on October 16, 2008, 8:48 PM
 */
package anecho.JamochaMUD;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
// import javax.swing.text.Document;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 *
 * @author  jeffnik
 */
public class ExtWorldList extends javax.swing.JDialog {

    /** Creates new form ExtWorldList
     * @param parent The parent frame of this dialogue
     * @param modal If this dialogue should be displayed modally.
     */
    public ExtWorldList(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

    // Download the list
    // downloadList();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        muList = new javax.swing.JList();
        nameTF = new javax.swing.JTextField();
        addressTF = new javax.swing.JTextField();
        portTF = new javax.swing.JTextField();
        nameLabel = new javax.swing.JLabel();
        addressLabel = new javax.swing.JLabel();
        portLabel = new javax.swing.JLabel();
        ratingLabel = new javax.swing.JLabel();
        descL = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        connectB = new javax.swing.JButton();
        importB = new javax.swing.JButton();
        cancelB = new javax.swing.JButton();
        muDescSP = new javax.swing.JScrollPane();
        muDescTP = new javax.swing.JTextPane();
        worldListLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Import Worlds");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setMinimumSize(new java.awt.Dimension(500, 500));
        getContentPane().setLayout(new java.awt.GridBagLayout());

        muList.setModel(worldListModel);
        muList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle"); // NOI18N
        muList.setToolTipText(bundle.getString("ExtWorldListmuList")); // NOI18N
        muList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                muListValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(muList);
        muList.getAccessibleContext().setAccessibleName(bundle.getString("ExtWorldListListName")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jScrollPane1, gridBagConstraints);

        nameTF.setEditable(false);
        nameTF.setToolTipText(bundle.getString("ExtWorldListnameToolTip")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        getContentPane().add(nameTF, gridBagConstraints);

        addressTF.setEditable(false);
        addressTF.setToolTipText(bundle.getString("ExtWorldListaddressToolTip")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        getContentPane().add(addressTF, gridBagConstraints);

        portTF.setEditable(false);
        portTF.setToolTipText(bundle.getString("ExtWorldListPortToolTip")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        getContentPane().add(portTF, gridBagConstraints);

        nameLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListNameLabelMnemonic").charAt(0));
        nameLabel.setLabelFor(nameTF);
        nameLabel.setText("Name:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        getContentPane().add(nameLabel, gridBagConstraints);

        addressLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListAddressLabelMnemonic").charAt(0));
        addressLabel.setLabelFor(addressTF);
        addressLabel.setText("Address:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        getContentPane().add(addressLabel, gridBagConstraints);

        portLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListPortLabelMnemonic").charAt(0));
        portLabel.setLabelFor(portTF);
        portLabel.setText("Port:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        getContentPane().add(portLabel, gridBagConstraints);

        ratingLabel.setText("Rating:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        getContentPane().add(ratingLabel, gridBagConstraints);

        descL.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListDescLabelMnemonic").charAt(0));
        descL.setLabelFor(muDescTP);
        descL.setText("Description:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        getContentPane().add(descL, gridBagConstraints);

        connectB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListConnectButton").charAt(0));
        connectB.setText("Connect");
        connectB.setToolTipText(bundle.getString("ExtWorldListConnectButtonToolTip")); // NOI18N
        connectB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                connectBMouseClicked(evt);
            }
        });
        buttonPanel.add(connectB);

        importB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListImportButtonMnemonic").charAt(0));
        importB.setText("Import Only");
        importB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                importBMouseClicked(evt);
            }
        });
        buttonPanel.add(importB);

        cancelB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListCancelButtonMnemonic").charAt(0));
        cancelB.setText("Cancel");
        cancelB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                cancelBMouseClicked(evt);
            }
        });
        buttonPanel.add(cancelB);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        getContentPane().add(buttonPanel, gridBagConstraints);

        muDescTP.setText("When you select a MU* from the list above its description (if available) will appear here.  For remote web pages there may be a noticable delay.");
        muDescTP.setMinimumSize(new java.awt.Dimension(6, 100));
        muDescSP.setViewportView(muDescTP);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 3, 0, 3);
        getContentPane().add(muDescSP, gridBagConstraints);

        worldListLabel.setDisplayedMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("ExtWorldListWorldListLabelMnemonic").charAt(0));
        worldListLabel.setLabelFor(muList);
        worldListLabel.setText("Available worlds:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(worldListLabel, gridBagConstraints);

        getAccessibleContext().setAccessibleDescription(bundle.getString("ExtWorldListAccessibleDescription")); // NOI18N

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void cancelBMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cancelBMouseClicked
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_cancelBMouseClicked

    private void importBMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_importBMouseClicked
        addWorld();
    }//GEN-LAST:event_importBMouseClicked

    private void connectBMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_connectBMouseClicked
        connectToWorld();
    }//GEN-LAST:event_connectBMouseClicked

    private void muListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_muListValueChanged
        updateMUInfo();
    }//GEN-LAST:event_muListValueChanged

    /** This is the generic call to gather the MU* list.
     * The list is downloaded in this method and then parsed in the appropriate
     * style depending on the site it came from
     * 
     */
    public void downloadList() {
        // Download the MUD list file

        // Check to see if an address has been defined
        if (listAddress.equals("")) {
            JOptionPane.showMessageDialog(this, "No address has be provided for the MU* list.", "No list address", JOptionPane.ERROR_MESSAGE);
            return;
        }

        // Grab the file via HTTP
        URL listURL;
        URLConnection listConn;
        InputStream listInput;

        try {
            // listURL = new URL("http://" + listAddress);
            listURL = new URL(listAddress);
            listConn = listURL.openConnection();
            listInput = listConn.getInputStream();

        } catch (Exception urlExc) {
            JOptionPane.showMessageDialog(this, "Bad address provided for MU* list.", "Bad address", JOptionPane.ERROR_MESSAGE);

            if (DEBUG) {
                System.err.println("ExtWorldList.getMudListsList() error: " + urlExc);
            }

            return;
        }

        try {
            final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            final DocumentBuilder builder = factory.newDocumentBuilder();
            final org.w3c.dom.Document doc = builder.parse(listInput);
            doc.getDocumentElement().normalize();

            Vector worldList;

            // Determine the type of list we're importing
            final String listType = JMConfig.getInstance().getJMString(JMConfig.MUDLISTTYPE).toLowerCase();
            
            if (listType.equals("mudlists"))  {
                worldList = getMudListsList(doc);
            } else {
                worldList = this.getUndefinedList(doc);
            }
            
            // Write out the list
            displayList(worldList);

        } catch (Exception xmlExc) {
            if (DEBUG) {
                System.err.println("ExtWorldList.getList XML error: " + xmlExc);
            }

            return;
        }


    }

    /** This method parses lists received from MudLists.com
     * In the future most of the parsing method can be broken out and only the 
     * specific tag names need be here
     * 
     */
    private Vector getMudListsList(final org.w3c.dom.Document xmlDoc) {

        final String worldTag = "Muds";
        final String worldNameTag = "Name";
        final String worldAddressTag = "Address";
        final String worldPortTag = "Port";
        final String worldRatingTag = "Rating";
        final String worldDescTag = "Info";

        return parseMudList(xmlDoc, worldTag, worldNameTag, worldAddressTag, worldPortTag, worldRatingTag, worldDescTag);
    }

    /**
     * Parse the elements provided doing only the simplest match of name, address, and port
     * @param xmlDoc
     * @return
     */
    private Vector getUndefinedList(final org.w3c.dom.Document xmlDoc) {
        Vector retVect = new Vector();

        final String orgStr = JMConfig.getInstance().getJMString(JMConfig.MANUALEXTLIST);

        final String[] splitStr = orgStr.split(":");

        // The given string must split into world, name, address, and port or we'll fail
        if (splitStr.length == 4) {
            retVect = parseMudList(xmlDoc, splitStr[0], splitStr[1], splitStr[2], splitStr[3], "", "");
        } else {
            // The given "schema" is unusable.  Let the user know.
            JOptionPane.showMessageDialog(this, "The given XML tags are not valid,\nremote list not loaded.", "Invalid XML tags", JOptionPane.ERROR_MESSAGE);
        }

        return retVect;
    }

    /**
     * Parse the provided XML file using the provided tags
     * @param xmlDoc
     * @param worldTag
     * @param worldNameTag
     * @param worldAddressTag
     * @param worldPortTag
     * @return
     */
    private Vector parseMudList(
            final org.w3c.dom.Document xmlDoc,
            final String worldTag,
            final String worldNameTag,
            final String worldAddressTag,
            final String worldPortTag,
            final String worldRatingTag,
            final String worldDescTag) {
        final Vector worldList = new Vector();

        final NodeList listOfWorlds = xmlDoc.getElementsByTagName(worldTag);

        final int worldCount = listOfWorlds.getLength();

        if (DEBUG) {
            System.err.println("Our XML file contains " + worldCount + " tags <" + worldTag + ">");
        }

        for (int i = 0; i < worldCount; i++) {
            final World tempWorld = new World();

            final Node worldNode = listOfWorlds.item(i);

            final Element firstWorldElement = (Element) worldNode;

            // Get the world name
            final NodeList worldNameList = firstWorldElement.getElementsByTagName(worldNameTag);
            final Element worldNameElement = (Element) worldNameList.item(0);

            final NodeList worldNameNodeList = worldNameElement.getChildNodes();
            final String worldName = worldNameNodeList.item(0).getNodeValue();
            tempWorld.setWorldName(worldName);
            if (DEBUG) {
                System.out.println("World Name : " + worldName);
            }

            // get the world address
            final NodeList worldAddressList = firstWorldElement.getElementsByTagName(worldAddressTag);
            final Element worldAddressElement = (Element) worldAddressList.item(0);

            final NodeList worldAddressNodeList = worldAddressElement.getChildNodes();
            final String worldAddress = worldAddressNodeList.item(0).getNodeValue();
            tempWorld.setAddress(worldAddress);
            if (DEBUG) {
                System.out.println("World Address : " + worldAddress);
            }

            // get the world port
            final NodeList worldPortList = firstWorldElement.getElementsByTagName(worldPortTag);
            final Element worldPortElement = (Element) worldPortList.item(0);

            final NodeList worldPortNodeList = worldPortElement.getChildNodes();
            final String worldPort = worldPortNodeList.item(0).getNodeValue();
            tempWorld.setPort(Integer.parseInt(worldPort));

            if (DEBUG) {
                System.out.println("World Port : " + worldPort);
            }

            // Check for the optional tags
            if (!worldDescTag.equals("")) {
                // Fill in the supplied description tags
                final NodeList worldDescList = firstWorldElement.getElementsByTagName(worldDescTag);
                final Element worldDescElement = (Element) worldDescList.item(0);

                final NodeList worldDescNodeList = worldDescElement.getChildNodes();
                final String worldDesc = worldDescNodeList.item(0).getNodeValue();
                tempWorld.setNotes(worldDesc);
            }

            worldList.addElement(tempWorld);
        }

        if (DEBUG) {
            System.err.println("ExtWorldList.getMudListsList.Completed downloading world list.");
        }

        return worldList;


    }

    /**
     * Set the address to download the lists from.  This needs to be a fully
     * qualified URL (including the target file)
     * @param address The address that contains the MU* list
     */
    public void setListAddress(final String address) {
        if (DEBUG) {
            System.err.println("ExtWorldList.setListAddress set to " + address);
        }

        listAddress = address;
    }

    /**
     * Return the current address used for downloading the lists
     * @return Returns a string of the current list address
     */
    public String getListAddress() {
        return listAddress;
    }

    /** Set the connect world and dismiss this dialogue */
    private void connectToWorld() {
        if (muList.getSelectedIndex() > -1) {
            connectWorldVar = (World) muList.getSelectedValue();
        }

        this.setVisible(false);
    }

    /**
     * 
     * @return
     */
    public World getConnectWorld() {
        return connectWorldVar;
    }

    /** This method adds the world to the user's permanent list
     * 
     */
    private void addWorld() {
        final World tempWorld = (World) muList.getSelectedValue();

        addWorldVar = tempWorld;

        this.setVisible(false);
    }

    /**
     * This method returns the world a user has selected to export
     * 
     * @return
     */
    public World getAddWorld() {
        return addWorldVar;
    }

    /** Update the display with the given list of worlds
     * 
     * @param worldList A vector of World objects
     */
    private void displayList(final Vector worldList) {
        if (worldListModel == null) {
            worldListModel = new DefaultListModel();
        }

        // empty any existing elements first
        worldListModel.removeAllElements();

        // Add the elements
        if (!worldList.isEmpty()) {
            final int len = worldList.size();

            for (int i = 0; i < len; i++) {
                worldListModel.addElement((World) worldList.elementAt(i));
            }
        }
    }

    /**
     * This method updates the MU* details when the user clicks on a world
     * from the list
     */
    private void updateMUInfo() {
        final World tempWorld = (World) muList.getSelectedValue();

        nameTF.setText(tempWorld.getWorldName());
        addressTF.setText(tempWorld.getAddress());
        portTF.setText(Integer.toString(tempWorld.getPort()));
        
        String tempDesc = tempWorld.getNotes();
        
        if (tempDesc != null && !tempDesc.equals("")) {
        
        try {
            // Try to show the given information as a URL
            // muDescTP.setText("Loading " + tempDesc);
            descL.setText("Loading...");
            URL tempUrl = new URL(tempDesc);
            muDescTP.setPage(tempUrl);
            descL.setText("Description");
            muDescTP.setCaretPosition(0);
            
        } catch (Exception exc)  {
            // Set the given description as plain text
            muDescTP.setText(tempDesc);
        }
        }
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel addressLabel;
    private javax.swing.JTextField addressTF;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelB;
    private javax.swing.JButton connectB;
    private javax.swing.JLabel descL;
    private javax.swing.JButton importB;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane muDescSP;
    private javax.swing.JTextPane muDescTP;
    private javax.swing.JList muList;
    private javax.swing.JLabel nameLabel;
    private javax.swing.JTextField nameTF;
    private javax.swing.JLabel portLabel;
    private javax.swing.JTextField portTF;
    private javax.swing.JLabel ratingLabel;
    private javax.swing.JLabel worldListLabel;
    // End of variables declaration//GEN-END:variables
    /** The fully qualified Internet address for the mu* list */
    private String listAddress = "";
    /** Enable and disable debugging output */
    private static final boolean DEBUG = false;
    /** The list model used for displaying worlds */
    private transient DefaultListModel worldListModel = new DefaultListModel();
    /** The world to be used if the user has chosen to add the world to the existing list */
    private transient World addWorldVar;
    /** The world to use if the user has chosen to connect */
    private transient World connectWorldVar;
}
