/*
 * AddEditWorld.java
 *
 * Created on April 9, 2006, 4:57 PM
 *
 * JamochaMUD, a Muck/Mud client program
 * Copyright (C) 1998-2009 Jeff Robinson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

 
package anecho.JamochaMUD;

import anecho.gui.EasyTreeIconRenderer;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

/**
 * AddEditWorld is a class that displays saved worlds and characters
 * in a tree format.  It allows for editing of this information and
 * connection to the different worlds.  This class is a replacement
 * for the older MuckConn class.
 * $Id: AddEditWorld.java,v 1.38 2009/09/16 02:55:23 jeffnik Exp $
 * @author J. Robinson
 */
public class AddEditWorld extends javax.swing.JDialog {

    /** Creates new form AddEditWorld */
    public AddEditWorld() {
        super(MuckMain.getInstance().getMainFrame(), true);

        initComponents();

        final java.awt.Point tPoint = anecho.gui.PosTools.findCenter();
        // final java.awt.Dimension tSize = this.size();
        final java.awt.Dimension tSize = this.getSize();
        this.setLocation(tPoint.x - (int) (tSize.width / 2), tPoint.y - (int) (tSize.height / 2));

        readWorlds();

        updateInfoForm();

        loadCodePages();
        
        loadRemoteBanner();

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        javax.swing.JPanel worldTreePanel = new javax.swing.JPanel();
        javax.swing.JScrollPane worldScrollPane = new javax.swing.JScrollPane();
        // optionRoot = new DefaultMutableTreeNode("Worlds");
        worldTreeModel = new DefaultTreeModel(optionRoot);
        worldTree = new javax.swing.JTree(optionRoot);
        buildTree();
        // EasyTreeIconRenderer renderer = (EasyTreeIconRenderer)worldTree.getCellRenderer();
        EasyTreeIconRenderer renderer = new EasyTreeIconRenderer();
        worldTree.setCellRenderer(renderer);
        //renderer.addIcon("Test",new ImageIcon(AddEditWorld.class.getResource("icons/22/import.png")));
        //DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)worldTree.getCellRenderer();
        //UIManager.put("Tree.leafIcon", new ImageIcon(AddEditWorld.class.getResource("icons/22/import.png")));
        //UIManager.put("Tree.openIcon", new ImageIcon(AddEditWorld.class.getResource("icons/22/import.png")));
        //UIManager.put("Tree.closedIcon", new ImageIcon(AddEditWorld.class.getResource("icons/22/import.png")));
        javax.swing.JPanel worldButtonPanel = new javax.swing.JPanel();
        addB = new javax.swing.JButton();
        delB = new javax.swing.JButton();
        worldTreeLabel = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        connB = new javax.swing.JButton();
        javax.swing.JButton saveB = new javax.swing.JButton();
        cancelB = new javax.swing.JButton();
        infoPanel = new javax.swing.JPanel();
        introductionPanel = new javax.swing.JPanel();
        addWorldL = new javax.swing.JLabel();
        addCharL = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        charInstTA = new javax.swing.JTextArea();
        jScrollPane1 = new javax.swing.JScrollPane();
        javax.swing.JTextArea worldInstTA = new javax.swing.JTextArea();
        titlePanel = new javax.swing.JPanel();
        jamochaTitlePanel = new javax.swing.JPanel();
        jamochaImageL = new javax.swing.JLabel();
        javax.swing.JLabel titleL = new javax.swing.JLabel();
        externalTitlePanel = new javax.swing.JPanel();
        extImageL = new javax.swing.JLabel();
        addListMuButton = new javax.swing.JButton();
        javax.swing.JPanel worldPanel = new javax.swing.JPanel();
        javax.swing.JPanel worldInfoPanel = new javax.swing.JPanel();
        sslCB = new javax.swing.JCheckBox();
        mPortTF = new javax.swing.JTextField();
        muPortLabel = new javax.swing.JLabel();
        muAddressLabel = new javax.swing.JLabel();
        muNameLabel = new javax.swing.JLabel();
        mAddressTF = new javax.swing.JTextField();
        mNameTF = new javax.swing.JTextField();
        advertPanel = new javax.swing.JPanel();
        jmudAdvert = new javax.swing.JPanel();
        advert = new javax.swing.JLabel();
        mudlistAdvert = new javax.swing.JPanel();
        javax.swing.JLabel rankLabel = new javax.swing.JLabel();
        mudlistLabel = new javax.swing.JLabel();
        worldOverrideCB = new javax.swing.JCheckBox();
        codePage = new anecho.gui.JMappedComboBox();
        addCharB = new javax.swing.JButton();
        javax.swing.JPanel worldDescPanel = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        javax.swing.JTextArea worldDescriptionTA = new javax.swing.JTextArea();
        javax.swing.JLabel worldDescLabel = new javax.swing.JLabel();
        javax.swing.JPanel worldNotesPanel = new javax.swing.JPanel();
        javax.swing.JScrollPane worldNotesPane = new javax.swing.JScrollPane();
        muNotesTA = new javax.swing.JTextArea();
        javax.swing.JLabel worldNotesLabel = new javax.swing.JLabel();
        charPanel = new javax.swing.JPanel();
        charNotesL = new javax.swing.JLabel();
        charNotes = new javax.swing.JScrollPane();
        characterNotes = new javax.swing.JTextArea();
        charInfoPanel = new javax.swing.JPanel();
        nameL = new javax.swing.JLabel();
        charName = new javax.swing.JTextField();
        charTypeCB = new javax.swing.JComboBox();
        passwordL = new javax.swing.JLabel();
        charAutoLogin = new javax.swing.JCheckBox();
        connTypeCB = new anecho.gui.JMappedComboBox();
        charPassword = new javax.swing.JPasswordField();
        typeLabel = new javax.swing.JLabel();
        logoLabel = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle"); // NOI18N
        setTitle(bundle.getString("AddEditWorld.title")); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        worldTreePanel.setLayout(new java.awt.GridBagLayout());

        worldTree.setToolTipText(bundle.getString("AddEditWorld.worldTree.toolTipText")); // NOI18N
        worldTree.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                worldTreeMouseClicked(evt);
            }
        });
        worldScrollPane.setViewportView(worldTree);
        worldTree.getAccessibleContext().setAccessibleName(bundle.getString("AddEditWorld.worldTree.AccessibleContext.accessibleName")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldTreePanel.add(worldScrollPane, gridBagConstraints);

        worldButtonPanel.setLayout(new java.awt.GridBagLayout());

        addB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/icons/22/add.png"))); // NOI18N
        addB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/gui/guiBundle").getString("AddWorldMneumonic").charAt(0));
        addB.setText(bundle.getString("AddEditWorld.AddWorld")); // NOI18N
        addB.setToolTipText(bundle.getString("AddWorldToolTip")); // NOI18N
        addB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addBMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(1, 3, 1, 3);
        worldButtonPanel.add(addB, gridBagConstraints);

        delB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/icons/22/delete.png"))); // NOI18N
        delB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/gui/guiBundle").getString("DeleteWorldMneumonic").charAt(0));
        delB.setText(bundle.getString("AddEditWorld.delB.text_1")); // NOI18N
        delB.setToolTipText(bundle.getString("AddEditWorld.delB.toolTipText_1")); // NOI18N
        delB.setEnabled(false);
        delB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                delBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldButtonPanel.add(delB, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        worldTreePanel.add(worldButtonPanel, gridBagConstraints);

        worldTreeLabel.setLabelFor(worldTree);
        worldTreeLabel.setText(bundle.getString("AddEditWorld.worldTreeLabel.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        worldTreePanel.add(worldTreeLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(7, 7, 3, 3);
        getContentPane().add(worldTreePanel, gridBagConstraints);

        buttonPanel.setLayout(new java.awt.GridBagLayout());

        connB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/icons/22/connect_established.png"))); // NOI18N
        connB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/gui/guiBundle").getString("ConnectButtonMneumonic").charAt(0));
        connB.setText(bundle.getString("AddEditWorld.connB.text_1")); // NOI18N
        connB.setToolTipText(bundle.getString("ConnectButtonToolTip")); // NOI18N
        connB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                connBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        buttonPanel.add(connB, gridBagConstraints);

        saveB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/icons/22/filesave.png"))); // NOI18N
        saveB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/gui/guiBundle").getString("SaveButtonMneumonic").charAt(0));
        saveB.setText(bundle.getString("AddEditWorld.saveB.text_1")); // NOI18N
        saveB.setToolTipText(bundle.getString("SaveToolTip")); // NOI18N
        saveB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        buttonPanel.add(saveB, gridBagConstraints);

        cancelB.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/icons/22/connect_no.png"))); // NOI18N
        cancelB.setMnemonic(java.util.ResourceBundle.getBundle("anecho/gui/guiBundle").getString("DontConnectButtonMneumonic").charAt(0));
        cancelB.setText(bundle.getString("AddEditWorld.cancelB.text_1")); // NOI18N
        cancelB.setToolTipText(bundle.getString("DontConnectToolTip")); // NOI18N
        cancelB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelBActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 2, 0, 2);
        buttonPanel.add(cancelB, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 7, 7, 7);
        getContentPane().add(buttonPanel, gridBagConstraints);

        infoPanel.setLayout(new java.awt.CardLayout());

        introductionPanel.setLayout(new java.awt.GridBagLayout());

        addWorldL.setFont(new java.awt.Font("Dialog", 1, 11));
        addWorldL.setLabelFor(worldInstTA);
        addWorldL.setText(bundle.getString("AddEditWorld.addWorldL.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        introductionPanel.add(addWorldL, gridBagConstraints);

        addCharL.setFont(new java.awt.Font("Dialog", 1, 11));
        addCharL.setLabelFor(charInstTA);
        addCharL.setText(bundle.getString("AddEditWorld.addCharL.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        introductionPanel.add(addCharL, gridBagConstraints);

        charInstTA.setColumns(20);
        charInstTA.setEditable(false);
        charInstTA.setLineWrap(true);
        charInstTA.setRows(5);
        charInstTA.setText(bundle.getString("AddEditWorld.charInstTA.text_1")); // NOI18N
        charInstTA.setWrapStyleWord(true);
        jScrollPane2.setViewportView(charInstTA);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        introductionPanel.add(jScrollPane2, gridBagConstraints);

        worldInstTA.setColumns(20);
        worldInstTA.setEditable(false);
        worldInstTA.setLineWrap(true);
        worldInstTA.setRows(5);
        worldInstTA.setText(bundle.getString("AddEditWorld.worldInstTA.text_1")); // NOI18N
        worldInstTA.setWrapStyleWord(true);
        jScrollPane1.setViewportView(worldInstTA);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weighty = 0.2;
        introductionPanel.add(jScrollPane1, gridBagConstraints);

        titlePanel.setLayout(new java.awt.CardLayout());

        jamochaTitlePanel.setLayout(new java.awt.GridBagLayout());

        jamochaImageL.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/JMUD_title_trans.png"))); // NOI18N
        jamochaTitlePanel.add(jamochaImageL, new java.awt.GridBagConstraints());

        titleL.setText(bundle.getString("AddEditWorld.titleL.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jamochaTitlePanel.add(titleL, gridBagConstraints);

        titlePanel.add(jamochaTitlePanel, "JamochaMUDTitle");

        externalTitlePanel.setLayout(new java.awt.GridBagLayout());

        extImageL.setText(bundle.getString("AddEditWorld.extImageL.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        externalTitlePanel.add(extImageL, gridBagConstraints);

        addListMuButton.setText(bundle.getString("AddEditWorld.addListMuButton.text")); // NOI18N
        addListMuButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addListMuButtonMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 0, 0);
        externalTitlePanel.add(addListMuButton, gridBagConstraints);

        titlePanel.add(externalTitlePanel, "ExternalListTitle");

        introductionPanel.add(titlePanel, new java.awt.GridBagConstraints());

        infoPanel.add(introductionPanel, "IntroCard");

        worldPanel.setName("WorldCardPanel"); // NOI18N
        worldPanel.setLayout(new java.awt.GridBagLayout());

        worldInfoPanel.setName("card2"); // NOI18N
        worldInfoPanel.setLayout(new java.awt.GridBagLayout());

        sslCB.setText(bundle.getString("AddEditWorld.sslCB.text")); // NOI18N
        sslCB.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        sslCB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 7, 3);
        worldInfoPanel.add(sslCB, gridBagConstraints);

        mPortTF.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldInfoPanel.add(mPortTF, gridBagConstraints);

        muPortLabel.setLabelFor(mPortTF);
        muPortLabel.setText(bundle.getString("AddEditWorld.muPortLabel.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 0);
        worldInfoPanel.add(muPortLabel, gridBagConstraints);

        muAddressLabel.setLabelFor(mAddressTF);
        muAddressLabel.setText(bundle.getString("AddEditWorld.muAddressLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 0);
        worldInfoPanel.add(muAddressLabel, gridBagConstraints);

        muNameLabel.setLabelFor(mNameTF);
        muNameLabel.setText(bundle.getString("AddEditWorld.muNameLabel.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 0);
        worldInfoPanel.add(muNameLabel, gridBagConstraints);

        mAddressTF.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        worldInfoPanel.add(mAddressTF, gridBagConstraints);

        mNameTF.setColumns(20);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldInfoPanel.add(mNameTF, gridBagConstraints);

        advertPanel.setLayout(new java.awt.CardLayout());

        jmudAdvert.setLayout(new java.awt.GridBagLayout());

        advert.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/JMUD_title_trans.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
        jmudAdvert.add(advert, gridBagConstraints);

        advertPanel.add(jmudAdvert, "card2");

        mudlistAdvert.setLayout(new java.awt.GridBagLayout());

        rankLabel.setText(bundle.getString("AddEditWorld.rankLabel.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        mudlistAdvert.add(rankLabel, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        mudlistAdvert.add(mudlistLabel, gridBagConstraints);

        advertPanel.add(mudlistAdvert, "card3");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        worldInfoPanel.add(advertPanel, gridBagConstraints);

        worldOverrideCB.setText(bundle.getString("AddEditWorld.worldOverrideCB.text")); // NOI18N
        worldOverrideCB.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                worldOverrideCBItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        worldInfoPanel.add(worldOverrideCB, gridBagConstraints);

        codePage.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        worldInfoPanel.add(codePage, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldPanel.add(worldInfoPanel, gridBagConstraints);

        addCharB.setText(bundle.getString("AddEditWorld.addCharB.text_1")); // NOI18N
        addCharB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addCharBMouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 0);
        worldPanel.add(addCharB, gridBagConstraints);

        worldDescPanel.setLayout(new java.awt.GridBagLayout());

        jScrollPane3.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);

        worldDescriptionTA.setColumns(20);
        worldDescriptionTA.setRows(5);
        jScrollPane3.setViewportView(worldDescriptionTA);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldDescPanel.add(jScrollPane3, gridBagConstraints);

        worldDescLabel.setLabelFor(worldDescriptionTA);
        worldDescLabel.setText(bundle.getString("AddEditWorld.worldDescLabel.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 0);
        worldDescPanel.add(worldDescLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldPanel.add(worldDescPanel, gridBagConstraints);

        worldNotesPanel.setLayout(new java.awt.GridBagLayout());

        muNotesTA.setColumns(30);
        muNotesTA.setLineWrap(true);
        muNotesTA.setRows(5);
        muNotesTA.setWrapStyleWord(true);
        worldNotesPane.setViewportView(muNotesTA);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.25;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        worldNotesPanel.add(worldNotesPane, gridBagConstraints);

        worldNotesLabel.setLabelFor(muNotesTA);
        worldNotesLabel.setText(bundle.getString("AddEditWorld.worldNotesLabel.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        worldNotesPanel.add(worldNotesLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        worldPanel.add(worldNotesPanel, gridBagConstraints);

        infoPanel.add(worldPanel, "card2");

        charPanel.setName("CharacterCardPanel"); // NOI18N
        charPanel.setLayout(new java.awt.GridBagLayout());

        charNotesL.setText(bundle.getString("AddEditWorld.charNotesL.text_1")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        charPanel.add(charNotesL, gridBagConstraints);

        characterNotes.setColumns(20);
        characterNotes.setRows(5);
        charNotes.setViewportView(characterNotes);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        charPanel.add(charNotes, gridBagConstraints);

        charInfoPanel.setLayout(new java.awt.GridBagLayout());

        nameL.setText(bundle.getString("AddEditWorld.nameL.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 3);
        charInfoPanel.add(nameL, gridBagConstraints);

        charName.setColumns(15);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 3, 3);
        charInfoPanel.add(charName, gridBagConstraints);

        charTypeCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Character", "Puppet" }));
        charTypeCB.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        charInfoPanel.add(charTypeCB, gridBagConstraints);

        passwordL.setText(bundle.getString("AddEditWorld.passwordL.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        charInfoPanel.add(passwordL, gridBagConstraints);

        charAutoLogin.setText(bundle.getString("AddEditWorld.charAutoLogin.text")); // NOI18N
        charAutoLogin.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        charAutoLogin.setMargin(new java.awt.Insets(0, 0, 0, 0));
        charAutoLogin.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                charAutoLoginStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        charInfoPanel.add(charAutoLogin, gridBagConstraints);

        connTypeCB.setEditable(true);
        connTypeCB.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "connect $n $p" }));
        connTypeCB.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        charInfoPanel.add(connTypeCB, gridBagConstraints);

        charPassword.setText(bundle.getString("AddEditWorld.charPassword.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        charInfoPanel.add(charPassword, gridBagConstraints);

        typeLabel.setText(bundle.getString("AddEditWorld.typeLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        charInfoPanel.add(typeLabel, gridBagConstraints);

        logoLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/JMUD_title_trans.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        charInfoPanel.add(logoLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 0, 0);
        charPanel.add(charInfoPanel, gridBagConstraints);

        infoPanel.add(charPanel, "card3");

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.6;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(7, 3, 3, 7);
        getContentPane().add(infoPanel, gridBagConstraints);

        getAccessibleContext().setAccessibleDescription(bundle.getString("AddEditWorldAccessibleDescription")); // NOI18N

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void charAutoLoginStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_charAutoLoginStateChanged
        connTypeCB.setEnabled(charAutoLogin.isSelected());
    }//GEN-LAST:event_charAutoLoginStateChanged

    private void delBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_delBActionPerformed
        deleteTreeItem();
    }//GEN-LAST:event_delBActionPerformed

    private void connBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_connBActionPerformed
        // This is to connect only, with-out saving.  We get a null pointer
        // exception if nothing on the world tree is selected, and this is "wrong"
        // as we shouldn't be basis this connect on the tree.
        // Fix Me XXX
        // connectToMU();
        connectWithOutWorld();
    }//GEN-LAST:event_connBActionPerformed

    private void saveBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveBActionPerformed
        saveInfo();
    }//GEN-LAST:event_saveBActionPerformed

    private void addBMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_addBMouseClicked
        addTreeItem(evt, WORLD);
    }//GEN-LAST:event_addBMouseClicked

    private void worldTreeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_worldTreeMouseClicked
        updateInfo();

        // If we have a double-click, connect to the given MU*
        if (evt.getClickCount() > 1) {
            connectToMU();
        }
        
    }//GEN-LAST:event_worldTreeMouseClicked

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        // If there are no worlds open already, we should terminate JamochaMUD
        // final JMConfig settings = JMConfig.getInstance();
        // final CHandler chandle = settings.getConnectionHandler();
        final CHandler chandle = CHandler.getInstance();

        if (chandle.totalConnections() < 1) {
            if (DEBUG) {
                System.err.println("AddEditWorld.formWindowClosed is terminating JamochaMUD.");
            }
            System.exit(0);
        }

        dontConnect();
    }//GEN-LAST:event_formWindowClosed

    private void cancelBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBActionPerformed
        dontConnect();
    }//GEN-LAST:event_cancelBActionPerformed

    private void addCharBMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_addCharBMouseClicked
        addTreeItem(evt);
    }//GEN-LAST:event_addCharBMouseClicked

    private void addListMuButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_addListMuButtonMouseClicked
        loadExternalList();
}//GEN-LAST:event_addListMuButtonMouseClicked

    private void worldOverrideCBItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_worldOverrideCBItemStateChanged
        changeCodepageState();
    }//GEN-LAST:event_worldOverrideCBItemStateChanged

    /**
     * This method enables or disables the codepage combo-box based on the state
     * of the code-page over-ride check-box
     */
    private void changeCodepageState() {
        final boolean state = worldOverrideCB.isSelected();
        codePage.setEnabled(state);
    }
    
    /**
     * This method makes a connection based on the information in the world-panel,
     * whether this world is part of the world-tree or not.
     */
    private void connectWithOutWorld() {
        // Check to see if a world or a character is currently showing

        // final Object tempNode = worldTree.getLastSelectedPathComponent();

        if ("".equals(mAddressTF.getText()) || "".equals(mPortTF.getText())) {
            if (DEBUG) {
                System.err.println("AddEditWorld.connectWithOutWorld(): We don't have any connection info.");
            }

            connectToMU();
        } else {

            // if (!"".equals(mAddressTF.getText()) && !"".equals(mPortTF.getText())) {

            if (DEBUG) {
                System.err.println("AddEditWorld.connectWithOutWorld found information in form.");
            }
            currentWorld.setWorldName(mNameTF.getText());
            currentWorld.setAddress(mAddressTF.getText());

            final int tempPort;

            try {
                tempPort = Integer.parseInt(mPortTF.getText());
            } catch (Exception numExc) {
                // Give the user an error about the provided port number.
                JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("The_port_provided_is_not_a_number.\nPlease_check_your_connection_information."), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Bad_port_number"), JOptionPane.ERROR_MESSAGE);
                return;
            }

            currentWorld.setPort(tempPort);
            currentWorld.setSSL(sslCB.isSelected());
            currentChar = null;

            hideConnector();
        }

    }

    /** Connect to the currently selected world */
    private void connectToMU() {
        // Get the selected node
        World tempWorld;
        MUChar tempChar = new MUChar();

        Object tempNode = worldTree.getLastSelectedPathComponent();

        if (tempNode == null || tempNode == this.optionRoot) {
            // Try to pull the information from the world information currently available

            // If we have all the information to create a new world then do it, otherwise throw the error information.
            final String tempAddress = mAddressTF.getText();
            final String tempName = mNameTF.getText();
            final String tempPort = mPortTF.getText();

            if (!tempAddress.equals("") && !tempName.equals("") && !tempPort.equals("")) {
                // Create a new world
                addWorldItem();

                // Fill in the proper world information
                mAddressTF.setText(tempAddress);
                mNameTF.setText(tempName);
                mPortTF.setText(tempPort);

                // Save the world information
                saveInfo();

                // Now set the tempWorld to the new node
                tempNode = worldTree.getLastSelectedPathComponent();

            } else {
                JOptionPane.showConfirmDialog(this, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Please_select_an_existing_world_or_fill_in_the_MU*_Address_and_MU*_Port_information_before_continuing."), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Please_select_a_world"), JOptionPane.DEFAULT_OPTION, JOptionPane.INFORMATION_MESSAGE);

                return;
            }
        }

        if (isWorld(tempNode)) {
            tempWorld = (World)tempNode;
            tempChar.setName(null); // Set the name to null so we don't try to use a character

            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Attempting_connection_to_world:_") + tempWorld.getWorldName());
            }

        } else {
        // Determine if the node is a world or character
//        try {
//            tempWorld = (World) tempNode;
//            tempChar.setName(null); // Set the name to null so we don't try to use a character
//
//            if (DEBUG) {
//                System.err.println("Attempting connection to world: " + tempWorld.getWorldName());
//            }
//        } catch (Exception castExc) {
            tempChar = (MUChar) tempNode;

            if (DEBUG) {
                System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Will_make_connection_to_world_using_character_") + tempChar.getName());
            }

            // Now determine the world this character belongs to
            // try {
            if (isWorld(tempChar.getParent())) {
                tempWorld = (World) tempChar.getParent();

                if (DEBUG) {
                    System.err.println(tempChar.getName() + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_connecting_to_") + tempWorld.getAddress());
                }

            // } catch (Exception worldExc) {
            } else {
                if (DEBUG) {
                    System.err.println("Error trying to locate parent of " + tempChar.getName());
                    // System.err.println("Error: " + worldExc);
                }

                // Create a new world to placate the initialisation errors
                tempWorld = new World();
            }

        }

        currentWorld = tempWorld;
        currentChar = tempChar;

        if (DEBUG) {
            System.err.println("Setting currentWorld to: " + currentWorld.getWorldName());
            System.err.println("Setting currentChar to: " + currentChar.getName());
        }

        hideConnector();
    }

    /**
     * Checks to see if the passed object is a World
     * @param tempNode the item to be checked
     * @return <code>true></code> This item is a world <code>false</code> This item is not a world
     */
    private boolean isWorld(final Object tempNode) {
        boolean result;
        
        if (tempNode instanceof World) {
            result = true;
        } else {
            result = false;
        }
        
        return result;
    }
    
    /**
     * Add a new item to the JTree where the type of item is already defined
     * to be either a WORLD or a CHARACTER
     * @param evt
     * @param type Indicates whether a world or character should be created
     */
    private void addTreeItem(final java.awt.event.MouseEvent evt, final int type) {
        if (type == WORLD) {
            addWorldItem();
        } else {
            addTreeItem(evt);
        }
    }

    /** Add either a new world or new character to our JTree */
    private void addTreeItem(java.awt.event.MouseEvent evt) {

        // Determine if there is anything selected right now.
        // If nothing is selected, default to the root which means adding a world
        final TreePath currentSelection = worldTree.getSelectionPath();

        // This is suspect... it may only function properly if the tree has not
        // had any nodes selected.  Fix Me XXX
        if (DEBUG) {
            if (currentSelection != null) {
                   final TreePath[] testSelection = worldTree.getSelectionPaths();
                   System.err.println("Current selection: " + testSelection);
            }
            System.err.println("Root: " + optionRoot.getPath());

        }
        
        if (currentSelection == null) {
            if (DEBUG) {
                System.err.println("AddEditWorld.addTreeItem current has no selected node.");
                System.err.println("We should add a world by default");
            }

            addWorldItem();
        } else {
            // I don't like this try block, but it will have to work for now.
            try {
                addCharacterItem(currentSelection);
            } catch (Exception charExc) {
                addWorldItem();
            }
        }

    }

    /** Add a world item to our Tree */
    private void addWorldItem() {
        final World tempWorld = new World();
        tempWorld.setWorldName(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Nothing"));
        tempWorld.setAddress(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("No_address"));
        tempWorld.setPort(0);

        addWorldItem(tempWorld);
    }

    /**
     * Adds the provided world to the world tree
     * @param tempWorld The world to be added
     */
    private void addWorldItem(final World tempWorld) {

        final int len = optionRoot.getChildCount();
        // final int treeCount = worldTree.getRowCount();

        if (DEBUG) {
            System.err.println("AddEditWorld.addWorldItem: optionRoot reports we have " + len + " children on our tree.");
            // System.err.println("AddEditWorld.addWorldItem: worldTree reports we have " + treeCount + "rows.");
            System.err.println(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("AddEditWorld.addWorldItem:_our_worldTreeModel_reports_we_have_") + worldTreeModel.getChildCount(optionRoot) + " children");
            System.err.println("AddEditWorld.addWorldItem: Dynamically collected root node says we have " + ((DefaultMutableTreeNode) worldTreeModel.getRoot()).getChildCount());
        }

        worldTreeModel.insertNodeInto(tempWorld, optionRoot, len);
        worldTree.updateUI();

        if (DEBUG) {
            System.err.println("After insertion we have " + optionRoot.getChildCount() + " children.");
        }

        // Select the newly created world, and then move focus to our editing area
        final TreePath treePath = new TreePath(worldTreeModel.getPathToRoot(tempWorld));
        worldTree.setSelectionPath(treePath);
        updateInfo();

        mNameTF.requestFocusInWindow();
    }

    /** Add a new character item to our Tree */
    private void addCharacterItem(final TreePath currentSelection) {
        if (DEBUG) {
            System.err.println("AddEditWorld.addCharacterItem()");
        }

        // Get the World node that is currently selected
        final World tempWorld = (World) (currentSelection.getLastPathComponent());

        // Create the new character
        final MUChar tempChar = new MUChar();
        tempChar.setName(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Nobody_yet"));
        // Assign the proper worldID to the character
        tempChar.setWorldID(tempWorld.getWorldID());


        // Insert the new character into our JTree
        worldTreeModel.insertNodeInto(tempChar, tempWorld, 0);
        worldTree.updateUI();

        // Focus on the new character
        final TreePath treePath = new TreePath(worldTreeModel.getPathToRoot(tempChar));
        worldTree.setSelectionPath(treePath);
        updateInfo();

        charName.requestFocusInWindow();
    }

    /** Delete the currently selected item from the Tree */
    private void deleteTreeItem() {
        final TreePath currentSelection = worldTree.getSelectionPath();

        if (currentSelection == null) {
            // There is currently no selected node on the JTree
            return;
        }

//        if (currentSelection != null) {
        final DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode) (currentSelection.getLastPathComponent());
        final MutableTreeNode parent = (MutableTreeNode) (currentNode.getParent());
        if (parent == null) {
            if (DEBUG) {
                System.err.println("AddEditWorld.deleteTreeItem() has no parent");
            }
        } else {
            if (DEBUG) {
                System.err.println("AddEditWorld.deleteTreeItem() Removing node.");
            }
            worldTreeModel.removeNodeFromParent(currentNode);
        }

        // The information fields should be cleared out on the right-hand side
        // when a selected item is deleted.
        // Fix Me XXX
        // mNameTF.setToolTipText("");
        updateInfo();

//        } else {
//            if (DEBUG) {
//                System.err.println("AddEditWorld.deleteTreeItem() has no current selection.");
//            }
//        }

        worldTree.updateUI();

        // Select next applicable node
        updateInfo();


    }

    /**
     * This method returns the user to the main JamochaMUD window
     * with-out making a connection to a new world
     */
    private void dontConnect() {
        currentWorld.setWorldName(null);

        hideConnector();

    }

    /**
     * This method hides the world connector and writes out the
     * worlds and characters to a file
     */
    private void hideConnector() {
        setVisible(false);
        // final JMConfig settings = JMConfig.getInstance();

        // Moved to CHandler.  May need to revert or remove XXX
//        final java.awt.Frame mmFrame = settings.getJMFrame(JMConfig.MUCKMAINFRAME);
//        if (!mmFrame.isVisible()) {
//            mmFrame.setVisible(true);
//        }
//        
//        settings.setJMValue(JMConfig.MUCKCONNVISIBLE, false);
//        
//        // Send the focus to our main program... just a nice thing to do
//        mmFrame.requestFocus();

        writeWorlds();
    // writeCharacters();
    }

    /** Read the worlds in from permanent storage.
     */
    private void readWorlds() {
        // Read in the worlds XML file
        final JMConfig settings = JMConfig.getInstance();
        boolean worldsExist = false;

        try {
            final FileInputStream fInStream = new FileInputStream(settings.getJMString(JMConfig.USERDIRECTORY) + TREEFILE);
            final BufferedInputStream bufInStream = new BufferedInputStream(fInStream);

            final XMLDecoder decoder = new XMLDecoder(bufInStream);
            worldTreeModel = (DefaultTreeModel) decoder.readObject();
            decoder.close();

            bufInStream.close();
            fInStream.close();

            // worldTreeModel.setRoot(optionRoot);

            worldTree.setModel(worldTreeModel);
            worldTree.updateUI();

            // Make certain to set optionRoot to our new root, or we'll have a big disconnect
            // between the model and the actual viewable tree
            optionRoot = (DefaultMutableTreeNode) worldTreeModel.getRoot();

            worldsExist = true;
        } catch (Exception treeExc) {
            if (DEBUG) {
                System.err.println("AddEditWorld error reading in XML worlds file.  Try importing old worlds?");
            }
        }

        // Try to read our list of worlds

        if (DEBUG) {
            System.err.println("AddEditWorld.readWorlds: Our optionRoot has " + optionRoot.getChildCount() + " children.");
        }

        if (!worldsExist) {
            // We have no worlds, and can therefore not have any characters
            if (DEBUG) {
                System.err.println("AddEditWorld.readWorlds: No worlds to read.");
            }

            // If we have no worlds, try to import old worlds instead
            importOldWorlds();

            return;
        }

        // Update the tree view to show all our info
        worldTree.expandRow(0);
        worldTree.updateUI();

        final int treeCount = worldTree.getRowCount();

        if (DEBUG) {
            System.err.println("AddEditWorld.readWorlds: worldTree.getRowCount returns " + treeCount + " rows.");
        }

        for (int i = 0; i < treeCount; i++) {
            worldTree.expandRow(i);
        }


    }

    /**
     * Write out an XML file containing the worlds and characters
     */
    private void writeWorlds() {
        // New method for saving JTree information to avoid serializing problems
        final JMConfig settings = JMConfig.getInstance();

        if (DEBUG) {
            System.err.println("AddEditWorld.writeWorlds(): writing out JTree to XML file.");
        }
        try {
            final XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(
                    new FileOutputStream(settings.getJMString(JMConfig.USERDIRECTORY) + TREEFILE)));

            encoder.writeObject(worldTreeModel);
            encoder.close();
        } catch (Exception exc) {
            System.err.println("AddEditWorld error trying to saving JTree to file.");
        }

        if (DEBUG) {
            System.err.println("AddEditWorld.writeWorlds(): complete.");
        }
    }

    /** Add all the nodes to our JTree of options */
    private void buildTree() {
    // Either fix me or remove me!
    }

    /** Bring up a dialogue to let the user select a list from an external source */
    private void loadExternalList() {
        final ExtWorldList extList = new ExtWorldList(MuckMain.getInstance().getMainFrame(), true);

        extList.setLocationRelativeTo(this);
        extList.setListAddress(JMConfig.getInstance().getJMString(JMConfig.EXTMUDLIST));
        extList.downloadList();

        extList.setVisible(true);

        final World connectWorld = extList.getConnectWorld();

        if (connectWorld != null) {
            // Connect to the new world
            currentWorld = connectWorld;
            currentChar = null;

            hideConnector();
        }

        final World addWorld = extList.getAddWorld();

        if (addWorld != null) {
            addWorldItem(addWorld);
        }
    }

    /**
     * Load the remote banner, usually used in co-branding JamochaMUD
     */
    private void loadRemoteBanner() {
        final String extMudImage = JMConfig.getInstance().getJMString(JMConfig.EXTMUDIMAGE);

        try {
            final URL imageURL = new URL(extMudImage);
            final ImageIcon icon = new ImageIcon(imageURL);

            // Check to make certain the image is not too large
            if (icon.getIconWidth() > 300) {
                final java.awt.Image tempImg = icon.getImage().getScaledInstance(300, -1, java.awt.Image.SCALE_SMOOTH);
                icon.setImage(tempImg);
            }

            // Check to make certain the image is not too tall
            if (icon.getIconHeight() > 50) {
                final java.awt.Image tempImg = icon.getImage().getScaledInstance(-1, 50, java.awt.Image.SCALE_SMOOTH);
                icon.setImage(tempImg);
            }

            extImageL.setIcon(icon);
            extImageL.setText("");
        } catch (Exception exc) {
            extImageL.setText(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Error_loading_image."));
        }

    }

    /** Enables or disables our auto-login style */
//    private void enableLoginStyle(final boolean state) {
////        loginL.setEnabled(state);
////        loginStyleCB.setEnabled(state);
//    }
    /**
     * Return the name of the currently selected world
     * @return Returns a string of containing the currently selected
     * World's name.
     */
    // public String getName() {
    public String getWorldName() {
        // String retStr = "nothing";
        String retStr;

        if (currentWorld == null) {
            retStr = "nothing";
        } else {
            retStr = currentWorld.getWorldName();
        }

        return retStr;
    }

    /**
     * Return the address of the currently selected World.
     * @return The address of the currently selected World.
     */
    public String getWorldAddress() {
        // String retStr = "nothing";
        String retStr;

        if (currentWorld == null) {
            retStr = "nothing";
        } else {
            retStr = currentWorld.getAddress();
        }

        return retStr;
    }

    /**
     * Returns the port number of the currently selected World.
     * @return Returns the port number of the currently selected World.
     */
    public int getWorldPort() {
        // int retPort = -1;
        int retPort;

        if (currentWorld == null) {
            retPort = -1;
        } else {
            retPort = currentWorld.getPort();
        }

        return retPort;
    }

    /**
     * Returns whether the currently selected world uses a secure (SSL)
     * connection.
     * @return <CODE>true</CODE> - this world uses a secure (SSL) connection
     * <CODE>false</CODE> - this world sends data unencrypted
     */
    public boolean isWorldSSL() {
        boolean retSSL;
        
        if (currentWorld != null) {
            retSSL = currentWorld.isSSL();
        } else {
            retSSL = false;
        }
        
        return retSSL;
    }

    /**
     * Returns the codepage to use for the selected world.
     * @return If the default codepage is not over-ridden, this string returns blank.  Otherwise this
     * string will return the codepage.
     */
    public String getCodepage() {
        String cp = "";

        if (currentWorld != null) {
            if (worldOverrideCB.isSelected()) {
                cp = codePage.getSelectedMap().toString();
            }
        }
        
        return cp;
    }
    
    /**
     * Returns a SimpleWorld object of the currently selected world
     * @return
     */
    public SimpleWorld getSelectedSimpleWorld() {
        SimpleWorld retWorld = new SimpleWorld();
        
        if (currentWorld != null) {
            // World specific information
            retWorld.setCodePage(currentWorld.getCodePage());
            retWorld.setOverrideCodepage(currentWorld.isOverride());
            retWorld.setSSL(currentWorld.isSSL());
            retWorld.setWorldAddress(currentWorld.getAddress());
            retWorld.setWorldName(currentWorld.getWorldName());
            retWorld.setWorldPort(currentWorld.getPort());
            
            // Character specific information
            retWorld.setConnectionString(this.getConnectionString());
            
        }   
        
        if (DEBUG) {
            System.err.println("AddEditWorld.getSelectedSimpleWorld: codePage Override: " + retWorld.isOverrideCodepage());
        }
        
        return retWorld;
    }
    
    /**
     * Return a complete connection string with the username and password inserted
     * @return Returns a string made up of the character's connection
     * string.  Any $n (username) or $p (password) variables
     * are also substituted for the actual entries and
     * made part of the return string.
     */
    public String getConnectionString() {
        String connString = "";

        if (charAutoLogin.isSelected() && currentChar != null) {
            connString = connTypeCB.getSelectedItem().toString();

            final String chName = currentChar.getName();
            final String charPass = currentChar.getPassword().toString();

            connString = connString.replaceAll("\\$n", chName);
            connString = connString.replaceAll("\\$p", charPass);

            if (DEBUG) {
                System.err.println("AddEditWorlds.getConnectionString() returns a connection string of: " + connString);
            }
        }

        return connString;
    }

    /**
     * Returns an integer representing the character type currently selected
     * @return
     */
    public int getCharacterType() {
        final int charType;

        if (currentChar == null) {
            charType = 0;  // Set as a normal character 
        } else {
            charType = currentChar.getCharType();
        }

        // final int charType = currentChar.getCharType();

        return charType;
    }

    /**
     * Returns the name of the character selected, or null if no character is selected
     * @return A string representing the chosen character name, or null if a world is selected
     */
    public String getCharacterName() {
        String retStr;

        if (currentChar == null) {
            retStr = "";
        } else {
            retStr = currentChar.getName();
        }

        return retStr;
    }

    /**
     * 
     */
    private void updateInfo() {
        // Update the shown info based on the item selected in the World JTree

        // Get the selected node
        final Object tempNode = worldTree.getLastSelectedPathComponent();

        // Determine if the node is a world or character
        // try {
        if (isWorld(tempNode)) {
            final World tempWorld = (World) tempNode;
            if (DEBUG) {
                System.err.println("We have cast this to World: " + tempWorld.getWorldName());
            }
            updateWorldForm(tempWorld);
        // } catch (Exception castExc) {
        } else {
            if (DEBUG) {
                System.err.println("Error casting " + tempNode + " to a world.");
            }

            // Most likely this is a character
            try {
                final MUChar tempChar = (MUChar) tempNode;
                if (DEBUG) {
                    System.err.println("AddEditWorld.updateInfo() have cast this to a Character:" + tempChar.getName());
                }
                updateCharacterForm(tempChar);
            } catch (Exception charExc) {
                if (DEBUG) {
                    System.err.println("AddEditWorld.updateInof() cast has failed for both a world and a character");

                }

                // Clear out all the text fields
                mNameTF.setText("");
                mAddressTF.setText("");
                mPortTF.setText("");
                sslCB.setSelected(false);
                muNotesTA.setText("");

                charName.setText("");
                charPassword.setText("");
                charAutoLogin.setSelected(false);
                characterNotes.setText("");
                charTypeCB.setSelectedIndex(0);

                // Show the user the introduction information page
                updateInfoForm();


            }

        }

    }

    /**
     * Show the user the introduction information
     */
    private void updateInfoForm() {
        final java.awt.CardLayout tempLayout = (java.awt.CardLayout) infoPanel.getLayout();
        tempLayout.show(infoPanel, "IntroCard");

        // Show the approriate title panel based on whether this version is co-branded
        final String extMudList = JMConfig.getInstance().getJMString(JMConfig.EXTMUDLIST);

        final java.awt.CardLayout titleLayout = (java.awt.CardLayout) titlePanel.getLayout();
        if (extMudList.equals("")) {
            titleLayout.show(titlePanel, "JamochaMUDTitle");
        } else {
            titleLayout.show(titlePanel, "ExternalListTitle");

//            String extMudImage = JMConfig.getInstance().getJMString(JMConfig.EXTMUDIMAGE);
//            
//            try {
//                URL imageURL = new URL(extMudImage);
//                ImageIcon icon = new ImageIcon(imageURL);
//                
//                // Check to make certain the image is not too large
//                if (icon.getIconWidth() > 240) {
//                    java.awt.Image tempImg = icon.getImage().getScaledInstance(240, -1, java.awt.Image.SCALE_SMOOTH);
//                    icon.setImage(tempImg);
//                }
//
//                // Check to make certain the image is not too tall
//                if (icon.getIconHeight() > 50) {
//                    java.awt.Image tempImg = icon.getImage().getScaledInstance(-1, 50, java.awt.Image.SCALE_SMOOTH);
//                    icon.setImage(tempImg);
//                }
//                
//                extImageL.setIcon(icon);
//                extImageL.setText("");
//            } catch (Exception exc) {
//                extImageL.setText("Error loading image.");
//            }
        }

        // Disable the delete world/character button
        delB.setEnabled(false);
    }

    /**
     * 
     * @param selWorld
     */
    private void updateWorldForm(final World selWorld) {
        // Ensure that the correct panel is showing
        final java.awt.CardLayout tempLayout = (java.awt.CardLayout) infoPanel.getLayout();
        tempLayout.show(infoPanel, "card2");
        if (DEBUG) {
            System.err.println("AddEditWorld.updateWorldForm() should be showing world panel");
        }

        // fill the form
        mNameTF.setText(selWorld.getWorldName());
        mAddressTF.setText(selWorld.getAddress());
        mPortTF.setText(Integer.toString(selWorld.getPort()));
        sslCB.setSelected(selWorld.isSSL());
        worldOverrideCB.setSelected(selWorld.isOverride());
        if (selWorld.getCodePage() != null) {
            codePage.setSelectedMap(selWorld.getCodePage());
        }
        muNotesTA.setText(selWorld.getNotes());

        delB.setEnabled(true);

    }

    /**
     * Update this character form to display information for the chosen character
     * @param selChar
     */
    private void updateCharacterForm(final MUChar selChar) {
        // Ensure the panel is showing
        final java.awt.CardLayout tempLayout = (java.awt.CardLayout) infoPanel.getLayout();
        // tempLayout.show(infoPanel, "CharacterCardPanel");
        tempLayout.show(infoPanel, "card3");

        if (DEBUG) {
            System.err.println("AddEditWorld.updateCharacterForm() should be showing character panel");
        }

        // fill the form
        charName.setText(selChar.getName());
        charPassword.setText(selChar.getPassword());
        characterNotes.setText(selChar.getNotes());
        charAutoLogin.setSelected(selChar.isAutoLogin());
        connTypeCB.setSelectedItem(selChar.getLoginStyle());
        charTypeCB.setSelectedIndex(selChar.getCharType());

        delB.setEnabled(true);

    }

    /** Save the current information in our form to our selected node */
    private void saveInfo() {
        // Get the selected node
        final Object tempNode = worldTree.getLastSelectedPathComponent();

        // Determine if the node is a world or character
        // try {
        if (isWorld(tempNode)) {
            final World tempWorld = (World) tempNode;
            if (DEBUG) {
                System.err.println("saveInfo has cast this to World: " + tempWorld.getWorldName());
            }
            saveWorldInfo(tempWorld);
        // } catch (Exception castExc) {
        } else {
            if (DEBUG) {
                System.err.println("saveInfo Error casting " + tempNode + " to a world.");
            }

            try {
                final MUChar tempChar = (MUChar) tempNode;
                if (DEBUG) {
                    System.err.println("AddEditWorld.saveInfo has cast this node to Char: " + tempChar.getName());
                }
                saveCharacterInfo(tempChar);
            } catch (Exception charExc) {
                if (DEBUG) {
                    System.err.println("AddEditWorld.saveInfo cannot cast " + tempNode + " to either a world or character.");
                }
            }
        }

    }

    /** Update the world object in our JTree with the information from the TextFields */
    private void saveWorldInfo(final World selWorld) {
        // Do a sanity check on our information
        int tempPort;

        try {
            tempPort = Integer.parseInt(mPortTF.getText());
        } catch (Exception numExc) {
            JOptionPane.showMessageDialog(this, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("The_port_provided_is_not_a_number._Please_check_your_connection_information."), java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Bad_port_number"), JOptionPane.ERROR_MESSAGE);
            return;
        }

        selWorld.setWorldName(mNameTF.getText());
        selWorld.setAddress(mAddressTF.getText());
        selWorld.setPort(tempPort);
        selWorld.setSSL(sslCB.isSelected());
        selWorld.setOverride(worldOverrideCB.isSelected());
        selWorld.setCodePage(codePage.getSelectedMap().toString());
        selWorld.setNotes(muNotesTA.getText());

        // Update the JTree view
        worldTree.updateUI();

        if (DEBUG) {
            System.err.println("Saved world information");
        }
    }

    /** Write the information from our character form into our tree node */
    private void saveCharacterInfo(final MUChar selChar) {

        // We have to collect the password and write it out in plain text.
        // Not secure, but JamochaMUD isn't intended for Supah-secret stuff!
        final StringBuffer pWord = new StringBuffer();
        final char[] charWord = charPassword.getPassword();

        final int len = charWord.length;
        for (int i = 0; i < len; i++) {
            if (DEBUG) {
                System.err.println("Appending password: " + charWord[i]);
            }
            pWord.append(charWord[i]);
        }

        if (DEBUG) {
            System.err.println("Total password is " + pWord.toString());
        }

        selChar.setName(charName.getText());
        selChar.setNotes(characterNotes.getText());
        selChar.setPassword(pWord.toString());
        selChar.setAutoLogin(charAutoLogin.isSelected());
        selChar.setLoginStyle((String) connTypeCB.getSelectedItem());
        selChar.setCharType(charTypeCB.getSelectedIndex());

        // Update the JTree to show changes
        worldTree.updateUI();
    }

    /** Import worlds from the format previously used by JamochaMUD */
    private void importOldWorlds() {
        // Vector muckList = new java.util.Vector(0, 1);
        final JMConfig settings = JMConfig.getInstance();
        final Vector muckList = settings.getJMVector(JMConfig.MUCKLIST);

        if (DEBUG) {
            System.err.println("AddEditWorld.importOldWorlds() attempting to import old-style MU settings");
        }

        World tempWorld;
        MuckInfo tempMU;

        final int listSize = muckList.size();

        // Check to see if there are worlds to import
        if (listSize > 0) {
            // There are worlds to possibly import.  We should ask the user first
            final int retVal = JOptionPane.showConfirmDialog(this,
                    java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Would_you_like_to_import_your_existing_worlds\ninto_this_version_of_JamochaMUD?"),
                    java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Import_existing_worlds?"),
                    JOptionPane.YES_NO_OPTION);

            if (retVal == JOptionPane.NO_OPTION) {
                return;
            }
        } else {
            // Is this return necessary?  Fix Me XXX
            return;
        }

        for (int i = 0; i < listSize; i++) {
            tempMU = (MuckInfo) muckList.elementAt(i);
            // We must create a new world each time or risk messing up our JTree
            tempWorld = new World();

            tempWorld.setWorldName(tempMU.getName());
            tempWorld.setAddress(tempMU.getAddress());
            tempWorld.setPort(tempMU.getPort());
            tempWorld.setSSL(tempMU.getSSL());

            if (DEBUG) {
                System.err.println("AddEditWorld.importOldWorlds() importing MU*: " + tempMU.getName());
            }

            // Insert the new world into our JTree
            worldTreeModel.insertNodeInto(tempWorld, optionRoot, optionRoot.getChildCount());

            if (DEBUG) {
                System.err.println("AddEditWorld.importOldWorlds() import successful.");
                System.err.println("There are now " + optionRoot.getChildCount() + " nodes on optionRoot.");
            }
        }

        worldTree.setModel(worldTreeModel);
        worldTree.updateUI();

    }

    /** This method will give the user the option to save the world
     * if a world has been passed to JamochaMUD via the command line
     * or Web Start.
     *
     * First we will check to see if the world already exists in our list
     * and if it does we can just skip the whole deal.  Otherwise we'll ask
     * the user what they want to do
     *
     * Fix Me XXX
     * @param muName
     * @param muAddress
     * @param muPort
     * @param useSSL 
     */
    public void checkWorld(final String muName, final String muAddress, final int muPort, final boolean useSSL) {

        if (DEBUG) {
            System.err.println("AddEditWorld.checkWorld() entered");
        }

        // Check to see if world exists.  We'll have to iterate through the JTree
        // Enumeration allChildren = optionRoot.breadthFirstEnumeration();
        final Enumeration allChildren = optionRoot.children();
        Object tempNode;
        World tempWorld;

        int count = 1;

        //iterate through the enumeration
        while (allChildren.hasMoreElements()) {
            //get the node
            if (DEBUG) {
                System.err.println("AddEditWorld.checkWorld() count is " + count);
            }

            tempNode = (DefaultMutableTreeNode) allChildren.nextElement();

            if (isWorld(tempNode)) {
                tempWorld = (World) tempNode;
                final String tempName = tempWorld.getWorldName();
                final String tempAddress = tempWorld.getAddress();
                final int tempPort = tempWorld.getPort();
                final boolean tempSSL = tempWorld.isSSL();

                if (DEBUG) {
                    System.err.println("Checking " + tempName + " versus " + muName);
                }

                if (muName.equals(tempName) && muAddress.equals(tempAddress) && muPort == tempPort && useSSL == tempSSL) {

                    if (DEBUG) {
                        System.err.println("AddEditWorld.checkWorld(): given world matches existing world.");
                    }

                    // This matches an existing world.  Alert the user
                    final String message = "A world named " + muName + "\nat " + muAddress + ":" + muPort + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("_already_exists._Do_you_still_want_to_add_this_world?");
                    final int choice = JOptionPane.showConfirmDialog(MuckMain.getInstance().getMainFrame(), message, java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("World_already_exists"), JOptionPane.YES_NO_OPTION, JOptionPane.INFORMATION_MESSAGE);

                    if (choice != JOptionPane.YES_OPTION) {
                        // The user has chosen not to add the world
                        if (DEBUG) {
                            System.err.println("AddEditWorld.checkWorld() user has opted not to add new world.");
                        }
                        return;
                    }

                }

            // } catch (Exception exc) {
            } else {
                return;
            }

            count++;

        }

        tempWorld = new World();
        tempWorld.setWorldName(muName);
        tempWorld.setAddress(muAddress);
        tempWorld.setPort(muPort);
        tempWorld.setSSL(useSSL);

        if (tempWorld != null) {

            if (DEBUG) {
                System.err.println("AddEditWorld.checkWorld(): tempWorld != null, adding");
            }
            // Create an empty world on the tree
            addWorldItem();

            // Manually fill out the required information in the GUI
            // (even though it isn't visible, it's just easier to do)
            mNameTF.setText(muName);
            mAddressTF.setText(muAddress);
            // mPortTF.setText(new Integer(muPort).toString());
            mPortTF.setText(Integer.toString(muPort));

            sslCB.setSelected(useSSL);

            // Save the info
            this.saveInfo();

            // Write out the information, and we're done!
            this.writeWorlds();

            final String message = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("A_world_named_") + muName + "\nat " + muAddress + ":" + muPort + java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("has_been_successfully_added.");
            JOptionPane.showMessageDialog(MuckMain.getInstance().getMainFrame(), message, "World added", JOptionPane.INFORMATION_MESSAGE);
        }


    }
    
    /**
     * This method populates the code page dialogue, mapping the CP numbers and translations
     */
    private void loadCodePages() {
        codePage.addItem("\"Extended ASCII\" (Codepage 437)", "cp437");
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addB;
    private javax.swing.JButton addCharB;
    private javax.swing.JLabel addCharL;
    private javax.swing.JButton addListMuButton;
    private javax.swing.JLabel addWorldL;
    private javax.swing.JLabel advert;
    private javax.swing.JPanel advertPanel;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelB;
    private javax.swing.JCheckBox charAutoLogin;
    private javax.swing.JPanel charInfoPanel;
    private javax.swing.JTextArea charInstTA;
    private javax.swing.JTextField charName;
    private javax.swing.JScrollPane charNotes;
    private javax.swing.JLabel charNotesL;
    private javax.swing.JPanel charPanel;
    private javax.swing.JPasswordField charPassword;
    private javax.swing.JComboBox charTypeCB;
    private javax.swing.JTextArea characterNotes;
    private anecho.gui.JMappedComboBox codePage;
    private javax.swing.JButton connB;
    private anecho.gui.JMappedComboBox connTypeCB;
    private javax.swing.JButton delB;
    private javax.swing.JLabel extImageL;
    private javax.swing.JPanel externalTitlePanel;
    private javax.swing.JPanel infoPanel;
    private javax.swing.JPanel introductionPanel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JLabel jamochaImageL;
    private javax.swing.JPanel jamochaTitlePanel;
    private javax.swing.JPanel jmudAdvert;
    private javax.swing.JLabel logoLabel;
    private javax.swing.JTextField mAddressTF;
    private javax.swing.JTextField mNameTF;
    private javax.swing.JTextField mPortTF;
    private javax.swing.JLabel muAddressLabel;
    private javax.swing.JLabel muNameLabel;
    private javax.swing.JTextArea muNotesTA;
    private javax.swing.JLabel muPortLabel;
    private javax.swing.JPanel mudlistAdvert;
    private javax.swing.JLabel mudlistLabel;
    private javax.swing.JLabel nameL;
    private javax.swing.JLabel passwordL;
    private javax.swing.JCheckBox sslCB;
    private javax.swing.JPanel titlePanel;
    private javax.swing.JLabel typeLabel;
    private javax.swing.JCheckBox worldOverrideCB;
    private transient javax.swing.JTree worldTree;
    private javax.swing.JLabel worldTreeLabel;
    // End of variables declaration//GEN-END:variables
    /** Enables or disables debugging output */
    private static final boolean DEBUG = false;
    /** The file name where the worlds and characters are stored */
    private static final String TREEFILE = "worlds.xml";
    /** The root node of the "world" tree */
    private transient DefaultMutableTreeNode optionRoot = new DefaultMutableTreeNode(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("Worlds"));
    /** The tree-model of the world and character display */
    private transient DefaultTreeModel worldTreeModel;
    /** World */
    private static final int WORLD = 0;
    /** Character */
    private static final int CHARACTER = 1;
    /**
     * This class contains the world currently selected, which is returned
     * to JamochaMUD if the user chooses to connect.
     */
    private transient World currentWorld = new World();
    /** The character selected by the user when they choose to connect. */
    private transient MUChar currentChar = new MUChar();
}
