/*
 * AboutBox2.java
 *
 * Created on April 30, 2005, 4:41 PM
 */

package anecho.JamochaMUD;

/**
 * This is the Swing-enabled version of AboutBox which displays
 * licensing information for JamochaMUD.
 * @author jeffnik
 * @version $Id: AboutBox2.java,v 1.11 2009/09/16 02:55:23 jeffnik Exp $
 */
public class AboutBox2 extends javax.swing.JDialog {
    
    /**
     * Creates new form AboutBox2
     * @param parent Parent frame for this AboutBox dialogue.
     */
//    public AboutBox2(java.awt.Frame parent, anecho.JamochaMUD.JMConfig settings) {
    public AboutBox2(java.awt.Frame parent) {
        super(parent, true);
        
        // this.settings = settings;
        settings = JMConfig.getInstance();
        
        initComponents();
        this.setTitle("About JamochaMUD (Version: " + AboutBox.fullVerNum +")");
        
        this.setLocationRelativeTo(null);
        
        
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        cancelButton = new javax.swing.JButton();
        guiLicenseTab = new javax.swing.JTabbedPane();
        creditText = new anecho.gui.JMSwingText();
        licenseText = new anecho.gui.JMSwingText();
        guiLicenseText = new anecho.gui.JMSwingText();
        otherText = new anecho.gui.JMSwingText();
        showOther();
        jamochaLogo = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("About JamochaMUD");
        setModal(true);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        cancelButton.setMnemonic(java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle").getString("AboutBoxCancelButtonMnemonic").charAt(0));
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("anecho/JamochaMUD/JamochaMUDBundle"); // NOI18N
        cancelButton.setText(bundle.getString("thanksalot!")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(cancelButton, gridBagConstraints);

        guiLicenseTab.setToolTipText(bundle.getString("CreditsToolTip")); // NOI18N

        creditText.setEditable(false);
        showCredits();
        guiLicenseTab.addTab(bundle.getString("credits"), creditText); // NOI18N

        displayLicense();
        guiLicenseTab.addTab(bundle.getString("license"), licenseText); // NOI18N

        guiDisplayLicense();
        guiLicenseTab.addTab("GUI class license", guiLicenseText);
        guiLicenseTab.addTab("3rd party modules", otherText);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(guiLicenseTab, gridBagConstraints);

        jamochaLogo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/anecho/JamochaMUD/JMUD_title_trans.png"))); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        getContentPane().add(jamochaLogo, gridBagConstraints);

        getAccessibleContext().setAccessibleDescription(bundle.getString("AboutBoxDescription")); // NOI18N

        pack();
    }// </editor-fold>//GEN-END:initComponents
    
    /**
     * This method releases the resources for the dialogue box and sets
     * the dialog non-visible.
     * @param evt The button event.
     */
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    /**
     * Information pertaining to the GPL and copyright
     */
    private void displayLicense() {
        // Set our component's colours
        licenseText.setForeground(settings.getJMColor(JMConfig.FOREGROUNDCOLOUR));
        licenseText.setBackground(settings.getJMColor(JMConfig.BACKGROUNDCOLOUR));
        licenseText.setFont(settings.getJMFont(JMConfig.FONTFACE));
        
        
        // Write the GPL information
        licenseText.append('\u001b' + "[32mJamochaMUD - a (Java) MUD/MUCK client\n");
        licenseText.append("Copyright (C) 1998-2008  Jeff Robinson (jeffnik@anecho.mb.ca)\n");
        licenseText.append('\u001b' + reset);
        licenseText.append("This program is free software; you can redistribute it \n");
        licenseText.append("and/or modify it under the terms of the GNU General\n");
        licenseText.append("Public License as published by the Free Software\n");
        licenseText.append("Foundation; either version 2 of the License, or any\n");
        licenseText.append(" later version.\n\n");
        licenseText.append("This program is distributed in the hope that it will\n");
        licenseText.append("be useful, but WITHOUT ANY WARRANTY; without even\n");
        licenseText.append("the implied warranty of MERCHANTABILITY or FITNESS\n");
        licenseText.append("FOR A PARTICULAR PURPOSE.  See the GNU General Public\n");
        licenseText.append("License for more details.\n\n");
        licenseText.append("You should have received a copy of the GNU General\n");
        licenseText.append("Public License  along with this program; if not,\n");
        licenseText.append(" write to the\n");
        licenseText.append("Free Software Foundation, Inc.,\n");
        licenseText.append("59 Temple Place - Suite 330,\n");
        licenseText.append("Boston, MA  02111-1307, USA.\n");
    }
    
    /**
     * Information pertaining to the GPL and copyright
     */
    private void guiDisplayLicense() {
        // Set our component's colours
        guiLicenseText.setForeground(settings.getJMColor(JMConfig.FOREGROUNDCOLOUR));
        guiLicenseText.setBackground(settings.getJMColor(JMConfig.BACKGROUNDCOLOUR));
        guiLicenseText.setFont(settings.getJMFont(JMConfig.FONTFACE));
        
        
        // Write the LGPL information
        guiLicenseText.append('\u001b' + "[32mJamochaMUD - a (Java) MUD/MUCK client\n");
        guiLicenseText.append("Copyright (C) 1998-2008  Jeff Robinson (jeffnik@anecho.mb.ca)\n");
        guiLicenseText.append('\u001b' + reset);
        guiLicenseText.append("This library is free software; you can redistribute it and/or\n");
        guiLicenseText.append("modify it under the terms of the GNU Lesser General Public\n");
        guiLicenseText.append("License as published by the Free Software Foundation; either\n");
        guiLicenseText.append("version 2.1 of the License, or (at your option) any later version.\n\n");
        guiLicenseText.append("This library is distributed in the hope that it will be useful,\n");
        guiLicenseText.append("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
        guiLicenseText.append("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n");
        guiLicenseText.append("Lesser General Public License for more details.\n\n");
        guiLicenseText.append("You should have received a copy of the GNU Lesser General Public\n");
        guiLicenseText.append("License along with this library; if not, write to the\nFree Software");
        guiLicenseText.append("Foundation, Inc.\n51 Franklin St\nFifth Floor\nBoston, MA  02110-1301\nUSA");
    }
    
    /**
     * Show the credits for JamochaMUD
     */
    private void showCredits() {
        creditText.setForeground(settings.getJMColor(JMConfig.FOREGROUNDCOLOUR));
        creditText.setBackground(settings.getJMColor(JMConfig.BACKGROUNDCOLOUR));
        creditText.setFont(settings.getJMFont(JMConfig.FONTFACE));
        
        // Write the credits
        creditText.append("Dedicated to the memory of F. Ross Browne; uncle, instigator, inspiration, and curmudgeon.\n\n");
        creditText.append('\u001b' + "[1mJeff Robinson - High(ly caffeinated) Muckymuck (jeffnik@anecho.mb.ca)\n" + '\u001b' + reset);
        creditText.append("Jason Holmgren - Annoying Vermin\n");
        creditText.append("Sean Simpson - Head Haranguer (Strnig)\n");
        creditText.append("Sara Palmer - Chief of Wahness\n");
        creditText.append("Sandi Wilkinson - Wizzywizz\n");
        creditText.append("Andrea Adams - Clue-by-four handler\n");
        creditText.append("Bjoern Weber - Socks(5) for fox!\n");
        creditText.append("Leonid Konkov - Language logistics\n");
        creditText.append("Stephane Boisjoli - Text-chopping magic\n\n");
        
        creditText.append('\u001b' + "[1mTranslations:" + '\u001b' + reset);
        creditText.append("Miguel Estrugo - Man of many words (Spanish and Italian)\n");
        creditText.append("Mark Straver - Dutch (No, Dutch is *NOT* baby-German!)\n");
        creditText.append("Andr Schieleit - German!  Yay!\n\n");
        
        creditText.append('\u001b' + "[1mSloggers:" + '\u001b' + reset);
        creditText.append("Rocko - Official JMUD-mangler\n");
        creditText.append("Caroline Blight - Chat-a-cat\n");
        creditText.append("PaulTB - Japanese is a difficult language?!\n");
        creditText.append("Thufir - Work properly?  Not unreasonable, I guess.\n");
        creditText.append("Lucy Handfield - My God, it's (not) full of colours!\n");
        creditText.append("\n");
        creditText.append("A great deal of thanks to Matthias L. Jugel and Marcus Meiner for their Java telnet app\n");
        creditText.append("( http://www.first.gmd.de/persons/leo/java/Telnet ).\n");
        creditText.append("\n");
        creditText.append('\u001b' + "[1mCrystal Icon Theme" + '\u001b' + reset);
        creditText.append("Created by Everaldo Coelho for KDE.  http://www.everaldo.com\n");
        
    }
    
    private void showOther() {
        otherText.setForeground(settings.getJMColor(JMConfig.FOREGROUNDCOLOUR));
        otherText.setBackground(settings.getJMColor(JMConfig.BACKGROUNDCOLOUR));
        otherText.setFont(settings.getJMFont(JMConfig.FONTFACE));
        
        otherText.append("JamochaMUD also uses the following classes:\n");
//        otherText.append("* " + '\u001b' + "[32mJazzy" + '\u001b' + "[0m - The Open Source Spell Checker available from\nhttp://jazzy.sourceforge.net/\n\n");
        otherText.append('\u001b' + "[32mJMySpell" + '\u001b' + "[0m - An Open Source Spell Checker available from\n");
        otherText.append("http://jmyspell.javahispano.net/\n\n");
        otherText.append('\u001b' + "[32mBrowserLauncher2" + '\u001b' + "[0m - classes to launch web browsers on multiple platforms\n");
        otherText.append("http://browserlaunch2.sourceforge.net/\n\n");
        otherText.append('\u001b' + "[32mthe Java Telnet Application" + '\u001b' + "[0m - used for proper telnet negotiation and interaction\n");
        otherText.append("http://javassh.org\n\n");
        
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private anecho.gui.JMSwingText creditText;
    private javax.swing.JTabbedPane guiLicenseTab;
    private anecho.gui.JMSwingText guiLicenseText;
    private javax.swing.JLabel jamochaLogo;
    private anecho.gui.JMSwingText licenseText;
    private anecho.gui.JMSwingText otherText;
    // End of variables declaration//GEN-END:variables
    private transient final JMConfig settings;
    private static transient final String reset = "[0m\n";
}
