/**********************************************************************
  sample2.c - test exceptq.dll using dynaminc loading (LoadExceptq helper)
  $Id: sample2.c,v 1.3 2015/08/30 04:31:54 Steven Exp $

 SAMPLE 32 bit program to access EXCEPTQ.DLL exception handler via
 dynamically loaded DLL
 generates a TRAP to demonstrate information gathering

 2005-08-02 SHL Baseline
 2012-08-02 SHL	Rework to use INCL_LOADEXCEPTQ etc.
 2012-08-30 SHL	Rework to support gcc and g++ testing
 2015-08-29 SHL	Avoid C compiler complaints

**********************************************************************/

/* Disable to test old way */
#define INCL_LOADEXCEPTQ

// Enable only one of following

/* Enable for DosExit EXCEPTQ=Z testing */
// #define TESTEXIT 1

/* Enable for Floating point exception testing */
#define TESTFLOAT 1

/* Enable for bogus ebp testing - OpenWatcom only */
#define TESTACCESS 1

/* Enable for bogus ebp testing - OpenWatcom only */
// #define TESTBADEBP 1

#define INCL_DOSERRORS
#define INCL_DOSEXCEPTIONS
#define INCL_DOSMODULEMGR

#ifdef INCL_LOADEXCEPTQ
#define INCL_DOSPROCESS
#endif

#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#ifdef INCL_LOADEXCEPTQ
#include <string.h>		// for LoadExceptq
#endif

#include "exceptq.h"

void TrapFunc(void);

int main(void)
{
    EXCEPTIONREGISTRATIONRECORD exRegRec = { NULL, NULL };
    APIRET rc;
    HMODULE hmod = NULLHANDLE;
#   if !defined(INCL_LOADEXCEPTQ)
    char szLoadError[CCHMAXPATH];
#   endif

    /* Dynamically load exceptq.dll if available */
#   if defined(INCL_LOADEXCEPTQ)
    if (!LoadExceptq(&exRegRec, "I", "sample2 testcase")) {
	printf("LoadExceptq failed.\n");
    }
#   else
    rc = DosLoadModule(szLoadError, CCHMAXPATH, "EXCEPTQ", &hmod);
    if (rc != NO_ERROR) {
	printf("EXCEPTQ.DLL not loaded.\n");
    } else {
	_ERR *pfnMyHandler;
	printf("EXCEPTQ.DLL loaded.\n");
	rc = DosQueryProcAddr(hmod, 0L, "MYHANDLER", (PFN*)&pfnMyHandler);
	if (rc != NO_ERROR) {
	    printf("MyHandler not found in EXCEPTQ.DLL.\n");
	    DosFreeModule(hmod);
	} else {
	    printf("MyHandler queried from EXCEPTQ.DLL.\n");
	    /* Add MyHandler to this thread's chain of exception handlers */
	    exRegRec.ExceptionHandler = pfnMyHandler;
	    rc = DosSetExceptionHandler(&exRegRec);
	    if (rc != NO_ERROR) {
	       printf("MyHandler not installed.\n");
	       DosFreeModule(hmod);
	    }
	}
    }
#   endif

    TrapFunc();

    if (rc == NO_ERROR) {
	rc = DosUnsetExceptionHandler(&exRegRec);
	if (rc != NO_ERROR) {
	    printf("MyHandler could not be uninstalled\n");
	    exit(1);
	} else {
	    printf("MyHandler unset.\n");
	}
	DosFreeModule(hmod);
    }

    return 0;
}

void TrapFunc()
{
#   ifdef TESTEXIT
    DosExit(EXIT_PROCESS, 1);	
#   endif

#   ifdef TESTFLOAT
    {
      int i1;
      double d1 = (double)time(NULL);
      double d2 = 0;
      double d3;
      printf("d1 %f\n", d1);
      d3 = d1/d2;			// Divide by 0
    printf("d2 %f\n", d3);
    }
#   endif

#   ifdef TESTACCESS
    {
      char * Test;
      Test=0;
      *Test=0;
    }
#   endif

#   ifdef TESTBADEBP
    _asm {
      mov ebp, 0x10
      xor ebx, ebx
      xor eax, eax
      mov 0[ebx], eax
    };
#   endif

}
