#
# exceptq.mak - build exceptq.dll
# $Id: exceptq.mak,v 1.8 2015/08/29 18:09:08 Steven Exp $
#
# Tools used:  nmake32  vacpp(v3.65)  ilink(v5)  implib  mapsym
# Note:  '@echo' separates each tool's output with a blank line

# define DEBUG to enable debug build
# define DEBUG 2 to disable optimizer - breaks local variables on 3.6.5

.SUFFIXES:

.SUFFIXES: .c .asm

all: exceptq.dll

# Note 3.08 does not support SEGORGER

exceptq.dll:  \
  exceptq.obj \
  exq_cv.obj \
  exq_dbg.obj \
  exq_rpt.obj \
  exq_sym.obj \
  cmpxchg.obj \
  exceptq.def \
  exceptq.mak
  @echo
  ilink @<<exceptq.lrf
    /DLL /EXEPACK:2 /NOIGNORECASE /MAP /OPTFUNC /NOSEGORDER
!ifdef DEBUG
    /DE /LINENUMBERS
!else
    /NOLINENUMBERS 
!endif
    /OUT:exceptq.dll
    exceptq.obj
    exq_cv.obj
    exq_dbg.obj
    exq_rpt.obj
    exq_sym.obj
    cmpxchg.obj
    exceptq.def
<<KEEP
  @echo
  implib /nologo exceptq.lib exceptq.def
  @echo
# 2012-09-16 SHL
  mapsym exceptq
  mapxqs exceptq
!ifndef DEBUG
  @echo
# 2012-08-02 SHL
  lxlite $@
!endif

# Use default Optlink calling convention (/Mp)
# /Ge-  Build DLL
# /Gl   Smart linking
# /Gm   Link with multithread runtime libraries
# /O    Optimize (breaks local variables on 3.6.5)
# /Q    Suppress logo
# /Sm   Allow migration keywords
# /Ss   Allow //
# /Ti   Generate debugging information

.c.obj:
  @echo
!ifdef DEBUG
# 2013-10-15 SHL /O breaks line number debugging on 3.6.5
!if $(DEBUG) == 2
  icc /Ge- /Gl /Gm /Q /Sm /Ss /W3 /Ti /C $*.c
!else
  icc /Ge- /Gl /Gm /O /Q /Sm /Ss /W3 /Ti+ /C $*.c
!endif
!else
  icc /Ge- /Gl /Gm /O /Q /Sm /Ss /W3 /C $*.c
!endif

.asm.obj:
  alp $<

exceptq.obj:  exceptq.c  exq.h exceptq.mak
exq_cv.obj:   exq_cv.c   exq.h exceptq.mak omf.h hlldbg.h
exq_dbg.obj:  exq_dbg.c  exq.h exceptq.mak omf.h hlldbg.h
exq_rpt.obj:  exq_rpt.c  exq.h exceptq.mak distorm.h
exq_sym.obj:  exq_sym.c  exq.h exceptq.mak sym.h xqs.h

