/**
 * Dev32rmcalls.h
 *
 * Author: David Azarewicz <david@88watts.net>
 *
 * Copyright (c) 2013-2018 David Azarewicz david@88watts.net
 *
 * LICENSE
 *
 * The following source code is provided to you solely for the purpose of
 * assisting you in developing your own OS/2 device drivers. You may use
 * this source code as a reference and to build your own OS/2 drivers. You
 * may not modify, fork, or otherwise copy this source code other than what
 * is necessary for building your own OS/2 drivers. Any request for changes
 * or fixes must be referred to the author shown above.
 *
 * This copyright and license statement may not be removed.
 */
#ifndef __RM_CALLS__
#define __RM_CALLS__

#include <Dev32rmbase.h>

#ifdef __cplusplus
  extern "C" {
#endif

ULONG __syscall RMCreateDriver(void *pDriverStruct, ULONG *phDriver);
ULONG __syscall RMDestroyDriver(HDRIVER hDriver);
ULONG __syscall RMCreateAdapter(HDRIVER hDriver, void *phAdapter, void *pAdapterStruct, HDEVICE hDevice, void *pahResource);
ULONG __syscall RMDestroyAdapter(HDRIVER hDriver, HADAPTER hAdapter);
ULONG __syscall RMCreateDevice(HDRIVER hDriver, void *phDevice, void *pDeviceStruct, HADAPTER hAdapter, void *pahResource);
ULONG __syscall RMDestroyDevice(HDRIVER hDriver, HDEVICE hDevice);
ULONG __syscall RMAllocResource(HDRIVER hDriver, void *phResource, void *pResourceStruct);
ULONG __syscall RMDeallocResource(HDRIVER hDriver, HRESOURCE hResource);
ULONG __syscall RMModifyResources(HDRIVER hDriver, HADAPTER hAdapter, USHORT ModifyAction, HRESOURCE hResource);
ULONG __syscall RMGetNodeInfo(RMHANDLE RMHandle, void *pNodeInfo, USHORT BufferSize);
ULONG __syscall RMDevIDToHandleList(RMHANDLE RMHandle, DEVID DeviceID, DEVID FunctionID, DEVID CompatibleID,
  VENDID VendorID, SERNUM SerialNumber, SEARCHIDFLAGS SearchFlags, HDETECTED hStartNode, void *pHndList);
ULONG __syscall RMHandleToResourceHandleList(RMHANDLE hHandle, void *pHndList);

#ifdef __cplusplus
	};
#endif

/****************************************************************************/
/*                                                                          */
/* Resource Manager Return Codes                                            */
/*                                                                          */
/****************************************************************************/
#define RMRC_SUCCESS               0x0000
#define RMRC_NOTINITIALIZED        0x0001
#define RMRC_BAD_DRIVERHANDLE      0x0002
#define RMRC_BAD_ADAPTERHANDLE     0x0003
#define RMRC_BAD_DEVICEHANDLE      0x0004
#define RMRC_BAD_RESOURCEHANDLE    0x0005
#define RMRC_BAD_LDEVHANDLE        0x0006
#define RMRC_BAD_SYSNAMEHANDLE     0x0007
#define RMRC_BAD_DEVHELP           0x0008
#define RMRC_NULL_POINTER          0x0009
#define RMRC_NULL_STRINGS          0x000a
#define RMRC_BAD_VERSION           0x000b
#define RMRC_RES_ALREADY_CLAIMED   0x000c
#define RMRC_DEV_ALREADY_CLAIMED   0x000d
#define RMRC_INVALID_PARM_VALUE    0x000e
#define RMRC_OUT_OF_MEMORY         0x000f
#define RMRC_SEARCH_FAILED         0x0010
#define RMRC_BUFFER_TOO_SMALL      0x0011
#define RMRC_GENERAL_FAILURE       0x0012
#define RMRC_IRQ_ENTRY_ILLEGAL     0x0013
#define RMRC_NOT_IMPLEMENTED       0x0014
#define RMRC_NOT_INSTALLED         0x0015
#define RMRC_BAD_DETECTHANDLE      0x0016
#define RMRC_BAD_RMHANDLE          0x0017
#define RMRC_BAD_FLAGS             0x0018
#define RMRC_NO_DETECTED_DATA      0x0019


/*********************/
/*  RM Types         */
/*********************/

typedef struct {
   UCHAR      MajorVersion;
   UCHAR      MinorVersion;
   USHORT     NumRSMEntries;
} RSMVERSTRUCT;

#endif /* __RM_CALLS__ */
