/**/                       
signal on novalue name error
signal on halt name error

parse arg traceon ',' host ',' port ',' userid ',' password ',' basedn

if host = '' then exit 8
if port = '' then exit 8
if userid = '' then exit 8
if password = '' then exit 8
if basedn = '' then exit 8

host = strip(host)
port = strip(port)
userid = strip(userid)
password = strip(password)
basedn = strip(basedn)

if translate(traceon) = 'YES' then trace r

call RxFuncDrop "RXLDAPLOADFUNCS"
call RxFuncAdd "RXLDAPLOADFUNCS", "RXLDAP", "RXLDAPLOADFUNCS"
call RxldapLoadFuncs
call RxldapLoadFuncs

call RxldapVersion
call say result

call Rxldap_version 'v.'
call say result
call say v.!sdk_version
call say v.!protocol_version

url = "ldap://" || host || '/' || basedn || "?o,ou,cn,objectclass,sn?sub?(objectclass=*)"

cn1 = 'P' || random()
cn2 = 'P' || random()

dn1 = 'cn=' || cn1 || ',' || basedn
dn2 = 'cn=' || cn2 || ',' || basedn

call say dn1
call say dn2

call Rxldap_url_parse url, 'desc.'
call say desc.!lud_host
call say desc.!lud_port
call say desc.!lud_scope
call say desc.!lud_filter
do i = 1 to desc.!lud_attrs.0
   call say desc.!lud_attrs.i
end /* do */

call say Rxldap_is_ldap_url( url )

ld = Rxldap_init(host)
if ld = 0 then signal error

call Rxldap_simple_bind ld, userid, password

call getasyncresults ld, result

call Rxldap_get_option ld, 'LDAP_OPT_TIMELIMIT', 'val'
call say val

call Rxldap_set_option ld, 'LDAP_OPT_TIMELIMIT', 10

call Rxldap_get_option ld, 'LDAP_OPT_TIMELIMIT', 'val'
call say val

call Rxldap_get_option ld, 'LDAP_OPT_SIZELIMIT', 'val'
call say val

call Rxldap_set_option ld, 'LDAP_OPT_SIZELIMIT', 1000

call Rxldap_get_option ld, 'LDAP_OPT_SIZELIMIT', 'val'
call say val

call Rxldap_get_option ld, 'LDAP_OPT_HOST_NAME', 'val'
call say val

call Rxldap_get_option ld, 'LDAP_OPT_PROTOCOL_VERSION', 'val'
call say val

call Rxldap_get_option ld, 'LDAP_OPT_API_INFO', 'val'
call say val.!ldapai_api_version
call say val.!ldapai_protocol_version
call say val.!ldapai_vendor_name
call say val.!ldapai_vendor_version
do i = 1 to val.!ldapai_extensions.0
   call say val.!ldapai_extensions.i
end /* do */

call Rxldap_get_option ld, 'LDAP_OPT_API_FEATURE_INFO', 'val'
call say val.!ldapaif_version
call say val.!ldapaif_name

call Rxldap_unbind ld

ld = Rxldap_init(host, port)
if ld = 0 then signal error

call Rxldap_simple_bind_s ld, userid, password
if result <> 'LDAP_SUCCESS' then signal error
call say Rxldap_err2string(result)

call Rxldap_url_search ld, url, 1
if result = -1 then signal error

call Rxldap_abandon ld, result
if result <> 0 then signal error

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_rename ld, dn1, 'cn=' || cn2, , 1, , , 'msgid'
if result <> 'LDAP_SUCCESS' then signal error

call getasyncresults ld, msgid

call Rxldap_search_s ld, dn2, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete_s ld, dn2
if result <> 'LDAP_SUCCESS' then signal error

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_rename_s ld, dn1, 'cn=' || cn2, , 1
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn2, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete_s ld, dn2
if result <> 'LDAP_SUCCESS' then signal error


call say Rxldap_compare_s( ld, 'ou=YSL,o=rxldaptest', 'ou', 'YSL' )

call Rxldap_compare ld, 'ou=YSL,o=rxldaptest', 'ou', 'YSL'
if result = -1 then signal error
call getasyncresults ld, result

call say Rxldap_compare_ext_s( ld, 'ou=YSL,o=rxldaptest', 'ou', 'YSL' )

call Rxldap_compare_ext ld, 'ou=YSL,o=rxldaptest', 'ou', 'YSL', , , 'msgid'
if result <> 'LDAP_SUCCESS' then signal error

call getasyncresults ld, msgid

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

mods.0 = 1
mods.1.!mod_op = 'LDAP_MOD_REPLACE'
mods.1.!mod_type = 'sn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn2
call Rxldap_modify_ext_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete_s ld, dn1
if result <> 'LDAP_SUCCESS' then signal error

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

mods.0 = 1
mods.1.!mod_op = 'LDAP_MOD_REPLACE'
mods.1.!mod_type = 'sn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn2
call Rxldap_modify_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete_s ld, dn1
if result <> 'LDAP_SUCCESS' then signal error

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

mods.0 = 1
mods.1.!mod_op = 'LDAP_MOD_REPLACE'
mods.1.!mod_type = 'sn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn2
call Rxldap_modify ld, dn1, 'mods.'

call getasyncresults ld, result

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete_s ld, dn1
if result <> 'LDAP_SUCCESS' then signal error

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

mods.0 = 1
mods.1.!mod_op = 'LDAP_MOD_REPLACE'
mods.1.!mod_type = 'sn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn2
call Rxldap_modify_ext ld, dn1, 'mods.', , , 'msgid'

call getasyncresults ld, msgid

call Rxldap_search_s ld, dn1, "LDAP_SCOPE_BASE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete_s ld, dn1
if result <> 'LDAP_SUCCESS' then signal error

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add_s ld, dn1, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn2
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn2
call Rxldap_add_ext_s ld, dn2, 'mods.'
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete_s ld, dn1
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_delete_ext_s ld, dn2
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn1
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn1
call Rxldap_add ld, dn1, 'mods.'

call getasyncresults ld, result

mods.0 = 3
mods.1.!mod_op = 0
mods.1.!mod_type = 'cn'
mods.1.!modv.0 = 1
mods.1.!modv.1 = cn2
mods.2.!mod_op = 0
mods.2.!mod_type = 'objectclass'
mods.2.!modv.0 = 1
mods.2.!modv.1 = 'person'
mods.3.!mod_op = 0
mods.3.!mod_type = 'sn'
mods.3.!modv.0 = 1
mods.3.!modv.1 = cn2
call Rxldap_add_ext ld, dn2, 'mods.', , , 'msgid'

call getasyncresults ld, msgid

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_delete ld, dn1

call getasyncresults ld, result

call Rxldap_delete_ext ld, dn2, , , 'msgid'

call getasyncresults ld, msgid

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_search_ext ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 1, , , 10.0, 0, "msgid"
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_abandon_ext ld, msgid
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_url_search_st ld, url, 1, 10.0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_st ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 1, 10.0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_ext_s ld, basedn, "LDAP_SCOPE_ONELEVEL", "(objectclass=*)", , 1, , , 10.0, 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 1, "msg"
if result <> 'LDAP_SUCCESS' then signal error

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 1
if result = -1 then signal error

call Rxldap_result ld, result, 'LDAP_MSG_ONE', 10.0, 'msg'

call Rxldap_msgtype msg

call Rxldap_msgid msg

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_ONELEVEL", "(objectclass=*)", , 1, "msg"
if result <> 'LDAP_SUCCESS' then signal error

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_BASE", "(" || basedn || ")", , 1, "msg"
if result <> 'LDAP_SUCCESS' then signal error
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_url_search_s ld, url, 1, "msg"
if result <> 'LDAP_SUCCESS' then signal error

count = Rxldap_count_entries( ld, msg )
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error
call say count

call Rxldap_msgfree msg
call Rxldap_get_errno ld
if result <> 'LDAP_SUCCESS' then signal error

call Rxldap_search ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", , 0

call asyncgetvalues ld, result

attrs.0 = 5
attrs.1 = "o"
attrs.2 = "ou"
attrs.3 = "objectclass"
attrs.4 = "cn"
attrs.5 = "sn"

call Rxldap_search_s ld, basedn, "LDAP_SCOPE_SUBTREE", "(objectclass=*)", "attrs.", 0, "msg"
if result <> 'LDAP_SUCCESS' then signal error

call getvalues ld, msg

call Rxldap_unbind_s ld
if result <> 'LDAP_SUCCESS' then signal error

call RxldapDropFuncs
exit

asyncgetvalues: procedure
arg ld, msgid
if msgid = -1 then do
   call Rxldap_get_errno ld
   signal error
end /* do */

do forever
   call Rxldap_result ld, 'LDAP_RES_ANY', 'LDAP_MSG_RECEIVED', 2.0, 'res'
   if result <> 'LDAP_RES_SEARCH_ENTRY' then leave
   
   call Rxldap_parse_result ld, res, 'errcode', , , , , 0
   if errcode <> 'LDAP_SUCCESS' then signal error
   
   msg = Rxldap_first_entry( ld, res )
   if msg = 0 then do
      call Rxldap_msgfree res
      leave
   end /* do */
   
   do until msg = 0
   
      dn = Rxldap_get_dn( ld, msg )
      call say dn
      
		call Rxldap_explode_dn dn, 0, 'rdns.'
		do i = 1 to rdns.0
			call say rdns.i
      end /* do */
      
		call Rxldap_explode_dn dn, 1, 'rdns.'
		do i = 1 to rdns.0
			call say rdns.i
      end /* do */
		
      attr = Rxldap_first_attribute( ld, msg, "ber" )
      
      do while attr <> ""
         call say attr
         call Rxldap_get_values ld, msg, attr, "vals."
         do i = 1 to vals.0
            call say attr || '=' || vals.i
         end /* do */
         attr = Rxldap_next_attribute( ld, msg, ber )
      end /* do */
      
      msg = Rxldap_next_entry(ld, msg)
   end /* do */
   call Rxldap_msgfree res
end /* do */
return

getvalues: procedure
arg ld, res
msg = Rxldap_first_entry( ld, res )
if msg = 0 then do
   call Rxldap_msgfree res
   return
end /* do */

do until msg = 0

   dn = Rxldap_get_dn( ld, msg )
   call say dn
   
	call Rxldap_explode_dn dn, 1, 'rdns.'
	do i = 1 to rdns.0
		call say rdns.i
   end /* do */
   
	call Rxldap_explode_dn dn, 0, 'rdns.'
	do i = 1 to rdns.0
		call say rdns.i
   end /* do */
   
   attr = Rxldap_first_attribute( ld, msg, "ber" )
   
   do while attr <> ""
      call Rxldap_get_values ld, msg, attr, "vals."
      do i = 1 to vals.0
         call say attr || '=' || vals.i
      end /* do */
      attr = Rxldap_next_attribute( ld, msg, ber )
   end /* do */
   
   msg = Rxldap_next_entry(ld, msg)
end /* do */
call Rxldap_msgfree res
return

getvalueslen: procedure
arg ld, res
msg = Rxldap_first_entry( ld, res )
if msg = 0 then do
   call Rxldap_msgfree res
   return
end /* do */

do until msg = 0

   dn = Rxldap_get_dn( ld, msg )
   call say dn
   
	call Rxldap_explode_dn dn, 0, 'rdns.'
	do i = 1 to rdns.0
		call say rdns.i
   end /* do */
   
	call Rxldap_explode_dn dn, 1, 'rdns.'
	do i = 1 to rdns.0
		call say rdns.i
   end /* do */
   
   attr = Rxldap_first_attribute( ld, msg, "ber" )
   
   do while attr <> ""
      call Rxldap_get_values_len ld, msg, attr, "vals."
      do i = 1 to vals.0
         call say attr || '=' || vals.i
      end /* do */
      attr = Rxldap_next_attribute( ld, msg, ber )
   end /* do */
   
   msg = Rxldap_next_entry(ld, msg)
end /* do */
call Rxldap_msgfree res
return

getasyncresults: procedure
parse arg ld, msgid

if msgid = -1 then do
   call Rxldap_get_errno ld
   signal error
end /* do */

call Rxldap_result ld, 'LDAP_RES_ANY', 'LDAP_MSG_RECEIVED', 2.0, 'msg'

if msg = 0 then return

call say Rxldap_msgtype( msg )

count = Rxldap_count_messages( ld, msg )
call say count

msg = Rxldap_first_message( ld, msg )

do while msg <> 0
   call Rxldap_parse_result ld, msg, 'errcode', , , , , 0
   call say Rxldap_msgtype( msg )
   call say Rxldap_err2string( errcode )
   msg = Rxldap_next_message( ld, msg )
end /* do */
return

error:
ln = sigl
if symbol('RESULT') = 'VAR' then do
   say result
   call say Rxldap_err2string(result)
end /* do */
if symbol('ERRCODE') = 'VAR' then do
   say errcode
   call say Rxldap_err2string(errcode)
end /* do */
say condition("c") || "@" || ln
say condition("d")
say condition("i")
exit 8

say:
parse arg m
say sigl m
return
