(*
** Module   :NBSAMPLE.C
** Abstract :
**
** Copyright (C) Sergey I. Yevtushenko
** Log: Fri  19/02/1998     Created
**
*)
uses
    Classes,os2def,os2pmapi,strings,SysUtils,VPUtils,
    Cell,xmlRead,xmlWrite,dom;

{$PMTYPE PM}

{$I krmini.inc}

{$R krmini.res}
{$R krdlg.res}
(* Local procedures *)

function MainClientProc(Window:
                        HWnd; Msg:
                        ULong;
                        Mp1,Mp2: MParam): MResult; cdecl; forward;

function ContainerClientProc(Window:
                             HWnd; Msg:
                             ULong;
                             Mp1,Mp2: MParam): MResult; cdecl; forward;
var
    pChDlg:pChar;
function ConfDlgProc( hwndDlg: HWND ;
                      ulMsg      : ULONG;
                      mp1    : MPARAM;
                      mp2    : MPARAM ) : mResult; cdecl;forward;

(* Static Variables *)

const
    BKS_TABBEDDIALOG = $00000800;  (* Tabbed dialog         *)
    BKS_MAJORTABTOP  = $00000040;  (* Major tabs top        *)

(**xml path constant**)
const
    MainPath    ='KeyRingData';
    StylePath   ='style';
    PagePath    ='Page';
    PageNameAttr='name';
    ColumPath   ='colum';
    ColumNameAttr='name';

    GroupPath   ='group';
    GroupNameAttr='name';
    ItemPath    ='item';

    MaxColumList=9;
    StrSNConst  ='S/N';
    StrSNConstWO='SN';
const
    ppNbFont:pchar='9.WarpSans';

    ColumList:array[1..MaxColumList] of pchar=
        ('icon','Description','user',    'password','URL',
         'S/N',  'Last Update','Exp Date','memo');

    MaxCharLength=256;

(**GUI Cell Definition**)
const
    cdCntPane:CellDef =
        (lType: Cell_WINDOW;
         pszClass:WC_CONTAINER;
         pszName:'test';
         ulStyle:CCS_EXTENDSEL OR WS_VISIBLE;
         ulID:ID_CONTAINER);

    nbClient:CellDef =
        (lType:CELL_VSPLIT ;
         pszClass:nil;
         pszName:'Notebook page';
         ulStyle:0;
         ulID:MAIN_FRAME;
         pPanel1:@cdCntPane;
         pPanel2:nil;
         pClassProc:nil;
         pClientClassProc:ContainerClientProc);

    nbConigClient:CellDef=
        (lType:CELL_VSPLIT ;
         pszClass:nil;
         pszName:'Notebook page';
         ulStyle:0;
         ulID:MAIN_FRAME;
         pPanel1:nil;
         pPanel2:nil;
         pClassProc:nil;
         pClientClassProc:nil);


    nbPanel:CellDef=
        (lType:CELL_WINDOW;
         pszClass:WC_NOTEBOOK;
         pszName:'';
         ulStyle:WS_VISIBLE or BKS_TABBEDDIALOG or BKS_MAJORTABTOP;
         ulID:ID_NOTEBOOK);

    mainFrame:CellDef=
        (lType:CELL_HSPLIT;
         pszClass:nil;
         pszName:'Notebook Sample';
         ulStyle:FCF_TITLEBAR or FCF_SYSMENU or FCF_MENU or
                 FCF_MINMAX or FCF_TASKLIST or FCF_SIZEBORDER;
         ulID:MAIN_FRAME;
         pPanel1:@nbPanel;
         pPanel2:nil;
         pClassProc:nil;
         pClientClassProc:MainClientProc);

    mainItems:array [0..5] of longint=
        (IDB_FILEOPEN,
         IDB_FILESAVE,
         IDB_FILSAVAS,
         TB_SEPARATOR,
         IDB_EXIT    ,
         0);

    mainTb:TbDef=
        (lType:TB_ATTACHED_TP or TB_BUBBLE;
         ulID:ID_TOOLBAR;
         tbItems:@mainItems);


CONST
    CX_SPLITBAR    = 180;
Type
    pCharArray =array[1..256] of pChar;
    ptClientData = ^tClientData;
    tClientData = Record
        hwndCnr   : HWnd;
        hptrIcon  : HPointer;
    end;
    pRowInfo = ^RowInfoRecord;
    RowInfoRecord = Record
        Core   : RECORDCORE;
        pChAry : pCharArray;
    end;

TYPE
    KrXMLDocClass=CLASS
        constructor Create;
        function isKrDoc(FN:String):boolean;
        function GetMaxColum:integer;
        function GetFirstPage:TDOMNode;
        function GetMaxPage:integer;
        function GetFirstPageNode(GroupNode:TDOMNode):TDOMNode;
        function GetMaxPageNode(GroupNode:TDOMNode):integer;
        procedure FlushXMLData;
        function CreatePageData(PageName:String):TDOMNode;
        function CreatePageItemData(PageNode:TDOMNode):TDOMElement;
        procedure SetNodeAttr(node:TDOMELement;suffix:integer;pRow:pRowInfo);
        procedure SetFileName(st:string);
        procedure SaveDoc;
        function isDoc:boolean;
        procedure MakeNewDoc;
      private
        DocFileName:string;
        MaxColumNumber:integer;
        Doc:TXMLDocument;
    end;

    ContainerClass=CLASS
        id:ULong;
        krDoc:krXMLDocClass;
        GroupName:string;
        constructor Create(hWndCont:HWnd;KD:KrXMLDocClass);
        function  AllocRow(RowSize:integer;PageNode:TDOMNode):pRowInfo;
        function SetRow(pRow:pRowInfo;node:TDOMNode):pRowInfo;
        function GetRowInfoSize:integer;
        procedure SetColum;
        procedure SetStyle(style:ULong);
        procedure InsertNewRecord;
        procedure GetRowList;
        procedure FlushRowList;
        function GetRowListCount:integer;
        function GetRowByIndex(i:integer):pRowInfo;
        function isData:boolean;
      private
        isDataExist:boolean;
        hwndCntr:hwnd;
        RowList:TList;
    END;

    KrPageManegerClass=CLASS
        DataDoc:krXMLDocClass;
        hwndNB:hwnd;
        FrameWindow:hwnd;
        ContainerList:TList;
        MaxColum:integer;
        constructor Create(hwndNoteBook:hwnd);
        procedure CreateBlankPage;
        function SetPageFromNode(node:TDOMNode):TDOMNode;
        function GetContainer(id:ULong):ContainerClass;
        function GetTopPageContainer:ContainerClass;
        procedure CnrToDoc;
        procedure SaveFile;
      Private
        CntClass:ContainerClass;
    END;

constructor KrXMLDocClass.Create;
var
   i:integer;
begin
    MaxColumNumber:=9;
    DocFileName:='';
    Doc:=nil;
end;

function KrXMLDocClass.isKrDoc(FN:String):boolean;
var
    node:TDOMNode;
begin
    DocFileName:=FN;
    ReadXMLFileName(Doc,DocFileName);
    node:=Doc.DocumentElement;
    IF (Node.NodeName<>MainPath) THEN BEGIN
        isKrDoc:=FALSE;
        Doc.Destroy;
        Doc:=Nil;
        exit;
    END;
    isKrDoc:=TRUE;
end;

function KrXMLDocClass.GetMaxColum:integer;
begin
    GetMaxColum:=MaxColumNumber;
end;

function KrXMLDocClass.GetFirstPage:TDOMNode;
begin
    result:=Doc.DocumentElement.FindNode(GroupPath);
end;

function KrXMLDocClass.GetMaxPage:integer;
var
    node:TDOMNode;
    i:integer;
begin
    node:=GetFirstPage;
    while node<>Nil do begin
        i:=i+1;
        node:=Node.NextSibling;
    end;
    result:=i;
end;


function KrXMLDocClass.GetFirstPageNode(GroupNode:TDOMNode):TDOMNode;
begin
    IF GroupNode<>nil THEN
        result:=GroupNode.FindNode(ItemPath)
    else
        result:=nil;
end;

function KrXMLDocClass.GetMaxPageNode(GroupNode:TDOMNode):integer;
var
    i:integer;
    node:TDOMNode;
begin
    i:=0;
    IF GroupNode=Nil THEN begin
        result:=1;
    end
    else begin
        node:=GroupNode.FindNode(ItemPath);
        while Node<>Nil do begin
            i:=i+1;
            node:=Node.NextSibling;
        end;
        result:=i;
    end;
end;

procedure KrXMLDocCLass.FlushXMLData;
var
    PrevNode,CurNode,ParentNode:TDOMNode;
    st:string;
begin
    Doc.Destroy;
    Doc:=Nil;
    (*******
    ParentNode:=Doc.FirstChild;
    CurNode:=ParentNode.LastChild;
    repeat
        PrevNode:=CurNode.PreviousSibling;
        St:=CurNode.NodeName;
        ParentNode.RemoveChild(CurNode);
        CurNode:=PrevNode;
    until CurNode=Nil ;
    *******)
end;

function KrXMLDocCLass.CreatePageData(PageName:String):TDOMNode;
var
    PageNode:TDOMElement;
    wNode:TDOMNode;
begin
    PageNode:=Doc.CreateElement(GroupPath);
    PageNode.SetAttribute(GroupNameAttr,PageName);
    wNode:=Doc.FindNode(MainPath);
    wNode.AppendChild(PageNode);
    result:=TDOMNode(PageNode);
end;

function KrXMLDocCLass.CreatePageItemData(PageNode:TDOMNode):TDOMElement;
var
    Node:TDOMElement;
begin
    Node:=Doc.CreateElement(ItemPath);
    PageNode.AppendChild(Node);
    result:=Node;
end;

procedure KrXMLDocClass.SetNodeAttr(Node:TDOMElement;suffix:integer;pRow:pRowInfo);
var
    NameStr,AttrStr:AnsiString;
begin
    IF Suffix=1 then exit;
    IF Suffix=2 then AttrStr:=StrPas(pRow^.Core.pszIcon);
    IF Suffix>=3 then begin
        AttrStr:=StrPas(pRow^.pChAry[Suffix]);
    end;
    NameStr:=StrPas(ColumList[Suffix]);
    IF NameStr=StrSNConst THEN NameStr:=StrSNConstWO;
    IF AttrStr<>'' THEN Node.SetAttribute(NameStr,AttrStr);

end;

procedure KrXMLDocClass.SetFileName(st:string);
begin
    IF Assigned(Doc)=FALSE THEN BEGIN
        MakeNewDoc;
    END;
    DocFileName:=St;
end;

function KrXMLDocClass.isDoc:boolean;
begin
    IF DocFileName='' THEN BEGIN
        isDoc:=FALSE;
        exit;
    end
    ELSE
        isDoc:=TRUE;
    IF Doc=Nil then BEGIN
        MakeNewDoc;
    END;
end;

procedure KrXMLDocClass.MakeNewDoc;
begin
    Doc:=TXMLDocument.Create;
    Doc.AppendChild(Doc.CreateElement(MainPath));
end;

procedure KrXMLDocClass.SaveDoc;
var
    Info:TSearchRec;
    bakFileName:string;
begin
    IF DocFileName<>'' THEN BEGIN
        IF FindFirst(DocFileName,faAnyFile,Info)=0 then begin
            BakFileName:=DocFileName;
            System.Delete(BakFileName,
                          Length(BakFileName)-Length(ExtractFileExt(BakFileName)),
                          Length(ExtractFileExt(BakFileName)) );
            BakFileName:=BakFileName+'.bak';
            RenameFile(DocFileName,BakFileName);
        end;
        WriteXMLFilename(Doc,DocFileName);
    END;
end;

constructor ContainerClass.Create(hWndCont:HWnd;KD:KrXMLDocClass);
var
    i:integer;
begin
    hwndCntr:=hwndCont;
    KrDoc:=KD;
    isDataExist:=FALSE;
end;


function ContainerClass.SetRow(pRow:pRowInfo;Node:TDOMNode):pRowInfo;
Var
    pchPos : PChar;
    AttrSt,St: String;
    i:integer;
    function GetColumStr(AtSt:string):string;
    var
        rSt:string;
    begin
        IF node=Nil then
            result:=''
        ELSE begin
            IF AtSt=StrSNConst THEN AtSt:=StrSNConstWO;
            rSt:=TDOMElement(Node).GetAttribute(AtSt);
            result:=rSt;
        end;
    end;
begin
    pRow^.Core.cb := sizeof(RECORDCORE);

    GetMem( pRow^.Core.pszIcon, MaxCharLength );
    if pRow^.Core.pszIcon <> Nil then begin
        St:=StrPas(ColumList[2]);
        St:=GetColumStr(St);
        strpCopy( pRow^.Core.pszIcon,St);
    end;
    pRow^.Core.hptrIcon := WinLoadPointer(HWND_DESKTOP,
                                                  NULLHANDLE,
                                                  ICO_ITEM);
    for i:=3 to krDoc.GetMaxColum do begin
        St:=StrPas(ColumList[i]);
        St:=GetColumStr(St);
        GetMem( pRow^.pChAry[i], MaxCharLength );
        StrPCopy( pRow^.pChAry[i], St);
    end;

end;

function ContainerClass.AllocRow(RowSize:integer;PageNode:TDOMNode):pRowInfo;
var
    pRow,pCurRow:pRowInfo;
    riRecord  : RECORDINSERT;
    node:TDOMNode;
begin
    isDataExist:=TRUE;
    pRow :=
      pRowInfo(
        PVOIDFROMMR(
          WinSendMsg(hwndCntr,
                     CM_ALLOCRECORD,
                     MPFROMLONG(GetRowInfoSize),
                     MPFROMSHORT(RowSize) )));
    AllocRow:=pRow;
    riRecord.cb := sizeof(RECORDINSERT);
    riRecord.pRecordOrder := PRECORDCORE(CMA_END);
    riRecord.fInvalidateRecord := ord(FALSE);
    riRecord.zOrder := CMA_TOP;
    riRecord.pRecordParent := Nil;
    riRecord.cRecordsInsert := 1;


    pCurRow:=pRow;
    IF PageNode=Nil THEN BEGIN
        SetRow(pCurRow,nil);
        WinSendMsg(hwndCntr,
                   CM_INSERTRECORD,
                   MPFROMP(pCurRow),
                   MPFROMP(@riRecord));

    END
    ELSE BEGIN
        Node:=PageNode.FindNode(ItemPath);
        while Node<>Nil do begin
            SetRow(pCurRow,node);
            WinSendMsg(hwndCntr,
                       CM_INSERTRECORD,
                       MPFROMP(pCurRow),
                       MPFROMP(@riRecord));


            pCurRow := pRowInfo( pCurRow^.Core.preccNextRecord );
            node:=Node.NextSibling;
        end;
    end;
end;

function ContainerClass.GetRowInfoSize:integer;
begin
    result:=SizeOf(RECORDCORE)+SizeOf(pChar)*KrDoc.GetMaxColum;
end;

procedure ContainerClass.SetColum;
Var
    ciInfo       : CNRINFO;
    pfiCurrent   : PFIELDINFO;
    pfiInfo      : PFIELDINFO;
    pfiLefty     : PFIELDINFO;
    fiiInfo      : FIELDINFOINSERT;
    i:integer;
begin
    pfiInfo := pFieldInfo(
                 PVoidFromMr(
                   WinSendMsg( hwndCntr,
                               CM_ALLOCDETAILFIELDINFO,
                               MPFROMLONG(KrDoc.GetMaxColum),0)));

    pfiCurrent := pfiInfo;

    pfiCurrent^.flData := CFA_BITMAPORICON OR CFA_HORZSEPARATOR OR
                          CFA_CENTER OR CFA_SEPARATOR;

    pfiCurrent^.flTitle := CFA_STRING OR CFA_CENTER;
    pfiCurrent^.pTitleData := ColumList[1];
    pfiCurrent^.offStruct := ofs( pRowInfo(nil)^.Core.hptrIcon );
    pfiCurrent := pfiCurrent^.pNextFieldInfo;
    pfiCurrent^.flData := CFA_STRING OR CFA_CENTER OR CFA_HORZSEPARATOR;

    pfiCurrent^.flTitle := CFA_STRING OR CFA_CENTER;
    pfiCurrent^.pTitleData := ColumList[2];
    pfiCurrent^.offStruct := ofs( pRowInfo(nil)^.Core.pszIcon );

    pfiLefty := pfiCurrent;

    for i:=3 to KrDoc.GetMaxColum do begin
        pfiCurrent := pfiCurrent^.pNextFieldInfo;
        pfiCurrent^.flData := CFA_STRING OR CFA_CENTER OR
                              CFA_HORZSEPARATOR OR CFA_SEPARATOR;

        pfiCurrent^.flTitle := CFA_STRING OR CFA_CENTER;
        pfiCurrent^.pTitleData := ColumList[i];
        pfiCurrent^.offStruct := ofs( pRowInfo(nil)^.pChAry[i] );
    end;

    fiiInfo.cb := sizeof(fiiInfo);
    fiiInfo.pFieldInfoOrder := pFIELDINFO(CMA_FIRST);
    fiiInfo.cFieldInfoInsert := KrDoc.GetMaxColum;
    fiiInfo.fInvalidateFieldInfo := ord(TRUE);

    WinSendMsg(hwndCntr,
               CM_INSERTDETAILFIELDINFO,
               MPFROMP(pfiInfo),
               MPFROMP(@fiiInfo));

    ciInfo.cb := sizeof(CNRINFO);
    ciInfo.pFieldInfoLast := pfiLefty;
    ciInfo.xVertSplitbar := CX_SPLITBAR;

    WinSendMsg(hwndCntr,
               CM_SETCNRINFO,
               MPFROMP(@ciInfo),
               MPFROMLONG(CMA_PFIELDINFOLAST OR CMA_XVERTSPLITBAR));
end;

procedure ContainerClass.SetStyle(style:ULong);
var
    ciInfo    : CNRINFO;
begin
    ciInfo.cb := sizeof(CNRINFO);
    ciInfo.flWindowAttr := style;

    WinSendMsg( hwndCntr,
                CM_SETCNRINFO,
                MPFROMP(@ciInfo),
                MPFROMLONG(CMA_FLWINDOWATTR));
    IF CV_ICON and Style >0 THEN
            WinSendMsg( hwndCntr,
                        CM_ARRANGE,
                        0,
                        0);
end;

procedure ContainerClass.InsertNewRecord;
var
    pRow:pRowInfo;
    Ri:RecordInsert;
    i:integer;
begin
    isDataExist:=TRUE;
    pRow:=pRowInfo(WinSendMsg(hwndCntr,
                              CM_AllocRecord,
                              MPFROMLONG(GetRowInfoSize),
                              MPFROMSHORT(1)));
    pRow^.Core.cb := sizeof(RECORDCORE);

    GetMem( pRow^.Core.pszIcon, MaxCharLength );
    if pRow^.Core.pszIcon <> Nil then begin
        strpCopy( pRow^.Core.pszIcon,'New Record');
    end;
    pRow^.Core.hptrIcon := WinLoadPointer(HWND_DESKTOP,
                                                  NULLHANDLE,
                                                  ICO_ITEM);
    for i:=1 to KrDoc.GetMaxColum do begin
        GetMem(pRow^.pChAry[i],MaxCharLength);
        pRow^.pChAry[i]:='';
    end;
    ri.cb := sizeof(RECORDINSERT);
    ri.pRecordOrder := PRECORDCORE(CMA_END);
    ri.fInvalidateRecord := ord(FALSE);
    ri.zOrder := CMA_TOP;
    ri.pRecordParent := Nil;
    ri.cRecordsInsert := 1;
    WinSendMsg(hwndCntr,
               CM_InsertRecord,
               MPFROMP(pRow),
               MPFROMP(@ri));
    WinSendMsg( hwndCntr,
                CM_INVALIDATERECORD,
                MPFROMP(pRow),
                MPFROM2SHORT(0,CMA_TEXTCHANGED));
end;

procedure ContainerClass.FlushRowList;
begin
    IF Assigned(RowList) THEN BEGIN
        RowList.Free;
        RowList:=Nil;
    END;
end;

procedure ContainerClass.GetRowList;
var
    pRow:pRowInfo;
begin
    RowList:=TList.Create;
    pRow:=pRowInfo(WinSendMsg( hwndCntr,
                               CM_QUERYRECORD,
                                MPFROMP(nil),
                                MPFROM2SHORT(CMA_FIRST,CMA_ITEMORDER)));
    while pRow<>Nil do begin
        RowList.Add(pRow);
        pRow:=pRowInfo(
                WinSendMsg( hwndCntr,
                            CM_QUERYRECORD,
                            MPFROMP(pRow),
                            MPFROM2SHORT(CMA_NEXT,CMA_ITEMORDER)));
    END;
end;

function ContainerClass.GetRowListCount:integer;
begin
    IF Assigned(RowList) THEN result:=RowList.Count else result:=0;
end;

function ContainerClass.GetRowByIndex(i:integer):pRowInfo;
begin
    IF Assigned(RowList) THEN
        result:=pRowInfo(RowList[i])
    else
        result:=nil;
end;

function ContainerClass.isData:boolean;
begin
    result:=isDataExist;
end;

constructor KrPageManegerClass.Create(hwndNotebook:hwnd);
begin
    hwndNB:=hwndNotebook;
    ContainerList:=TList.Create;
    MaxColum:=0;
    DataDoc:=KrXMLDocClass.Create;
end;

procedure KrPageManegerClass.CreateBlankPage;
var
    pChTitle:pChar;
    PageID:ULong;
    hwndPage:hwnd;
begin
    PageID:=WinSendMsg( hwndNb,
                        BKM_INSERTPAGE,
                        0,
                        MPFROM2SHORT(BKA_MAJOR or BKA_AUTOPAGESIZE,BKA_LAST));
    hwndPage:=CreateCell(nbClient,hwndNb,hwndNb);
    CntClass:=ContainerClass.Create(WinWindowFromID(hwndPage,ID_CONTAINER),
                                    DataDoc);//
    CntClass.id:=PageID;
    GetMem(pChTitle,MaxCharLength);
    pChTitle:='Blank';
    WinSendMsg(hwndNb, BKM_SETTABTEXT, PageID, LONG(pChTitle));
    CntClass.GroupName:=StrPas(pChTitle);

    CntClass.SetColum;
    MaxColum:=CntClass.KrDoc.GetMaxColum;
    CntClass.SetStyle(  CV_DETAIL OR
                        CA_DETAILSVIEWTITLES
                        or cv_mini);
    ContainerList.Add(CntClass);

    WinSendMsg(hwndNb, BKM_SETPAGEWINDOWHWND, PageID, hwndPage);
end;

function KrPageManegerClass.SetPageFromNode(node:TDOMNode):TDOMNode;
var
    pChTitle:pChar;
    st:string;
begin
    IF node=nil then begin
        result:=nil; exit;
    end;
    CntClass.AllocRow(DataDoc.GetMaxPageNode(node),node);
    GetMem(pChTitle,MaxCharLength);
    st:=TDOMElement(Node).GetAttribute(PageNameAttr);
    CntClass.GroupName:=st;
    StrPCopy(pChTitle,st);
    WinSendMsg(hwndNb, BKM_SETTABTEXT, CntClass.id, LONG(pChTitle));

    CntClass.SetColum;
    MaxColum:=CntClass.KrDoc.GetMaxColum;
    CntClass.SetStyle(  CV_DETAIL OR
                        CA_DETAILSVIEWTITLES
                        or cv_mini);
    result:=node.NextSibling;
end;

function KrPageManegerClass.GetContainer(id:ULong):ContainerClass;
var
    i:integer;
begin
    for i:=0 to ContainerList.Count-1 do begin
        if ContainerClass(ContainerList[i]).id=id THEN BEGIN
            result:=ContainerClass(ContainerList[i]);
            exit;
        END;
    end;
    result:=nil
end;

function KrPageManegerClass.GetTopPageContainer:ContainerClass;
var
    CurPageID:ULong;
begin
    CurPageID:=WinSendMsg( hwndNB,
                           BKM_QUERYPAGEID,
                           CurPageID,
                           MPFROM2SHORT(BKA_TOP,BKA_MAJOR));
    result:=GetContainer(CurPageID);
end;

procedure KrPageManegerClass.CnrToDoc;
var
    pRow:pRowInfo;
    Cntr:ContainerClass;
    i,ii,j:integer;
    MaxPage:integer;
    node:TDOMNode;
    ItemNode:TDOMElement;
begin
    MaxPage:=ContainerList.Count;
    for i:=0 to MaxPage-1 do begin
        Cntr:=ContainerClass(ContainerList[i]);
        IF Cntr.isData THEN BEGIN
            Node:=DataDoc.CreatePageData(Cntr.GroupName);
            Cntr.GetRowList;
            for ii:=0 to Cntr.GetRowListCount-1 do begin
                pRow:=Cntr.GetRowByIndex(ii);
                ItemNode:=DataDoc.CreatePageItemData(node);
                for j:=1 to MaxColum do
                    DataDoc.SetNodeAttr(ItemNode,j,pRow);
            end;
            Cntr.FlushRowList;
        END;
    end;
end;

procedure KrPageManegerClass.SaveFile;
begin
    DataDoc.SaveDoc;
end;

Function FindFile(hwndClient:HWnd;var FileSt:String):Bool;
Var
    fdFileDlg:Os2PmApi.FileDlg;
    pCh:pChar;
begin
    Fillchar( fdFileDlg, sizeof(fdFileDlg), 0);
    fdFileDlg.cbSize := sizeof(Os2PmApi.FileDlg);
    fdFileDlg.fl := FDS_CENTER OR FDS_PRELOAD_VOLINFO OR FDS_OPEN_DIALOG;
    GetMem(pCh,128);
    pCh:='*.xml';
    StrCopy(fdFileDlg.szFullFile,pCh);

    WinFileDlg( HWND_DESKTOP,hwndClient,fdFileDlg );
    FileSt:=StrPas( fdFileDlg.szFullFile);
    if (FileSt='*.xml') or (FileSt='') then begin
        FindFile := False;
    end
    else begin
        FindFile := TRUE;
    end;
end; { FindFile }

var
    KrPageMan:KrPageManegerClass;
function MainClientProc(Window: HWnd; Msg: ULong; Mp1,Mp2: MParam): MResult;
var
    pWCtlData:PWindowCellCtlData;
    CurCntr:ContainerClass;
    CurPageID:ULong;
    i:integer;
    node:TDOMNode;
    St:string;
begin
    pWCtlData:=PWindowCellCtlData(WinQueryWindowULong(Window,QWL_USER));
    result   :=0;
    case msg of
        WM_COMMAND:begin
            case SHORT1FROMMP(mp1) of
                IDB_EXIT:begin
                    WinPostMsg(Window, WM_QUIT, 0, 0);
                end;
                IDB_VIEWDETAIL:begin
                    CurPageID:=WinSendMsg(KrPageMan.hwndNB,
                                          BKM_QUERYPAGEID,
                                          CurPageID,
                                          MPFROM2SHORT(BKA_TOP,BKA_MAJOR));

                    CurCntr:=KrPageMan.GetContainer(CurPageID);

                    CurCntr.SetStyle(  CV_DETAIL OR
                                       CA_DETAILSVIEWTITLES
                                       or cv_mini);

                end;
                IDB_VIEWICON:begin
                    CurPageID:=WinSendMsg( KrPageMan.hwndNB,
                                           BKM_QUERYPAGEID,
                                           CurPageID,
                                           MPFROM2SHORT(BKA_TOP,BKA_MAJOR));
                    CurCntr:=KrPageMan.GetContainer(CurPageID);

                    CurCntr.SetStyle(  CV_ICON OR
                                       CA_DETAILSVIEWTITLES );
                end;
                IDB_FILEOPEN:BEGIN
                    IF FindFile(KrPageMan.FrameWindow,St) THEN BEGIN
                        IF KrPageMan.DataDoc.isKrDoc(St) THEN BEGIN
                            IF KrPageMan.GetTopPageContainer.isData THEN
                                KrPageMan.CreateBlankPage;
                        END;
                        node:=KrPageMan.DataDoc.GetFirstPage;
                        while node<>Nil do begin
                            node:=KrPageMan.SetPageFromNode(node);
                            IF node<>nil THEN KrPageMan.CreateBlankPage;
                        end;
                        KrPageMan.DataDoc.FlushXMLData;
                    END;
                END;
                IDB_FILESAVE:BEGIN
                    IF KrPageMan.DataDoc.isDoc THEN BEGIN
                        KrPageMan.CnrToDoc;
                        KrPageMan.SaveFile;
                        KrPageMan.DataDoc.FlushXMLData;
                    END;
                END;
                IDB_FILSAVAS:BEGIN
                    IF FindFile(KrPageMan.FrameWindow,St) THEN BEGIN
                        KrPageMan.DataDoc.SetFileName(st);
                    END;
                    IF KrPageMan.DataDoc.isDoc THEN BEGIN
                        KrPageMan.CnrToDoc;
                        KrPageMan.SaveFile;
                        KrPageMan.DataDoc.FlushXMLData;
                    END;
                END;
                ID_NewPage:BEGIN
                    KrPageMan.CreateBlankPage;
                END;
                ID_ConfPage:BEGIN
                    IF WinDlgBox(HWND_DESKTOP,Window,
                                 ConfDlgProc,NULLHANDLE,
                                 DLG_PAGECONFIG,pChDlg)=Ord(TRUE) THEN BEGIN
                        CurPageID:=WinSendMsg( KrPageMan.hwndNB,
                                           BKM_QUERYPAGEID,
                                           CurPageID,
                                           MPFROM2SHORT(BKA_TOP,BKA_MAJOR));
                        WinSendMsg(KrPageMan.hwndNb,
                                   BKM_SETTABTEXT, CurPageID, LONG(pChDlg));
                        CurCntr:=KrPageMan.GetContainer(CurPageID);
                        CurCntr.GroupName:=StrPas(pChDlg);
                    END;
                END;
                ID_NewItem:begin
                    CurPageID:=WinSendMsg( KrPageMan.hwndNB,
                                           BKM_QUERYPAGEID,
                                           CurPageID,
                                           MPFROM2SHORT(BKA_TOP,BKA_MAJOR));
                    CurCntr:=KrPageMan.GetContainer(CurPageID);
                    CurCntr.InsertNewRecord;
                end;
            end;
        end;
        WM_CLOSE:begin
            IF KrPageMan.DataDoc.isDoc THEN KrPageMan.CnrToDoc;
            WinPostMsg(Window, WM_QUIT, 0, 0);
        end;
        WM_DESTROY:BEGIN
            IF KrPageMan.DataDoc.isDoc THEN BEGIN
                KrPageMan.SaveFile;
            END;
        END;
        else BEGIN
            if pWCtlData<>nil then
                result:=pWCtlData^.pOldProc(Window, msg, mp1, mp2)
            else
                result:=WinDefWindowProc(Window, msg, mp1, mp2);
        end;
    end;(**case msg**)
end;

function ContainerClientProc(Window:HWnd;Msg:ULong;Mp1,Mp2:MParam):MResult;
var
    pWCtlData:PWindowCellCtlData;
    pCnrEdit:pCNREDITDATA;
    pRI:pRowInfo;
    nCh:pChar;
    hwndCnr,hwndMLE:hwnd;
    DataOffset:integer;
    AryIndex:integer;
    newsize:integer;
begin
    pWCtlData:=PWindowCellCtlData(WinQueryWindowULong(Window,QWL_USER));
    result   :=0;
    case msg of
        WM_CONTROL:BEGIN
            case SHORT2FROMMP(mp1) of
                CN_REALLOCPSZ:BEGIN
                    pCnrEdit:=pCNREDITDATA(mp2);
                    NewSize:=pCnrEdit^.cbText+1;
                END;
                CN_ENDEDIT:BEGIN
                    pCnrEdit:=pCNREDITDATA(mp2);
                    pRI:=pRowInfo(pCnrEdit^.pRecord);
                    DataOffset:=pCnrEdit^.pFieldInfo^.OffStruct;
                    hwndCnr:=pCnrEdit^.hwndCnr;
                    hwndMLE:=WinWindowFromID(hwndCnr,CID_MLE);
                    AryIndex:=(DataOffset-SizeOF(RECORDCORE)) div 4 +1;
                    IF NewSize<MaxCharLength then NewSize:=MaxCharLength;
                    GetMem(nCh,NewSize);
                    WinQueryWindowText( hwndMLE, NewSize, nCh);
                    IF DataOffset<SizeOf(RECORDCORE) THEN begin
                        pRI^.Core.pszIcon:=nCh;
                    end
                    ELSE BEGIN
                        pRI^.pChAry[AryIndex]:=nCh;;
                    END;
                    WinSendMsg( hwndCnr,
                                CM_INVALIDATERECORD,
                                MPFROMP(pRI),
                                MPFROM2SHORT(0,CMA_TEXTCHANGED));
                END;(**CN_ENDEDIT**)
            end;(**case**)
        END;(**wm_control**)
        else BEGIN
            if pWCtlData<>nil then
                result:=pWCtlData^.pOldProc(Window, msg, mp1, mp2)
            else
                result:=WinDefWindowProc(Window, msg, mp1, mp2);
        end;
    end;(**case msg**)
end;

function ConfDlgProc( hwndDlg: HWND ;
                      ulMsg  : ULONG;
                      mp1    : MPARAM;
                      mp2    : MPARAM ) : mResult;
BEGIN
    result:=0;
    case(ulMsg) of
        WM_INITDLG:BEGIN
            pChDlg:=pChar(mp2);
            WinSendMsg(WinWindowFromID(hwndDlg,DID_EDIT_CONTROL),
                       EM_SETTEXTLIMIT,
                       MaxCharLength,
                       NullHandle);
        END;
        WM_COMMAND:BEGIN
            Case Short1FromMP( mp1) of
                DID_OK:BEGIN
                    WinQueryWindowText( WinWindowFromID(hwndDlg,DID_EDIT_CONTROL),
                                        MaxCharLength,
                                        pChDlg);
                    WinDismissDlg(hwndDlg,Ord(TRUE));
                END;
                DID_CANCEL:WinDismissDlg(hwndDlg,Ord(false));
            end;
        END;(**WM_COMMNAD**)
        ELSE BEGIN
           result:=WinDefDlgProc(hwndDlg,ulMsg,mp1,mp2);
        END;
    end;(**case**)
END;


var
    Anchor   :HAB;
    mq       :HMQ;
    msg      :QMSG;
    hwndFrame:HWND;
    swp      :os2pmapi.SWP;
    hwndNB:hwnd;
    Node:TDOMNode;
begin
    GetMem(pChDlg,MaxCharLength);
    Anchor:=WinInitialize(0);
    if Anchor=0 then halt(-1);

    mq:=WinCreateMsgQueue(Anchor, 0);

    if mq=0 then begin
        WinTerminate(Anchor);
        halt(-2);
    end;

    ToolkitInit(Anchor);

    WinQueryWindowPos(HWND_DESKTOP, swp);

    hwndFrame:=CreateCell(mainFrame, HWND_DESKTOP, 0);

    if hwndFrame<>0 then begin
        hwndNb:=CellWindowFromID(hwndFrame, ID_NOTEBOOK);
        WinSetPresParam(hwndNb,PP_FONTNAMESIZE,sizeof(ppNbFont),ppNbFont);

        KrPageMan:=KrPageManegerClass.Create(hwndNB);
        KrPageMan.FrameWindow:=hwndFrame;
        KrPageMan.CreateBlankPage;
        WinSetWindowPos(hwndFrame,
                        NULLHANDLE,
                        swp.x+swp.cx div 8,
                        swp.y+swp.cy div 8,
                        (swp.cx div 4)* 3,
                        (swp.cy div 4)*3,
                        SWP_ACTIVATE or SWP_MOVE or SWP_SIZE or SWP_SHOW);
        CreateToolbar(hwndFrame,mainTb);

        // -------------------------------
        while WinGetMsg(Anchor,msg,0,0,0) do WinDispatchMsg(Anchor,msg);
        // -------------------------------
        WinDestroyWindow(hwndFrame);
    end;

    WinDestroyMsgQueue(mq);
    WinTerminate(Anchor);
end.



WinDef
getmem
freemem
reallocmem
WinLoadDlg
