(*
** Module   :MULTIBAR.C
** Abstract :Test and sample application for Cell toolkit procedures.
**
** Copyright (C) Sergey I. Yevtushenko
** Log: Sun  08/02/98   Refined
**
**)

(*
** Module   :MULTIBAR.C
** Abstract :
**
** Copyright (C) Sergey I. Yevtushenko
** Log: Fri  19/02/1998     Created
**
*)
uses os2def,os2pmapi,cell,strings;

{$PMTYPE PM}

{$I multibar.inc}

{$R multibar.res}


(* Local procedures *)

function MainClientProc(Window:
                        HWnd; Msg:
                        ULong;
                        Mp1,Mp2: MParam): MResult; cdecl; forward;


(* Static Variables *)
const
    Panel0 : CellDef =
        (lType:CELL_WINDOW;
         pszClass:WC_BUTTON;
         pszName:'Button panel0';
         ulStyle:BS_PUSHBUTTON or WS_VISIBLE;
         ulID:ID_RPANE);

    Panel1 : CellDef =
        (lType:CELL_WINDOW;
         pszClass:WC_STATIC;
         pszName:'Button panel1';
         ulStyle:SS_TEXT or DT_CENTER or DT_VCENTER or WS_VISIBLE;
         ulID:ID_LPANE);

    uPanel : CellDef =
        (lType:CELL_HSPLIT or CELL_SPLITBAR or CELL_FIXED or CELL_SIZE2;
         pszClass:Nil;
         pszName:'';
         ulStyle:WS_VISIBLE;
         ulID:ID_RPANE;
         pPanel1:@Panel0;
         pPanel2:@Panel1;
         pClassProc:nil;
         pClientClassProc:nil;
         lSize:40);
    dPanel : CellDef =
        (lType:CELL_WINDOW;
         pszClass:WC_STATIC;
         pszName:'Button dPannel';
         ulStyle:SS_TEXT or DT_CENTER or DT_VCENTER or WS_VISIBLE;
         ulID:ID_LPANE;
         pPanel1:@Panel0;
         pPanel2:@Panel1;
         pClassProc:nil;
         pClientClassProc:nil;
         lSize:40);

    rPanel : CellDef =
        (lType:CELL_VSPLIT or CELL_SPLITBAR or CELL_SPLIT30x70;
         pszClass:Nil;
         pszName:'SubWindow';
         ulStyle:WS_VISIBLE;
         ulID:ID_RPANE;
         pPanel1:@uPanel;
         pPanel2:@dPanel);

    lPanel : CellDef =
        (lType:CELL_VSPLIT or CELL_SPLITBAR or CELL_SPLIT70x30;
         pszClass:Nil;
         pszName:'';
         ulStyle:WS_VISIBLE;
         ulID:ID_LPANE;
         pPanel1:@uPanel;
         pPanel2:@dPanel);
     mainClient :CellDef=
        (lType:CELL_HSPLIT or CELL_SPLITBAR;
         pszClass:nil;
         pszName:'Maltiple Toolbars Sampes';
         ulStyle:FCF_TITLEBAR or FCF_SYSMENU  or FCF_MENU or
                 FCF_MINMAX or FCF_TASKLIST or FCF_SIZEBORDER or 0;
         ulID:MAIN_FRAME;
         pPanel1:@lPanel;
         pPanel2:@rPanel;
         pClassProc:nil;
         pClientClassProc:MainClientProc);


mainItems:array[0..17] of LongInt=
(
    IDB_FILENEW ,
    IDB_FILEOPEN,
    IDB_FILESAVE,
    IDB_FILSAVAS,
    TB_SEPARATOR,
    IDB_EXIT    ,
    TB_SEPARATOR,
    IDB_EDITCOPY,
    IDB_EDITCUT ,
    IDB_EDITFIND,
    IDB_EDITFNNX,
    IDB_EDITPAST,
    IDB_EDITREPL,
    IDB_EDITUNDO,
    TB_SEPARATOR,
    IDB_HELP    ,
    IDB_ABOUT   ,
    0
);

mainItems1:array[0..5] of LongInt=
(
    IDB_FILENEW ,
    TB_SEPARATOR,
    IDB_FILEOPEN,
    IDB_FILESAVE,
    IDB_FILSAVAS,
    0
);

mainItems2:array[0..9]of LongInt=
(
    IDB_EDITCOPY,
    IDB_EDITCUT ,
    IDB_EDITPAST,
    TB_SEPARATOR,
    IDB_EDITFIND,
    IDB_EDITFNNX,
    IDB_EDITREPL,
    TB_SEPARATOR,
    IDB_EDITUNDO,
    0
);

mainItems3:array[0..2]of longint=
(
    IDB_HELP ,
    IDB_ABOUT,
    0
);

mainItems4:array[0..4]of longint=
(
    IDB_EXIT    ,
    TB_SEPARATOR,
    IDB_HELP    ,
    IDB_ABOUT   ,
    0
);


mainTb:TBDef =
(
    ltype:TB_VERTICAL or TB_ATTACHED_LT or TB_BUBBLE;
    ulID:ID_TOOLBAR;
    tbitems:@mainItems
);

mainTb1 :TBDef=
(
    ltype:TB_VERTICAL or TB_ATTACHED_RT or TB_BUBBLE;
    ulID:ID_TOOLBAR;
    tbitems:@mainItems1);

mainTb2 :TBDef=
    (ltype:0 or TB_ATTACHED_TP or TB_BUBBLE;
     ulID:ID_TOOLBAR;
     tbItems:@mainItems2);

mainTb3 :TBDef=
    (   ltype:0 or TB_ATTACHED_BT or TB_BUBBLE;
        ulID:ID_TOOLBAR;
        tbItems:@mainItems3);

mainTb4 :TBDef=
    (   ltype:TB_VERTICAL or TB_FLOATING or TB_BUBBLE;
        ulID:ID_TOOLBAR;
        tbItems:@mainItems4);

mainTb5 :TBDef=
(   ltype:0 or TB_FLOATING or TB_BUBBLE;
    ulID:ID_TOOLBAR;
    tbItems:@mainItems);

function OKMsgBox(pszText:pchar):ulong;
begin
    result:=WinMessageBox(HWND_DESKTOP,
                          HWND_DESKTOP,
                          pszText,
                          'Cell Demo',
                          0,
                         MB_OK or MB_INFORMATION or MB_APPLMODAL);
end;

function MainClientProc(Window: HWnd; Msg: ULong; Mp1,Mp2: MParam): MResult;
var pWCtlData:PWindowCellCtlData;
begin
  pWCtlData:=PWindowCellCtlData(WinQueryWindowULong(Window,QWL_USER));
  result   :=0;
  case msg of
    WM_COMMAND:begin
        case SHORT1FROMMP(mp1) of
            IDB_EXIT:begin
                WinPostMsg(Window, WM_QUIT, 0, 0);
                exit;
            end;
            ID_LPANE:OKMsgBox('Button ID_LPANE pressed!');
            ID_RPANE:OKMsgBox('Button ID_RPANE pressed!');
            MAIN_FRAME:OKMsgBox('Button MAIN_FRAME pressed!');
            ID_TOOLBAR:OKMsgBox('Button ID_TOOLBAR pressed!');
        end;
      end;
    WM_CLOSE:begin
        WinPostMsg(Window, WM_QUIT, 0, 0);
        exit;
      end;
  end;
  if pWCtlData<>nil then
    result:=pWCtlData^.pOldProc(Window, msg, mp1, mp2)
  else
    result:=WinDefWindowProc(Window, msg, mp1, mp2);
end;

var Anchor   :HAB;
    mq       :HMQ;
    msg      :QMSG;
    hwndFrame,hwndSubFrame,MainFrame:HWND;
    swp      :os2pmapi.SWP;
    ulPageId :longint;
    cText    :array [byte] of char;
    cTPos    :pchar;
    ii,jj    :longint;
begin
  Anchor:=WinInitialize(0);
  if Anchor=0 then halt(-1);

  mq:=WinCreateMsgQueue(Anchor, 0);

  if mq=0 then begin
    WinTerminate(Anchor);
    halt(-2);
  end;

  ToolkitInit(Anchor);

  WinQueryWindowPos(HWND_DESKTOP, swp);

  hwndFrame:=CreateCell(mainClient, HWND_DESKTOP, 0);

  if hwndFrame<>0 then begin
    hwndSubframe := CellWindowFromID(hwndFrame, ID_LPANE);
    WinSetWindowPos(hwndFrame,
                    NULLHANDLE,
                    swp.x+swp.cx div 8,
                    swp.y+swp.cy div 8,
                    (swp.cx div 4)* 3,
                    (swp.cy div 4)*3,
                    SWP_ACTIVATE or SWP_MOVE or SWP_SIZE or SWP_SHOW);
    CreateToolbar(hwndFrame, mainTb);
    CreateToolbar(hwndFrame, mainTb1);
    CreateToolbar(hwndFrame, mainTb2);
    CreateToolbar(hwndFrame, mainTb3);
    CreateToolbar(hwndFrame, mainTb4);
    IF hwndSubFrame<>NullHandle THEN
        CreateToolbar(hwndSubframe, mainTb5);


    // -------------------------------
    while WinGetMsg(Anchor,msg,0,0,0) do WinDispatchMsg(Anchor,msg);
    // -------------------------------
    WinDestroyWindow(hwndFrame);
  end;

  WinDestroyMsgQueue(mq);
  WinTerminate(Anchor);
end.


