/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.util;

import de.zwanzigeins.util.LockObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.zip.ZipFile;
import net.zerotoaster.httpd.mods.IntermediateModuleData;

public final class Helper {
    private static Hashtable hshLockedFiles = new Hashtable();

    private Helper() {
    }

    public static final boolean checkString(String string, String string2) {
        String s = string.toLowerCase();
        String templ = string2.toLowerCase();
        int wildPos = templ.indexOf(42);
        if (wildPos == -1) {
            return s.equals(templ);
        }
        int templLen = templ.length();
        int strLen = s.length();
        int templIndex = 0;
        int strIndex = 0;
        boolean wildCard = false;
        while (templIndex < templLen) {
            if (templ.charAt(templIndex) == '*') {
                wildCard = true;
                ++templIndex;
                continue;
            }
            int nextWild = templ.indexOf(42, templIndex);
            if (nextWild == -1) {
                nextWild = templLen;
            }
            String templPart = templ.substring(templIndex, nextWild);
            templIndex = nextWild;
            if (wildCard) {
                int pos = s.indexOf(templPart);
                if (pos == -1) {
                    return false;
                }
                strIndex = pos + templPart.length();
            } else {
                if (!s.regionMatches(false, 0, templPart, 0, templPart.length())) {
                    return false;
                }
                strIndex += templPart.length();
            }
            wildCard = false;
        }
        return wildCard ? true : strIndex == strLen;
    }

    public static final void close(Object o) {
        if (o == null) {
            return;
        }
        try {
            if (o instanceof InputStream) {
                ((InputStream)o).close();
                return;
            }
            if (o instanceof OutputStream) {
                ((OutputStream)o).close();
                return;
            }
            if (o instanceof Writer) {
                ((Writer)o).close();
                return;
            }
            if (o instanceof Reader) {
                ((Reader)o).close();
                return;
            }
            if (o instanceof Socket) {
                ((Socket)o).close();
                return;
            }
            if (o instanceof ServerSocket) {
                ((ServerSocket)o).close();
                return;
            }
            if (o instanceof RandomAccessFile) {
                ((RandomAccessFile)o).close();
                return;
            }
            if (o instanceof ZipFile) {
                ((ZipFile)o).close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public static final boolean fileLock(String strFile) {
        Hashtable hashtable = hshLockedFiles;
        synchronized (hashtable) {
            if (hshLockedFiles.containsKey(strFile)) {
                return false;
            }
            hshLockedFiles.put(strFile, "0");
            return true;
        }
    }

    public static final Enumeration filesLocked() {
        return hshLockedFiles.keys();
    }

    public static final boolean fileUnlock(String strFile) {
        Hashtable hashtable = hshLockedFiles;
        synchronized (hashtable) {
            return hshLockedFiles.remove(strFile) != null;
        }
    }

    public static final String fromHexURL(String str) {
        if (str.indexOf("%") == -1) {
            return str;
        }
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '%' && i < str.length() - 2) {
                String s = "";
                s = String.valueOf(s) + str.charAt(++i);
                s = String.valueOf(s) + str.charAt(++i);
                s = s.toLowerCase();
                try {
                    strb.append((char)Integer.parseInt(s, 16));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new RuntimeException("Unable to parse " + str);
                }
            } else {
                strb.append(str.charAt(i));
            }
            ++i;
        }
        return strb.toString();
    }

    public static final long fromHTTPDate(String s) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en", "en"));
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        try {
            return sdf.parse(s).getTime();
        }
        catch (ParseException parseException) {
            return -1L;
        }
    }

    public static final String getMimeType(IntermediateModuleData imd) {
        String strContentType;
        String strExt = "default";
        int pp = imd.strFileToServe.lastIndexOf(".");
        if (pp != -1) {
            strExt = imd.strFileToServe.substring(pp + 1).trim().toLowerCase();
        }
        if ((strContentType = imd.iniVHOST.getPropertyString("MIME", strExt)).length() == 0) {
            strContentType = imd.iniVHOST.getPropertyString("MIME", "default");
        }
        return strContentType;
    }

    public static final String hexDigit(byte x) {
        String s = "";
        char c = (char)(x >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        s = String.valueOf(s) + c;
        c = (char)(x & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        s = String.valueOf(s) + c;
        return s;
    }

    public static final boolean isAbsolutePath(String s) {
        if (s.startsWith("/") || s.startsWith("\\")) {
            return true;
        }
        return s.length() > 1 && Character.isLetter(s.charAt(0)) && s.charAt(1) == ':';
    }

    public static void main(String[] args) {
        System.out.println(Helper.pathFixup("../Sitemap.htm", "/"));
        Object o = new Object();
        Class<?> cl = o.getClass();
        InputStream is = cl.getResourceAsStream("/zerotoaster.ini");
        System.out.println(is);
        Helper.close(is);
    }

    public static final String pathFixup(String string, String string2) {
        String strOrg;
        String strSlash;
        String strCmp = string;
        char chSlash = ' ';
        if (string2.length() == 0) {
            strSlash = "/";
            chSlash = '/';
        } else {
            chSlash = strSlash.charAt(0);
            strOrg = string.replace('/', chSlash);
            strOrg = strOrg.replace('\\', chSlash);
        }
        strCmp = strCmp.replace('/', chSlash);
        strCmp = strCmp.replace('\\', chSlash);
        String cmp = String.valueOf(strSlash) + strSlash;
        int pp = 0;
        while ((pp = strCmp.indexOf(cmp)) != -1) {
            strCmp = String.valueOf(strCmp.substring(0, pp + 1)) + strCmp.substring(pp + cmp.length());
            strOrg = String.valueOf(strOrg.substring(0, pp + 1)) + strOrg.substring(pp + cmp.length());
        }
        cmp = String.valueOf(strSlash) + "." + strSlash;
        pp = 0;
        while ((pp = strCmp.indexOf(cmp)) != -1) {
            strCmp = String.valueOf(strCmp.substring(0, pp + 1)) + strSlash + strCmp.substring(pp + cmp.length());
            strOrg = String.valueOf(strOrg.substring(0, pp + 1)) + strSlash + strOrg.substring(pp + cmp.length());
        }
        cmp = String.valueOf(strSlash) + ".." + strSlash;
        pp = 0;
        while ((pp = strCmp.indexOf(cmp)) != -1) {
            boolean blnFound = false;
            int i = pp - 1;
            while (i >= 0) {
                if (strCmp.charAt(i) == chSlash) {
                    strCmp = String.valueOf(strCmp.substring(0, i + 1)) + strCmp.substring(pp + cmp.length());
                    strOrg = String.valueOf(strOrg.substring(0, i + 1)) + strOrg.substring(pp + cmp.length());
                    blnFound = true;
                    break;
                }
                --i;
            }
            if (blnFound) continue;
            strCmp = strCmp.substring(pp + cmp.length() - 1);
            strOrg = strOrg.substring(pp + cmp.length() - 1);
        }
        if (strOrg.startsWith("." + strSlash)) {
            strOrg = strCmp.substring(1);
        }
        if (strOrg.startsWith(".." + strSlash)) {
            strOrg = strCmp.substring(2);
        }
        return strOrg;
    }

    /*
     * Unable to fully structure code
     */
    public static final String removeLeadingSlashes(String var0) {
        if (var0.length() != 0) ** GOTO lbl4
        return var0;
lbl-1000:
        // 1 sources

        {
            s = var0.substring(1);
lbl4:
            // 2 sources

            ** while (s.startsWith((String)"/") || s.startsWith((String)"\\"))
        }
lbl5:
        // 1 sources

        return s;
    }

    /*
     * Unable to fully structure code
     */
    public static final String removeTrailingSlashes(String var0) {
        if (var0.length() != 0) ** GOTO lbl4
        return var0;
lbl-1000:
        // 1 sources

        {
            s = var0.substring(0, var0.length() - 1);
lbl4:
            // 2 sources

            ** while (s.endsWith((String)"/") || s.endsWith((String)"\\"))
        }
lbl5:
        // 1 sources

        return s;
    }

    public static final String splitPath_getFile(String s) {
        int pp2;
        if (s.length() == 0) {
            return s;
        }
        int pp1 = s.lastIndexOf("/");
        int pp = pp1 < (pp2 = s.lastIndexOf("\\")) ? pp2 : pp1;
        return s.substring(pp + 1);
    }

    public static final String splitPath_getPath(String s) {
        if (s.length() == 0) {
            return s;
        }
        int pp1 = s.lastIndexOf("/");
        int pp2 = s.lastIndexOf("\\");
        if (pp1 == -1 && pp2 == -1) {
            return s;
        }
        int pp = pp1 < pp2 ? pp2 : pp1;
        return s.substring(0, pp + 1);
    }

    public static final String toHexURL(String str) {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch <= ' ' || ch >= '~') {
                strb.append("%");
                strb.append(Helper.hexDigit((byte)ch));
            } else {
                strb.append(ch);
            }
            ++i;
        }
        return strb.toString();
    }

    public static final String toHTTPDate(long lngTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", new Locale("en", "en"));
        sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
        return sdf.format(new Date(lngTime));
    }

    public static final String urlUp(String string) {
        int pp;
        String strURL;
        if (string.endsWith("/")) {
            strURL = string.substring(0, string.length() - 1);
        }
        if ((pp = strURL.lastIndexOf("/")) != -1) {
            strURL = strURL.substring(0, pp + 1);
        }
        return strURL;
    }

    public static final void wait_ms(long t) {
        LockObject objLock = new LockObject();
        objLock.lo_wait(t);
        objLock.dispose();
    }
}

