/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.util;

import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Statistics;

public class GlobalStatistics_Record
extends Statistics {
    public static volatile long lngServerStarted;
    public volatile long lngTotalRequestTime = 0L;
    public volatile long lngTotalRequestCount = 0L;
    private int[] intHourRequest = new int[24];
    private long[] lngHourBytes = new long[24];

    public void addResponse(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(TimeFactory.getTime()));
        int intHour = cal.get(11);
        ++this.lngTotalRequestCount;
        this.lngTotalRequestTime += httpRES.lngRequestFinished - httpREQ.lngRequestStarted;
        int n = intHour;
        this.intHourRequest[n] = this.intHourRequest[n] + 1;
        if (httpRES.lngTransferredBytes > 0L) {
            int n2 = intHour;
            this.lngHourBytes[n2] = this.lngHourBytes[n2] + httpRES.lngTransferredBytes;
        }
    }

    public void export_binary(PrintWriter pw) {
        pw.println("cp100");
        pw.println(this.lngTotalRequestTime);
        pw.println(this.lngTotalRequestCount);
        int i = 0;
        while (i < this.intHourRequest.length) {
            pw.print(this.intHourRequest[i]);
            pw.print(",");
            ++i;
        }
        pw.println();
        i = 0;
        while (i < this.lngHourBytes.length) {
            pw.print(this.lngHourBytes[i]);
            pw.print(",");
            ++i;
        }
        pw.println();
        pw.flush();
    }

    public void export_text(PrintWriter pw) {
        Date d = new Date(lngServerStarted);
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(true);
        pw.println("Server started    : " + HelperDT.getDDMMYYYY((Date)d) + " " + HelperDT.getHHMMSS((Date)d));
        pw.println("Requests served   : " + nf.format(this.lngTotalRequestCount));
        if (this.lngTotalRequestCount > 0L) {
            pw.println("Average in request: " + this.lngTotalRequestTime / this.lngTotalRequestCount + "ms");
        }
        if (this.getDetailLevel() > 0) {
            pw.println("");
            pw.println("Hour / Acesses / Bytes");
            pw.println("----------------------");
            int i = 0;
            while (i < this.intHourRequest.length) {
                pw.print(HelperFormat.rset((long)i, (int)2, (char)'0'));
                pw.print(": ");
                pw.print(nf.format(this.intHourRequest[i]));
                pw.print(" / ");
                pw.print(nf.format(this.lngHourBytes[i]));
                pw.println();
                ++i;
            }
        }
        pw.flush();
    }

    public void import_binary(BufferedReader br) throws IOException {
        br.readLine();
        this.lngTotalRequestTime = Long.parseLong(br.readLine());
        this.lngTotalRequestCount = Long.parseLong(br.readLine());
        StringTokenizer strtAccess = new StringTokenizer(br.readLine(), ",");
        int i = 0;
        while (i < this.intHourRequest.length) {
            this.intHourRequest[i] = Integer.parseInt(strtAccess.nextToken());
            ++i;
        }
        StringTokenizer strtBytes = new StringTokenizer(br.readLine(), ",");
        int i2 = 0;
        while (i2 < this.lngHourBytes.length) {
            this.lngHourBytes[i2] = Long.parseLong(strtBytes.nextToken());
            ++i2;
        }
    }

    public void reset() {
        this.lngTotalRequestCount = 0L;
        this.lngTotalRequestTime = 0L;
        this.intHourRequest = new int[this.intHourRequest.length];
        this.lngHourBytes = new long[this.lngHourBytes.length];
    }
}

