/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.util;

import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public final class CLF_Logger
implements Runnable {
    private static CLF_Logger clfLogger = null;
    private Configuration cnfConfig = null;
    private LogContext logContext = null;
    private static String LF = null;
    private Thread thrdLogging = null;
    private LockObject objLock = null;
    private volatile Vector vecQueue = null;
    private volatile boolean blnIsRunning = false;
    private final int QUEUE_SIZE = 50;
    private SimpleDateFormat sdf = null;
    private Date datBuffer = null;

    private CLF_Logger(Configuration cnfConfig, LogContext logContext) {
        this.cnfConfig = cnfConfig;
        this.logContext = logContext;
        this.init0();
    }

    private void convert(String strFile) throws IOException {
        File flOld = new File(strFile);
        if (!flOld.exists()) {
            return;
        }
        String strNew = String.valueOf(strFile) + "$";
        File flNew = new File(strNew);
        BufferedReader br = new BufferedReader(new FileReader(flOld));
        String strBuffer = br.readLine();
        if (strBuffer == null) {
            Helper.close(br);
            return;
        }
        if (strBuffer.indexOf(" GMT+") == -1) {
            Helper.close(br);
            return;
        }
        PrintWriter pw = new PrintWriter(new FileWriter(flNew));
        while (strBuffer != null) {
            int pp = strBuffer.indexOf("GMT+");
            if (pp != -1) {
                String strLeft = strBuffer.substring(0, pp);
                String strRight = strBuffer.substring(pp + 9);
                pw.println(String.valueOf(strLeft) + "+0200" + strRight);
            } else {
                pw.println(strBuffer);
            }
            strBuffer = br.readLine();
        }
        pw.close();
        br.close();
        flOld.delete();
        flNew.renameTo(flOld);
    }

    public static final void dispose() {
        if (clfLogger != null) {
            clfLogger.dispose0();
        }
    }

    private void dispose0() {
        if (this.objLock != null) {
            this.blnIsRunning = false;
            this.objLock.lo_notify();
            this.objLock.dispose();
        }
    }

    public static final void init(Configuration cnfConfig, LogContext logContext) {
        if (clfLogger != null) {
            CLF_Logger.dispose();
            clfLogger = null;
        }
        clfLogger = new CLF_Logger(cnfConfig, logContext);
    }

    private void init0() {
        this.vecQueue = new Vector(50, 5);
        this.objLock = new LockObject();
        this.thrdLogging = new Thread((Runnable)this, "CLF_Logger");
        this.thrdLogging.start();
        LF = System.getProperty("line.separator");
        this.sdf = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
        this.datBuffer = new Date(TimeFactory.getTime());
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.blnIsRunning = true;
        this.logContext.write("# Combined Log Format logger started");
        while (this.blnIsRunning) {
            if (this.blnIsRunning && this.vecQueue.size() == 0) {
                this.objLock.lo_wait();
            }
            if (this.blnIsRunning) ** GOTO lbl15
            break;
lbl-1000:
            // 1 sources

            {
                ld = (LogData)this.vecQueue.elementAt(0);
                try {
                    this.writeInternal(ld);
                }
                catch (IOException e) {
                    this.logContext.write("? Error " + e.toString());
                }
                this.vecQueue.removeElementAt(0);
lbl15:
                // 2 sources

                ** while (this.vecQueue.size() > 0)
            }
lbl16:
            // 1 sources

        }
    }

    public static final void write(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (clfLogger == null) {
            throw new RuntimeException("CLF_Logger not initialized");
        }
        clfLogger.write0(httpREQ, imd, httpRES);
    }

    private void write0(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (this.objLock != null && this.blnIsRunning) {
            LogData ld = new LogData(this);
            ld.httpREQ = httpREQ;
            ld.imd = imd;
            ld.httpRES = httpRES;
            this.vecQueue.addElement(ld);
            this.objLock.lo_notify();
        }
    }

    private void writeInternal(LogData ld) throws IOException {
        if (!ld.imd.strLOG_PATH.endsWith(File.separator)) {
            ld.imd.strLOG_PATH = String.valueOf(ld.imd.strLOG_PATH) + File.separator;
        }
        File flLogDir = new File(ld.imd.strLOG_PATH);
        flLogDir.mkdirs();
        String strLogFile = String.valueOf(ld.imd.strLOG_PATH) + ld.imd.strLOG_FILE;
        PrintWriter pw = new PrintWriter(new FileWriter(strLogFile, true));
        StringBuffer strb = new StringBuffer();
        if (ld.imd.blnLOG_RESOLVE_IP) {
            strb.append(ld.imd.inaLOG_INA.getHostName());
        } else {
            strb.append(ld.imd.inaLOG_INA.getHostAddress());
        }
        strb.append(" ");
        strb.append("-");
        strb.append(" ");
        if (ld.imd.strAuthUser.length() > 0) {
            strb.append(ld.imd.strAuthUser);
        } else {
            strb.append("-");
        }
        strb.append(" ");
        int intZone = this.sdf.getCalendar().get(15);
        int intDST = this.sdf.getCalendar().get(16);
        strb.append("[");
        this.datBuffer.setTime(TimeFactory.getTime() - (long)(intZone + intDST));
        strb.append(this.sdf.format(this.datBuffer));
        strb.append(" ");
        int diff = (intZone / 3600000 + intDST / 3600000) * 100;
        if (diff > 0) {
            strb.append("+");
            strb.append(HelperFormat.rset((long)diff, (int)4, (char)'0'));
        } else {
            strb.append("-");
            strb.append(HelperFormat.rset((long)(-diff), (int)4, (char)'0'));
        }
        strb.append("]");
        strb.append(" ");
        strb.append("\"");
        strb.append(String.valueOf(ld.httpREQ.strAction) + " " + ld.httpREQ.strURL + " " + ld.httpREQ.strProtocol);
        strb.append("\"");
        strb.append(" ");
        strb.append(ld.httpRES.intStatusCode);
        strb.append(" ");
        if (ld.httpRES.lngTransferredBytes > -1L) {
            strb.append(ld.httpRES.lngTransferredBytes);
        } else {
            strb.append("-");
        }
        if (ld.imd.blnLOG_COMBINED) {
            strb.append(" ");
            if (ld.httpREQ.strReferer.length() > 0) {
                strb.append("\"");
                strb.append(ld.httpREQ.strReferer);
                strb.append("\"");
            } else {
                strb.append("-");
            }
            strb.append(" ");
            strb.append("\"");
            strb.append(ld.httpREQ.strUserAgent);
            strb.append("\"");
        }
        pw.println(strb.toString());
        pw.flush();
        pw.close();
    }

    class LogData {
        /* synthetic */ CLF_Logger this$0;
        IntermediateModuleData imd = null;
        Http_Request httpREQ = null;
        Http_Response httpRES = null;

        LogData(CLF_Logger this$0) {
            this.this$0 = this$0;
        }
    }
}

