/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.response;

import de.zwanzigeins.util.TimeFactory;
import java.io.OutputStream;
import java.util.Vector;
import net.zerotoaster.httpd.util.Helper;

public class Http_Response
implements Cloneable {
    public long lngRequestFinished = 0L;
    public OutputStream osResponse = null;
    public String strLocation;
    private Vector vecAddHeader = new Vector();
    public String strProtocol;
    public int intStatusCode;
    public String strStatusCode;
    public String strDate;
    public String strServer;
    public String strConnection;
    public String strContentType;
    public String strContentEncoding;
    public String strVary;
    public long lngContentLength;
    public long lngLastModified;
    public long lngTransferredBytes;
    public String strWWWAuthenticate_Method;
    public String strWWWAuthenticate_Space;

    public Http_Response() {
        this.init();
    }

    public void addHeader(String strKey, String strData) {
        this.vecAddHeader.addElement(String.valueOf(strKey) + ": " + strData);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String[] getHeader() {
        Vector<String> vecRes = new Vector<String>(25, 5);
        vecRes.addElement(String.valueOf(this.strProtocol) + " " + this.intStatusCode + " " + this.strStatusCode + "\r\n");
        vecRes.addElement("Date: " + this.strDate + "\r\n");
        vecRes.addElement("Server: " + this.strServer + "\r\n");
        vecRes.addElement("Connection: " + this.strConnection + "\r\n");
        if (this.strContentType.length() != 0) {
            vecRes.addElement("Content-Type: " + this.strContentType + "\r\n");
        }
        if (this.strContentEncoding.length() != 0) {
            vecRes.addElement("Content-Encoding: " + this.strContentEncoding + "\r\n");
        }
        if (this.strVary.length() != 0) {
            vecRes.addElement("Vary: " + this.strVary + "\r\n");
        }
        if (this.lngContentLength != -1L) {
            vecRes.addElement("Content-Length: " + this.lngContentLength + "\r\n");
        }
        if (this.strLocation.length() != 0) {
            vecRes.addElement("Location: " + this.strLocation + "\r\n");
        }
        if (this.lngLastModified != -1L) {
            vecRes.addElement("Last-Modified: " + Helper.toHTTPDate(this.lngLastModified) + "\r\n");
        }
        if (this.strWWWAuthenticate_Method.length() != 0 && this.strWWWAuthenticate_Space.length() != 0) {
            vecRes.addElement("WWW-authenticate: " + this.strWWWAuthenticate_Method + " realm=\"" + this.strWWWAuthenticate_Space + "\"" + "\r\n");
        }
        int i = 0;
        while (i < this.vecAddHeader.size()) {
            String s = (String)this.vecAddHeader.elementAt(i);
            vecRes.addElement(String.valueOf(s.trim()) + "\r\n");
            ++i;
        }
        vecRes.addElement("\r\n");
        Object[] s = new String[vecRes.size()];
        vecRes.copyInto(s);
        return s;
    }

    public void init() {
        this.strLocation = "";
        this.lngRequestFinished = TimeFactory.getTime();
        this.vecAddHeader.removeAllElements();
        this.strProtocol = "HTTP/1.1";
        this.intStatusCode = 0;
        this.strStatusCode = "";
        this.strDate = Helper.toHTTPDate(TimeFactory.getTime());
        this.strServer = "ZeroToaster::HTTPD 1.30";
        this.strConnection = "close";
        this.strContentType = "";
        this.strContentEncoding = "";
        this.strVary = "";
        this.lngContentLength = -1L;
        this.lngLastModified = -1L;
        this.lngTransferredBytes = -1L;
        this.strWWWAuthenticate_Method = "";
        this.strWWWAuthenticate_Space = "";
    }
}

