/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.request;

import de.zwanzigeins.io.CRLFInputStream;
import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.Encoding;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.httpd.request.QualityComparator;
import net.zerotoaster.httpd.request.QualityRanking;
import net.zerotoaster.httpd.util.Helper;

public class Http_Request
implements Cloneable {
    public long lngRequestStarted = 0L;
    private int intLines;
    private Hashtable hshHeader;
    private Vector vecHeader;
    public CRLFInputStream crlfisRequest;
    public String strURLAbsolute;
    public String strAction;
    public String strURL;
    public String strQuery;
    public String strProtocol;
    public String strHost;
    public String strVHost;
    public String strUserAgent;
    public String strReferer;
    public String strConnection;
    public long lngIfModifiedSince;
    public QualityRanking[] qrAccept;
    public QualityRanking[] qrAccept_Language;
    public QualityRanking[] qrAccept_Encoding;
    public QualityRanking[] qrAccept_Charset;
    public long lngContentLength;
    public String strCookies;
    public String strContentType;
    public String strAuthorization_User;
    public String strAuthorization_Pass;

    public Http_Request() {
        this.init();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String[] getHeaderAsArray() {
        Object[] s = new String[this.vecHeader.size()];
        this.vecHeader.copyInto(s);
        return s;
    }

    public Hashtable getHeaderAsHashtable() {
        return (Hashtable)this.hshHeader.clone();
    }

    public String getHeaderElement(String strKey) {
        try {
            return (String)this.hshHeader.get(strKey);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void init() {
        if (this.crlfisRequest != null) {
            this.crlfisRequest.resetBytesRead();
        }
        this.lngRequestStarted = TimeFactory.getTime();
        this.intLines = 0;
        this.hshHeader = new Hashtable();
        this.vecHeader = new Vector();
        this.strURLAbsolute = "";
        this.strAction = "GET";
        this.strURL = "/";
        this.strQuery = "";
        this.strProtocol = "HTTP/1.1";
        this.strHost = "";
        this.strUserAgent = "";
        this.strReferer = "";
        this.strConnection = "";
        this.lngIfModifiedSince = -1L;
        this.qrAccept = new QualityRanking[0];
        this.qrAccept_Language = new QualityRanking[0];
        this.qrAccept_Encoding = new QualityRanking[0];
        this.qrAccept_Charset = new QualityRanking[0];
        this.lngContentLength = 0L;
        this.strCookies = "";
        this.strContentType = "";
        this.strAuthorization_User = "";
        this.strAuthorization_Pass = "";
    }

    public boolean loadHeader(LogContext logContext) {
        int intLinesRead = 0;
        while (true) {
            String strLine = null;
            try {
                strLine = this.crlfisRequest.readCRLFLine();
            }
            catch (IOException iOException) {
                return false;
            }
            ++intLinesRead;
            if (logContext != null) {
                logContext.write("H I:" + strLine);
            }
            if (strLine.length() == 0) break;
            this.parseHeaderLine(strLine);
        }
        return intLinesRead > 0;
    }

    private void parseAuth(String string) {
        int pp = string.indexOf(" ");
        if (pp == -1) {
            return;
        }
        String strMethod = string.substring(0, pp).trim();
        String strAuth = string.substring(pp + 1).trim();
        if (strMethod.equalsIgnoreCase("Basic")) {
            Encoding enc = Encoding.createEncodingInstance((String)"base64");
            strAuth = enc.decodeString(strAuth);
            pp = strAuth.indexOf(":");
            if (pp == -1) {
                return;
            }
            this.strAuthorization_User = strAuth.substring(0, pp).trim();
            this.strAuthorization_Pass = strAuth.substring(pp + 1).trim();
            return;
        }
    }

    private String parseCookie(String string) {
        String strArg;
        Hashtable<String, String> hsh = new Hashtable<String, String>();
        if (!string.endsWith(";")) {
            strArg = String.valueOf(string) + ";";
        }
        StringTokenizer strt = new StringTokenizer(strArg, ";");
        while (strt.hasMoreTokens()) {
            String strKey = strt.nextToken().trim();
            String strData = "";
            int pp = strKey.indexOf("=");
            if (pp == -1) {
                hsh.remove(strKey);
                continue;
            }
            strData = strKey.substring(pp + 1).trim();
            strKey = strKey.substring(0, pp).trim();
            if (strData.length() == 0) {
                hsh.remove(strKey);
                continue;
            }
            hsh.put(strKey, strData);
        }
        StringBuffer strb = new StringBuffer();
        Enumeration e = hsh.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            String strData = (String)hsh.get(strKey);
            if (strData == null) {
                strData = "";
            }
            strb.append(strKey);
            strb.append("=");
            strb.append(strData);
            strb.append("; ");
        }
        return strb.toString();
    }

    private void parseHeaderLine(String strLine) {
        this.vecHeader.addElement(String.valueOf(strLine) + "\r\n");
        ++this.intLines;
        int pp = strLine.indexOf(":");
        String strCmd = "";
        String strArg = "";
        double dblArg = 0.0;
        if (pp == -1) {
            strCmd = strLine.trim().toLowerCase();
        } else {
            strCmd = strLine.substring(0, pp).trim().toLowerCase();
            strArg = strLine.substring(pp + 1).trim();
        }
        try {
            dblArg = Double.valueOf(strArg);
        }
        catch (NumberFormatException numberFormatException) {}
        if (this.intLines == 1) {
            StringTokenizer strt = new StringTokenizer(strLine, " ");
            if (strt.hasMoreTokens()) {
                this.strAction = strt.nextToken().toUpperCase();
            }
            if (strt.hasMoreTokens()) {
                this.strURL = strt.nextToken();
            }
            if (strt.hasMoreTokens()) {
                this.strProtocol = strt.nextToken().toUpperCase();
            }
            this.parseQuery();
            return;
        }
        this.hshHeader.put(strCmd, strArg);
        if (strCmd.equals("host")) {
            this.strHost = strArg;
            pp = strArg.indexOf(":");
            this.strVHost = pp == -1 ? strArg : strArg.substring(0, pp);
            return;
        }
        if (strCmd.equals("user-agent")) {
            this.strUserAgent = strArg;
            return;
        }
        if (strCmd.equals("referer")) {
            this.strReferer = strArg;
            return;
        }
        if (strCmd.equals("connection")) {
            this.strConnection = strArg;
            return;
        }
        if (strCmd.equals("accept")) {
            this.qrAccept = this.parseQR(strArg);
            return;
        }
        if (strCmd.equals("accept-language")) {
            this.qrAccept_Language = this.parseQR(strArg);
            return;
        }
        if (strCmd.equals("accept-encoding")) {
            this.qrAccept_Encoding = this.parseQR(strArg);
            return;
        }
        if (strCmd.equals("accept-charset")) {
            this.qrAccept_Charset = this.parseQR(strArg);
            return;
        }
        if (strCmd.equals("if-modified-since")) {
            this.lngIfModifiedSince = Helper.fromHTTPDate(strArg);
        }
        if (strCmd.equals("content-length")) {
            this.lngContentLength = (long)dblArg;
        }
        if (strCmd.equals("cookie")) {
            this.strCookies = this.parseCookie(strArg);
        }
        if (strCmd.equals("content-type")) {
            this.strContentType = strArg;
        }
        if (strCmd.equals("authorization")) {
            this.parseAuth(strArg);
        }
    }

    public QualityRanking[] parseQR(String str) {
        if (str.length() == 0) {
            return new QualityRanking[0];
        }
        Vector<QualityRanking> v = new Vector<QualityRanking>(5, 1);
        StringTokenizer strt1 = new StringTokenizer(str, ",");
        while (strt1.hasMoreTokens()) {
            QualityRanking q = new QualityRanking();
            String strToken = String.valueOf(strt1.nextToken().trim()) + ";";
            StringTokenizer strt2 = new StringTokenizer(strToken, ";");
            q.strToken = strt2.nextToken().toLowerCase();
            while (strt2.hasMoreTokens()) {
                String strParam = strt2.nextToken();
                if (!strParam.startsWith("q=")) continue;
                strParam = strParam.substring("q=".length()).trim();
                try {
                    q.dblRank = Double.valueOf(strParam);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            v.addElement(q);
        }
        HelperSort.quick(v, (Comparator)new QualityComparator());
        Object[] qr = new QualityRanking[v.size()];
        v.copyInto(qr);
        return qr;
    }

    private void parseQuery() {
        int pp = this.strURL.indexOf("?");
        if (pp == -1) {
            return;
        }
        this.strQuery = this.strURL.substring(pp + 1);
        this.strURL = this.strURL.substring(0, pp);
    }

    public String qrtoString(QualityRanking[] qr) {
        if (qr == null) {
            return "<not assigned>";
        }
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < qr.length) {
            strb.append(qr[i].toString());
            strb.append(", ");
            ++i;
        }
        if (strb.length() > 2) {
            strb.setLength(strb.length() - 2);
        }
        return strb.toString();
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("Action    : " + this.strAction + "\r\n");
        strb.append("URL       : " + this.strURL + "\r\n");
        strb.append("Protocol  : " + this.strProtocol + "\r\n");
        strb.append("Host      : " + this.strHost + "\r\n");
        strb.append("V-Host    : " + this.strVHost + "\r\n");
        strb.append("User-Agent: " + this.strUserAgent + "\r\n");
        strb.append("Accept         : " + this.qrtoString(this.qrAccept) + "\r\n");
        strb.append("Accept-Language: " + this.qrtoString(this.qrAccept_Language) + "\r\n");
        strb.append("Accept-Encoding: " + this.qrtoString(this.qrAccept_Encoding) + "\r\n");
        strb.append("Accept-Charset : " + this.qrtoString(this.qrAccept_Charset) + "\r\n");
        return strb.toString();
    }
}

