/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.LogContext;
import java.util.StringTokenizer;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;

public class Mod_URL_Transform
extends Mod_Base {
    private static final int SEARCHMODE_START = 1;
    private static final int SEARCHMODE_SOMEWHERE = 2;
    private static final int SEARCHMODE_END = 3;
    private static final int REPLACEMODE_REPLACE = 1;
    private static final int REPLACEMODE_ABSOLUTE = 2;
    private static final int REPLACEMODE_REDIRECT = 3;

    public Mod_URL_Transform(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    private boolean process(int intSearchMode, int intReplaceMode, String strSearch, String strReplace, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        String strCmp = httpREQ.strURL.toLowerCase();
        int pp = strCmp.indexOf(strSearch);
        if (pp == -1) {
            return true;
        }
        boolean blnFound = false;
        switch (intSearchMode) {
            case 1: {
                blnFound = pp == 0;
                break;
            }
            case 2: {
                blnFound = true;
                break;
            }
            case 3: {
                blnFound = pp == strCmp.length() - strSearch.length();
                break;
            }
            default: {
                return true;
            }
        }
        if (!blnFound) {
            return true;
        }
        switch (intReplaceMode) {
            case 1: {
                httpREQ.strURL = String.valueOf(httpREQ.strURL.substring(0, pp)) + strReplace + httpREQ.strURL.substring(pp + strSearch.length());
                break;
            }
            case 2: {
                httpREQ.strURLAbsolute = String.valueOf(strReplace) + httpREQ.strURL.substring(pp + strSearch.length());
                break;
            }
            case 3: {
                httpRES.intStatusCode = 302;
                httpRES.strStatusCode = "Redirected";
                httpRES.strLocation = strReplace;
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        String[] strRules = imd.iniVHOST.getPropertiesString(this.MOD_NAME, "alias", new String[0]);
        if (strRules.length == 0) {
            return false;
        }
        int i = 0;
        while (i < strRules.length) {
            StringTokenizer strt = new StringTokenizer(strRules[i], ",");
            if (strt.hasMoreTokens()) {
                int intSearchMode = 0;
                String str = strt.nextToken().trim().toLowerCase();
                if (str.equalsIgnoreCase("start")) {
                    intSearchMode = 1;
                }
                if (str.equalsIgnoreCase("somewhere")) {
                    intSearchMode = 2;
                }
                if (str.equalsIgnoreCase("end")) {
                    intSearchMode = 3;
                }
                if (strt.hasMoreTokens()) {
                    int intReplaceMode = 0;
                    str = strt.nextToken().trim().toLowerCase();
                    if (str.equalsIgnoreCase("replace")) {
                        intReplaceMode = 1;
                    }
                    if (str.equalsIgnoreCase("absolute")) {
                        intReplaceMode = 2;
                    }
                    if (str.equalsIgnoreCase("redirect")) {
                        intReplaceMode = 3;
                    }
                    if (strt.hasMoreTokens()) {
                        String strReplace;
                        String strSearch = strt.nextToken().trim().toLowerCase();
                        if (strt.hasMoreTokens() && !this.process(intSearchMode, intReplaceMode, strSearch, strReplace = strt.nextToken().trim(), httpREQ, imd, httpRES)) break;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }
}

