/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.GlobalStatistics_Record;
import net.zerotoaster.httpd.util.Helper;
import net.zerotoaster.httpd.util.Statistics;
import net.zerotoaster.httpd.util.Statistics_Record;

public class Mod_Statistics
extends Mod_Base {
    private static Hashtable hshVHosts = new Hashtable();
    private static long lngCPLastSaved = 0L;
    private static Configuration cnfStatic = null;

    public Mod_Statistics(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
        cnfStatic = cnfConfig;
    }

    public static final synchronized void dumpCheckpoints(long lngSaveInterval, LogContext logContext) {
        String strCPLastSaved;
        boolean blnDateChange;
        if (cnfStatic == null) {
            return;
        }
        if (Mod_Statistics.cnfStatic.blnEmbeddedMode) {
            return;
        }
        long lngTime = TimeFactory.getTime();
        if (lngCPLastSaved == 0L) {
            lngCPLastSaved = lngTime;
            return;
        }
        String strCurrentCP_File = HelperDT.getYYYMMDD((Date)new Date(lngTime));
        boolean bl = blnDateChange = !strCurrentCP_File.equals(strCPLastSaved = HelperDT.getYYYMMDD((Date)new Date(lngCPLastSaved)));
        if (!(lngTime - lngCPLastSaved >= lngSaveInterval && lngSaveInterval != 0L || blnDateChange)) {
            return;
        }
        lngCPLastSaved = lngTime;
        PrintWriter pw = null;
        Statistics[] stats = Mod_Statistics.getStatistics();
        logContext.write("D Dumping statistic checkpoints, " + stats.length + " hosts");
        int i = 0;
        while (i < stats.length) {
            Object var11_9;
            try {
                try {
                    Statistics sr = stats[i];
                    new File(sr.getCheckpointPath()).mkdirs();
                    pw = new PrintWriter(new FileWriter(new File(sr.getCheckpointPath(), String.valueOf(strCPLastSaved) + ".chk")));
                    sr.export_binary(pw);
                    Helper.close(pw);
                    pw = new PrintWriter(new FileWriter(new File(sr.getCheckpointPath(), String.valueOf(strCPLastSaved) + ".txt")));
                    sr.export_text(pw);
                    if (blnDateChange) {
                        sr.reset();
                    }
                }
                catch (Throwable t) {
                    logContext.write("? Error dumping checkpoint " + strCPLastSaved, t);
                }
            }
            catch (Throwable throwable) {
                var11_9 = null;
                Helper.close(pw);
                throw throwable;
            }
            var11_9 = null;
            Helper.close(pw);
            ++i;
        }
    }

    private final Statistics getStatisticRecord(String strKey, IntermediateModuleData imd) {
        String strCP_File;
        File flCP;
        Statistics sr = (Statistics)hshVHosts.get(strKey);
        if (sr != null) {
            return sr;
        }
        String strCP_Dir = null;
        if (strKey.equals("@globalstatistics@")) {
            strCP_Dir = Helper.pathFixup(this.cnfConfig.strServerCheckpointDir, File.separator);
            sr = new GlobalStatistics_Record();
        }
        if (strCP_Dir == null) {
            strCP_Dir = imd.iniVHOST.getPropertyString(this.MOD_NAME, "checkpoint_dir", "statistics");
            strCP_Dir = Helper.pathFixup(String.valueOf(imd.strConfigDir) + File.separator + strCP_Dir, File.separator);
            sr = new Statistics_Record();
        }
        if ((flCP = new File(strCP_Dir, strCP_File = String.valueOf(HelperDT.getYYYMMDD((Date)new Date(TimeFactory.getTime()))) + ".chk")).exists() && flCP.length() > 1L) {
            BufferedReader br = null;
            try {
                try {
                    br = new BufferedReader(new FileReader(flCP));
                    sr.import_binary(br);
                }
                catch (Throwable e) {
                    this.logContext.write("? Error loading checkpointfile " + flCP.getPath(), e);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                Helper.close(br);
                throw throwable;
            }
            Object var8_11 = null;
            Helper.close(br);
        }
        sr.setCheckpointPath(strCP_Dir);
        hshVHosts.put(strKey, sr);
        return sr;
    }

    public static final Statistics[] getStatistics() {
        Statistics[] stats = new Statistics[hshVHosts.size()];
        int i = 0;
        Enumeration e = hshVHosts.elements();
        while (e.hasMoreElements()) {
            stats[i++] = (Statistics)e.nextElement();
        }
        return stats;
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    public void statAdd(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!imd.iniVHOST.getPropertyBoolean(this.MOD_NAME, "create_statistics", true)) {
            return;
        }
        this.getStatisticRecord(imd.iniVHOST.getFileName(), imd).addResponse(httpREQ, imd, httpRES);
        this.getStatisticRecord("@globalstatistics@", null).addResponse(httpREQ, imd, httpRES);
    }
}

