/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.io.DumbByteArrayOutputStream;
import de.zwanzigeins.util.LogContext;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.zip.GZIPOutputStream;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_File_Response;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_File_Response_GZIP
extends Mod_File_Response {
    public Mod_File_Response_GZIP(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        Object fis;
        block21: {
            boolean bl;
            block20: {
                boolean bl2;
                block19: {
                    block18: {
                        if (this.cnfConfig.blnEmbeddedMode) {
                            return false;
                        }
                        if (httpRES.strContentType.length() == 0) {
                            httpRES.strContentType = Helper.getMimeType(imd);
                        }
                        File fl = new File(imd.strFileToServe);
                        httpRES.lngLastModified = fl.lastModified() / 1000L * 1000L;
                        if (super.sendNotModified(httpREQ, imd, httpRES)) {
                            return true;
                        }
                        boolean blnUseGZIP = false;
                        int i = 0;
                        while (i < httpREQ.qrAccept_Encoding.length) {
                            String strToken = httpREQ.qrAccept_Encoding[i].strToken;
                            if (strToken.indexOf("gzip") != -1) {
                                blnUseGZIP = true;
                                break;
                            }
                            ++i;
                        }
                        if (!blnUseGZIP) {
                            return false;
                        }
                        int intCMPSZ_min = imd.iniVHOST.getPropertyInt(this.MOD_NAME, "minimum_size", 1024);
                        int intCMPSZ_mem = imd.iniVHOST.getPropertyInt(this.MOD_NAME, "maximum_mem_size", 5000);
                        int intCMPSZ_disk = imd.iniVHOST.getPropertyInt(this.MOD_NAME, "maximum_disk_size", 100000);
                        long lngFileSize = fl.length();
                        if (lngFileSize < (long)intCMPSZ_min) {
                            return false;
                        }
                        if (lngFileSize > (long)intCMPSZ_disk) {
                            return false;
                        }
                        boolean blnFoundMime = false;
                        String[] strMime = imd.iniVHOST.getPropertiesString(this.MOD_NAME, "compress", new String[0]);
                        int i2 = 0;
                        while (i2 < strMime.length) {
                            if (strMime[i2].equals(httpRES.strContentType)) {
                                blnFoundMime = true;
                                break;
                            }
                            ++i2;
                        }
                        if (!blnFoundMime) {
                            return false;
                        }
                        fis = null;
                        try {
                            try {
                                httpRES.lngLastModified = fl.lastModified() / 1000L * 1000L;
                                if (super.sendNotModified(httpREQ, imd, httpRES)) {
                                    Object var14_15 = null;
                                    break block18;
                                }
                                if (lngFileSize < (long)intCMPSZ_mem) {
                                    bl2 = this.sendFile_mem(fl, httpREQ, imd, httpRES);
                                    break block19;
                                }
                                bl = this.sendFile_disk(fl, httpREQ, imd, httpRES);
                                break block20;
                            }
                            catch (IOException iOException) {
                                break block21;
                            }
                            catch (Throwable e) {
                                this.logContext.write(e);
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var14_18 = null;
                            Helper.close(fis);
                            throw throwable;
                        }
                    }
                    Helper.close(fis);
                    return true;
                }
                Object var14_16 = null;
                Helper.close(fis);
                return bl2;
            }
            Object var14_17 = null;
            Helper.close(fis);
            return bl;
        }
        Object var14_19 = null;
        Helper.close(fis);
        return true;
    }

    protected boolean sendFile_disk(File flLocal, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        File flCache;
        block21: {
            if (this.cnfConfig.blnDebug) {
                this.logContext.write("D Sending GZIP/DSK " + flLocal.getPath());
            }
            String strCacheFileX = String.valueOf(imd.strTEMPFILES) + File.separator + "cached" + File.separator + httpREQ.strURL;
            if ((strCacheFileX = Helper.pathFixup(strCacheFileX, File.separator)).endsWith(File.separator)) {
                strCacheFileX = String.valueOf(strCacheFileX) + "#root";
            }
            flCache = new File(strCacheFileX);
            while (true) {
                boolean blnValid;
                long lngCacheFileSizeFromHeader = -1L;
                boolean bl = blnValid = flCache.exists() && flCache.length() > 32L;
                if (blnValid) {
                    RandomAccessFile rafCache = null;
                    try {
                        rafCache = new RandomAccessFile(flCache, "r");
                        lngCacheFileSizeFromHeader = rafCache.readLong();
                        blnValid &= rafCache.readLong() == flLocal.length();
                        blnValid &= rafCache.readLong() == flLocal.lastModified();
                    }
                    catch (IOException e) {
                        System.out.println(e);
                        blnValid = false;
                    }
                    Helper.close(rafCache);
                    if (lngCacheFileSizeFromHeader == -1L || lngCacheFileSizeFromHeader != flCache.length()) {
                        Helper.wait_ms(150L);
                        if (!this.cnfConfig.blnDebug) continue;
                        this.logContext.write("D GZIP/DSK Cache under rebuild");
                        continue;
                    }
                }
                if (blnValid) break block21;
                if (!Helper.fileLock(flCache.getPath())) {
                    if (this.cnfConfig.blnDebug) {
                        this.logContext.write("D Waiting for lock release on " + flCache.getPath());
                    }
                    Helper.wait_ms(100L);
                    continue;
                }
                int pp = flCache.getPath().lastIndexOf(File.separator);
                if (pp == -1) {
                    this.logContext.write("? No slash in cachefilepath: " + flCache.getPath());
                    return false;
                }
                String strCachePath = flCache.getPath().substring(0, pp);
                strCachePath = Helper.removeTrailingSlashes(strCachePath);
                new File(strCachePath).mkdirs();
                FileOutputStream fosCache = null;
                FileInputStream fisLocal = null;
                try {
                    if (this.cnfConfig.blnDebug) {
                        this.logContext.write("D Building cached file " + flCache.getPath());
                    }
                    byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
                    fisLocal = new FileInputStream(flLocal);
                    fosCache = new FileOutputStream(flCache);
                    DataOutputStream dos = new DataOutputStream(fosCache);
                    dos.writeLong(-1L);
                    dos.writeLong(-1L);
                    dos.writeLong(-1L);
                    GZIPOutputStream gzos = new GZIPOutputStream(fosCache);
                    int i = 0;
                    while ((i = fisLocal.read(buffer)) != -1) {
                        gzos.write(buffer, 0, i);
                    }
                    ((FilterOutputStream)gzos).flush();
                    gzos.close();
                    fisLocal.close();
                    RandomAccessFile rafCache = new RandomAccessFile(flCache, "rw");
                    rafCache.writeLong(flCache.length());
                    rafCache.writeLong(flLocal.length());
                    rafCache.writeLong(flLocal.lastModified());
                    rafCache.close();
                    if (!this.cnfConfig.blnDebug) break;
                    this.logContext.write("D Building cached file " + flCache.getPath());
                }
                catch (IOException e) {
                    if (this.cnfConfig.blnDebug) {
                        this.logContext.write("D Cannot create GZIP cache for " + flCache.getPath() + " " + e.toString());
                    }
                    Helper.close(fosCache);
                    Helper.close(fisLocal);
                    flCache.delete();
                    Helper.fileUnlock(flCache.getPath());
                    Helper.wait_ms(1500L);
                    continue;
                }
                break;
            }
            Helper.fileUnlock(flCache.getPath());
        }
        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
        RandomAccessFile rafCache = null;
        try {
            try {
                if (this.cnfConfig.blnDebug) {
                    this.logContext.write("D Sending cached file " + flCache.getPath());
                }
                rafCache = new RandomAccessFile(flCache, "r");
                rafCache.readLong();
                rafCache.readLong();
                rafCache.readLong();
                httpRES.intStatusCode = 200;
                httpRES.strStatusCode = "OK";
                httpRES.strContentEncoding = "gzip";
                httpRES.strVary = "*";
                httpRES.lngContentLength = rafCache.length() - rafCache.getFilePointer();
                this.writeResponseHeader(httpREQ, imd, httpRES);
                int i = 0;
                while ((i = rafCache.read(buffer)) != -1) {
                    httpRES.osResponse.write(buffer, 0, i);
                }
            }
            catch (IOException iOException) {
                Object var9_10 = null;
                Helper.close(rafCache);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            Helper.close(rafCache);
            throw throwable;
        }
        Object var9_12 = null;
        Helper.close(rafCache);
        return true;
    }

    protected boolean sendFile_mem(File fl, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        if (this.cnfConfig.blnDebug) {
            this.logContext.write("D Sending GZIP/MEM " + fl.getPath());
        }
        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
        DumbByteArrayOutputStream dbaos = new DumbByteArrayOutputStream((int)fl.length());
        GZIPOutputStream gzos = new GZIPOutputStream((OutputStream)dbaos);
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(fl);
                int i = 0;
                while ((i = fis.read(buffer)) != -1) {
                    gzos.write(buffer, 0, i);
                }
                ((FilterOutputStream)gzos).flush();
                gzos.close();
            }
            catch (IOException iOException) {
                Object var9_11 = null;
                Helper.close(fis);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            Helper.close(fis);
            throw throwable;
        }
        Object var9_13 = null;
        Helper.close(fis);
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        httpRES.strContentEncoding = "gzip";
        httpRES.strVary = "*";
        httpRES.lngContentLength = dbaos.size();
        this.writeResponseHeader(httpREQ, imd, httpRES);
        httpRES.osResponse.write(dbaos.toByteArray(), 0, dbaos.size());
        dbaos = null;
        return true;
    }
}

