/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_File_Response
extends Mod_Base {
    public Mod_File_Response(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (httpRES.strContentType.length() == 0) {
            httpRES.strContentType = Helper.getMimeType(imd);
        }
        try {
            if (!this.cnfConfig.blnEmbeddedMode) {
                File fl = new File(imd.strFileToServe);
                httpRES.lngLastModified = fl.lastModified() / 1000L * 1000L;
                if (this.sendNotModified(httpREQ, imd, httpRES)) {
                    return true;
                }
                return this.sendFile_disk(fl, httpREQ, imd, httpRES);
            }
            return this.sendFile_ressource(imd.strFileToServe, httpREQ, imd, httpRES);
        }
        catch (IOException iOException) {
        }
        catch (Throwable e) {
            this.logContext.write(e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendFile_disk(File fl, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        long lngFlush;
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        httpRES.lngContentLength = fl.length();
        this.writeResponseHeader(httpREQ, imd, httpRES);
        long lngNextFlush = lngFlush = (long)imd.iniVHOST.getPropertyInt(this.MOD_NAME, "flush_data", 8192);
        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(fl);
                int i = 0;
                while (true) {
                    if ((i = fis.read(buffer)) == -1) {
                        Object var11_11 = null;
                        break;
                    }
                    httpRES.osResponse.write(buffer, 0, i);
                    httpRES.lngTransferredBytes += (long)i;
                    if (lngFlush <= 0L || httpRES.lngTransferredBytes <= lngNextFlush) continue;
                    httpRES.osResponse.flush();
                    lngNextFlush += lngFlush;
                }
            }
            catch (IOException iOException) {
                Object var11_12 = null;
                Helper.close(fis);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            Helper.close(fis);
            throw throwable;
        }
        Helper.close(fis);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendFile_ressource(String strRessource, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        long lngFlush;
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        this.writeResponseHeader(httpREQ, imd, httpRES);
        long lngNextFlush = lngFlush = (long)imd.iniVHOST.getPropertyInt(this.MOD_NAME, "flush_data", 8192);
        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
        InputStream is = null;
        try {
            try {
                is = this.getClass().getResourceAsStream(strRessource);
                int i = 0;
                while (true) {
                    if ((i = is.read(buffer)) == -1) {
                        Object var11_11 = null;
                        break;
                    }
                    httpRES.osResponse.write(buffer, 0, i);
                    httpRES.lngTransferredBytes += (long)i;
                    if (lngFlush <= 0L || httpRES.lngTransferredBytes <= lngNextFlush) continue;
                    httpRES.osResponse.flush();
                    lngNextFlush += lngFlush;
                }
            }
            catch (IOException iOException) {
                Object var11_12 = null;
                Helper.close(is);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            Helper.close(is);
            throw throwable;
        }
        Helper.close(is);
        return true;
    }

    protected boolean sendNotModified(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (httpREQ.lngIfModifiedSince == -1L) {
            return false;
        }
        if (httpRES.lngLastModified <= httpREQ.lngIfModifiedSince) {
            httpRES.intStatusCode = 304;
            httpRES.strStatusCode = "Not modified";
            httpRES.strConnection = "close";
            httpRES.lngContentLength = -1L;
            httpRES.strContentType = "";
            httpRES.lngLastModified = -1L;
            this.writeResponseHeader(httpREQ, imd, httpRES);
            return true;
        }
        return false;
    }
}

