/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.mods.Mod_Content_Selection;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_Error_Response
extends Mod_Base {
    Http_Request httpREQ = null;

    public Mod_Error_Response(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    private String getDefaultMessage(int intCode) {
        switch (intCode) {
            case 302: {
                return "Redirected";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Ressource not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 499: {
                return "The requested URL is a directory, and directory accessing is disabled on this server.";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return "No message text available";
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (httpRES.intStatusCode == 0) {
            return false;
        }
        httpRES.strStatusCode = this.getDefaultMessage(httpRES.intStatusCode);
        if (httpRES.intStatusCode >= 300 && httpRES.intStatusCode <= 399) {
            httpRES.lngContentLength = -1L;
            httpRES.strContentType = "";
            httpRES.lngLastModified = -1L;
            this.writeResponseHeader(httpREQ, imd, httpRES);
            return true;
        }
        if (httpRES.intStatusCode >= 400 && httpRES.intStatusCode <= 499) {
            return this.processRES_File(httpREQ, imd, httpRES);
        }
        if (httpRES.intStatusCode >= 500 && httpRES.intStatusCode <= 599) {
            return this.processRES_File(httpREQ, imd, httpRES);
        }
        return false;
    }

    private boolean processRES_File(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        String strPath = null;
        Mod_Content_Selection mcTmp = new Mod_Content_Selection(this.cnfConfig, this.logContext);
        IntermediateModuleData imdTmp = (IntermediateModuleData)imd.clone();
        imdTmp.strFileToServe = "";
        strPath = imd.iniVHOST.getPropertyString(this.MOD_NAME, "error_pages_vhost", "error_pages");
        if (strPath.length() > 0) {
            if (!Helper.isAbsolutePath(strPath)) {
                strPath = Helper.pathFixup(String.valueOf(imd.strHTDOCS) + File.separator + strPath, File.separator);
            }
            strPath = Helper.pathFixup(String.valueOf(strPath) + File.separator, File.separator);
            imdTmp.strTriedRessources = new String[]{String.valueOf(strPath) + String.valueOf(httpRES.intStatusCode) + ".html"};
            mcTmp.processREQ(httpREQ, imdTmp, httpRES);
            if (imdTmp.strFileToServe.length() != 0) {
                this.sendFile(httpREQ, imdTmp, httpRES);
                return true;
            }
        }
        if ((strPath = imd.iniVHOST.getPropertyString(this.MOD_NAME, "error_pages_default", "error_pages")).length() > 0) {
            if (!Helper.isAbsolutePath(strPath)) {
                strPath = Helper.pathFixup(String.valueOf(imd.strZT_ROOT) + File.separator + strPath, File.separator);
            }
            strPath = Helper.pathFixup(String.valueOf(strPath) + File.separator, File.separator);
            imdTmp.strTriedRessources = new String[]{String.valueOf(strPath) + String.valueOf(httpRES.intStatusCode) + ".html"};
            mcTmp.processREQ(httpREQ, imdTmp, httpRES);
            if (imdTmp.strFileToServe.length() != 0) {
                this.sendFile(httpREQ, imdTmp, httpRES);
                return true;
            }
        }
        this.logContext.write("! Failed to find a error webpage for error " + String.valueOf(httpRES.intStatusCode) + ":" + "\r\n" + httpREQ.toString());
        StringBuffer strb = new StringBuffer();
        String[] strHeader = httpRES.getHeader();
        int i = 0;
        while (i < strHeader.length) {
            strb.append(strHeader[i]);
            ++i;
        }
        int ll = strb.length();
        strb.append("<html><head><title>Error</title></head>\r\n<body>\r\n<h2>");
        strb.append(httpRES.intStatusCode + " " + this.getDefaultMessage(httpRES.intStatusCode));
        strb.append("</h2>\r\n<!-- autogenerated by Mod_Error_Response -->\r\n</body></html>\r\n");
        try {
            httpRES.osResponse.write(strb.toString().getBytes());
            httpRES.osResponse.flush();
            httpRES.lngTransferredBytes = strb.length() - ll;
        }
        catch (IOException iOException) {
        }
        catch (Throwable t) {
            this.logContext.write(t);
        }
        return true;
    }

    private void sendFile(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        String strExt = "default";
        int pp = imd.strFileToServe.lastIndexOf(".");
        if (pp != -1) {
            strExt = imd.strFileToServe.substring(pp + 1).trim().toLowerCase();
        }
        httpRES.strContentType = imd.iniVHOST.getPropertyString("MIME", strExt);
        if (httpRES.strContentType.length() == 0) {
            httpRES.strContentType = imd.iniVHOST.getPropertyString("MIME", "default");
        }
        FileInputStream fis = null;
        try {
            try {
                File fl = new File(imd.strFileToServe);
                httpRES.lngLastModified = -1L;
                httpRES.lngContentLength = fl.length();
                this.writeResponseHeader(httpREQ, imd, httpRES);
                fis = new FileInputStream(imd.strFileToServe);
                byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
                int i = 0;
                while ((i = fis.read(buffer)) != -1) {
                    httpRES.osResponse.write(buffer, 0, i);
                    httpRES.lngTransferredBytes += (long)i;
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable e) {
                this.logContext.write(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            Helper.close(fis);
            throw throwable;
        }
        Object var7_13 = null;
        Helper.close(fis);
    }
}

