/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperHTML;
import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_Directory_Index
extends Mod_Base {
    public Mod_Directory_Index(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (this.cnfConfig.blnEmbeddedMode) {
            return false;
        }
        String strRequestPath = "";
        strRequestPath = httpREQ.strURLAbsolute.length() != 0 ? Helper.pathFixup(httpREQ.strURLAbsolute, File.separator) : Helper.pathFixup(String.valueOf(imd.strHTDOCS) + File.separator + httpREQ.strURL, File.separator);
        if (new File(strRequestPath).isDirectory()) {
            if (!httpREQ.strURL.endsWith("/") && httpREQ.strURLAbsolute.length() == 0) {
                httpRES.strLocation = "http://" + httpREQ.strHost + httpREQ.strURL + "/";
                httpRES.intStatusCode = 302;
                return true;
            }
            String[] strIndex = imd.iniVHOST.getPropertyStringAsArray(this.MOD_NAME, "index", new String[0]);
            if (strIndex.length == 0) {
                imd.blnIsDirRequest = true;
                return false;
            }
            imd.strTriedRessources = new String[strIndex.length];
            int i = 0;
            while (i < strIndex.length) {
                imd.strTriedRessources[i] = httpREQ.strURLAbsolute.length() == 0 ? Helper.pathFixup(String.valueOf(imd.strHTDOCS) + File.separator + httpREQ.strURL + strIndex[i], File.separator) : Helper.pathFixup(String.valueOf(httpREQ.strURLAbsolute) + File.separator + strIndex[i], File.separator);
                ++i;
            }
            return false;
        }
        imd.strTriedRessources = new String[]{strRequestPath};
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!imd.blnIsDirRequest) {
            return false;
        }
        if (!imd.iniVHOST.getPropertyBoolean(this.MOD_NAME, "enable_fallback", true)) {
            httpRES.intStatusCode = 499;
            return false;
        }
        NumberFormat fmtNumber = NumberFormat.getInstance();
        fmtNumber.setGroupingUsed(true);
        SimpleDateFormat fmtDate = new SimpleDateFormat("dd.MMM.yyyy");
        SimpleDateFormat fmtTime = new SimpleDateFormat("HH:mm:ss");
        httpRES.intStatusCode = 200;
        httpRES.strContentType = imd.iniVHOST.getPropertyString("MIME", "html");
        PrintWriter pw = new PrintWriter(httpRES.osResponse);
        String[] strHeader = httpRES.getHeader();
        int i = 0;
        while (i < strHeader.length) {
            pw.write(strHeader[i].toCharArray());
            ++i;
        }
        pw.println("<html><head><title>Index of " + httpREQ.strURL + "</title></head>");
        pw.println("<body>");
        pw.println("<h1>Index of <a href=\"" + httpREQ.strURL + "\">" + httpREQ.strURL + "</a></h1>");
        pw.println("<hr noshade=\"noshade\" size=\"1\">");
        pw.println("<a href=\"" + Helper.urlUp(httpREQ.strURL) + "\">Up to higher level directory</a>");
        pw.println("<table border=\"0\" cellpadding=\"0\" cellspacing=\"6\">");
        String[] strFiles = new File(imd.strFileToServe).list();
        int i2 = 0;
        while (i2 < strFiles.length) {
            File fl = new File(imd.strFileToServe, strFiles[i2]);
            pw.println("<tr>");
            if (fl.isFile()) {
                pw.println("<td align=\"left\"><a href=\"" + Helper.toHexURL(String.valueOf(httpREQ.strURL) + strFiles[i2]) + "\">" + HelperHTML.toHTML((String)strFiles[i2]) + "</a></td>");
                pw.println("<td>(File)</td>");
            } else {
                pw.println("<td align=\"left\"><a href=\"" + Helper.toHexURL(String.valueOf(httpREQ.strURL) + strFiles[i2] + "/") + "\">" + HelperHTML.toHTML((String)strFiles[i2]) + "</a></td>");
                pw.println("<td>(Dir)</td>");
            }
            pw.println("<td align=\"right\">" + (fl.isFile() ? HelperFormat.formatMemoryString((long)fl.length()) : "") + "</td>");
            pw.println("<td align=\"left\">" + fmtDate.format(new Date(fl.lastModified())) + "</td>");
            pw.println("<td align=\"left\">" + fmtTime.format(new Date(fl.lastModified())) + "</td>");
            pw.println("</tr>");
            ++i2;
        }
        pw.println("</table>");
        pw.println("<hr noshade=\"noshade\" size=\"1\">");
        pw.println("<div align=right>ZeroToaster::HTTPD 1.30</div>");
        pw.println("</b></pre></body></html>");
        pw.flush();
        return true;
    }
}

