/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.io.CRLFInputStream;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.StrTool;
import de.zwanzigeins.util.TimeFactory;
import de.zwanzigeins.util.VectorString;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Alarm;
import net.zerotoaster.httpd.util.AlarmCallback;
import net.zerotoaster.httpd.util.Helper;

public class Mod_CGI
extends Mod_Base
implements AlarmCallback {
    private Process proc = null;
    private long lngProcStartTime = 0L;
    private boolean blnProcessKilled = false;
    protected Hashtable hshENV = null;

    public Mod_CGI(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    public void alarmCallback() {
        Process p = this.proc;
        if (p != null) {
            this.blnProcessKilled = true;
            p.destroy();
            this.logContext.write("? CGI Process time out");
        }
    }

    private void handlePOST(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        if (!httpREQ.strAction.equalsIgnoreCase("POST")) {
            return;
        }
        OutputStream osProc = this.proc.getOutputStream();
        long lngLen = httpREQ.lngContentLength;
        byte[] buf = new byte[Math.min(this.cnfConfig.intStreamBufferSize, (int)lngLen)];
        int i = 0;
        while (lngLen > 0L) {
            i = lngLen >= (long)buf.length ? httpREQ.crlfisRequest.read(buf, 0, buf.length) : httpREQ.crlfisRequest.read(buf, 0, (int)lngLen);
            if (i == -1) break;
            osProc.write(buf, 0, i);
            lngLen -= (long)i;
        }
        osProc.flush();
        osProc.close();
    }

    protected void handleStreamResponse(CRLFInputStream crlfisCGI, long l, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        httpRES.strConnection = "close";
        boolean blnIsFullHeader = false;
        int intLimit = 50;
        VectorString vecAddHeader = new VectorString(intLimit);
        int i = 0;
        while (i < intLimit) {
            String strLine = crlfisCGI.readCRLFLine();
            if (this.lngProcStartTime != 0L) {
                this.logContext.write("C CGI got response after " + (TimeFactory.getTime() - this.lngProcStartTime) + "ms");
                this.lngProcStartTime = 0L;
            }
            if (strLine == null || strLine.length() == 0) break;
            if (i == 0 && strLine.startsWith("HTTP")) {
                blnIsFullHeader = true;
            }
            if (blnIsFullHeader) {
                vecAddHeader.addElement(String.valueOf(strLine) + "\r\n");
            } else {
                int pp = strLine.indexOf(":");
                String strCmd = "";
                String strArg = "";
                if (pp == -1) {
                    strCmd = strLine.trim().toLowerCase();
                } else {
                    strCmd = strLine.substring(0, pp).trim().toLowerCase();
                    strArg = strLine.substring(pp + 1).trim();
                }
                if (strCmd.equals("status")) {
                    StringTokenizer strt = new StringTokenizer(strArg, " ");
                    httpRES.intStatusCode = Integer.parseInt(strt.nextToken());
                    httpRES.strStatusCode = "";
                    if (strt.hasMoreTokens()) {
                        httpRES.strStatusCode = strt.nextToken();
                    }
                } else if (strCmd.equals("location")) {
                    httpRES.strLocation = strArg;
                    if (httpRES.intStatusCode == 200) {
                        httpRES.intStatusCode = 302;
                        httpRES.strStatusCode = "Redirected";
                    }
                } else if (strCmd.equals("content-type")) {
                    httpRES.strContentType = strArg;
                } else if (strCmd.equals("content-length")) {
                    httpRES.lngContentLength = Long.parseLong(strArg);
                } else {
                    vecAddHeader.addElement(String.valueOf(strLine) + "\r\n");
                }
            }
            ++i;
        }
        if (!blnIsFullHeader) {
            String[] strHeader = httpRES.getHeader();
            int i2 = 0;
            while (i2 < strHeader.length - 1) {
                httpRES.osResponse.write(strHeader[i2].getBytes());
                this.logContext.write("H O-1:" + strHeader[i2]);
                ++i2;
            }
        }
        i = 0;
        while (i < vecAddHeader.size()) {
            httpRES.osResponse.write(vecAddHeader.elementAt(i).getBytes());
            this.logContext.write("H O-2:" + vecAddHeader.elementAt(i));
            ++i;
        }
        httpRES.osResponse.write("\r\n".getBytes());
        this.logContext.write("H O:");
        long lngBytes = crlfisCGI.getBytesRead();
        long lngDataLength = l - crlfisCGI.getBytesRead();
        if (lngDataLength < 0L) {
            lngDataLength = Integer.MAX_VALUE;
        }
        byte[] buffer = new byte[Math.min(this.cnfConfig.intStreamBufferSize, (int)lngDataLength)];
        int i3 = 0;
        this.logContext.write("C Reading CGI output. Bufsize=" + buffer.length);
        while (lngDataLength > 0L) {
            i3 = lngDataLength >= (long)buffer.length ? crlfisCGI.read(buffer, 0, buffer.length) : crlfisCGI.read(buffer, 0, (int)lngDataLength);
            if (i3 == -1) break;
            httpRES.osResponse.write(buffer, 0, i3);
            lngDataLength -= (long)i3;
            lngBytes += (long)i3;
        }
        this.logContext.write("C Got " + lngBytes + " bytes");
        httpRES.osResponse.flush();
        httpRES.osResponse.close();
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        int pp;
        if (!imd.iniVHOST.getPropertyBoolean(this.MOD_NAME, "cgi_allowed", true)) {
            return false;
        }
        String strMASK = "";
        String[] strMasks = imd.iniVHOST.getPropertiesString(this.MOD_NAME, "cgi_handler", new String[0]);
        int intIdx = -1;
        String strURL = httpREQ.strURL;
        int i = 0;
        while (i < strMasks.length) {
            pp = strMasks[i].indexOf(",");
            if (pp != -1 && Mod_CGI.url_match(strURL, strMASK = strMasks[i].substring(0, pp))) {
                intIdx = i;
                break;
            }
            ++i;
        }
        if (intIdx == -1) {
            return false;
        }
        this.blnIsRequestForUs = true;
        StringTokenizer strt = new StringTokenizer(strMasks[intIdx], ",");
        strMASK = strt.nextToken();
        if (!strt.hasMoreTokens()) {
            return false;
        }
        imd.strFileToServe = strt.nextToken();
        imd.strCgiScript = httpREQ.strURL;
        pp = strMASK.indexOf("*");
        if (pp != -1) {
            imd.strCgiScript = httpREQ.strURL.substring(pp);
        }
        if ((pp = imd.strCgiScript.indexOf("/", 1)) != -1) {
            imd.strCgiExtraPath = imd.strCgiScript.substring(pp);
            imd.strCgiScript = imd.strCgiScript.substring(0, pp);
        }
        this.hshENV = Mod_Base.createEnvironment(httpREQ, imd, httpRES);
        Enumeration e = this.hshENV.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            String strData = (String)this.hshENV.get(strKey);
            imd.strFileToServe = StrTool.replaceMore((String)imd.strFileToServe, (String)("%" + strKey + "%"), (String)strData);
        }
        imd.strFileToServe = Helper.pathFixup(imd.strFileToServe, "");
        return true;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!this.blnIsRequestForUs) {
            return false;
        }
        this.blnProcessKilled = false;
        long lngCgiTimeout = imd.iniVHOST.getPropertyLong(this.MOD_NAME, "cgi_timeout", 30L);
        Alarm.register(this, lngCgiTimeout * 1000L, true);
        String strError = "";
        try {
            strError = "? Error starting process";
            this.startProcess(httpREQ, imd, httpRES);
            strError = "? Error processing POST";
            this.handlePOST(httpREQ, imd, httpRES);
            strError = "? Error getting CGI data";
            this.handleStreamResponse(new CRLFInputStream(this.proc.getInputStream()), -1L, httpREQ, imd, httpRES);
            Alarm.deregister(this);
            this.logContext.write("D CGI finished");
            this.proc = null;
        }
        catch (IOException e) {
            Alarm.deregister(this);
            if (this.proc != null) {
                this.proc.destroy();
            }
            this.proc = null;
            if (this.blnProcessKilled) {
                this.logContext.write("! CGI Timeout " + imd.strFileToServe);
                httpRES.intStatusCode = 408;
            } else {
                this.logContext.write(String.valueOf(strError) + "[" + imd.strFileToServe + "]: " + e.toString());
                httpRES.intStatusCode = 500;
            }
            return false;
        }
        return true;
    }

    private void startProcess(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        Hashtable hshEnv = Mod_Base.createEnvironment(httpREQ, imd, httpRES);
        String[] strEnv = new String[hshEnv.size()];
        int k = 0;
        Enumeration e = hshEnv.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            strEnv[k++] = String.valueOf(strKey) + "=" + (String)hshEnv.get(strKey);
        }
        this.logContext.write("C CGI Qry: " + httpREQ.strQuery);
        int i = 0;
        while (i < strEnv.length) {
            this.logContext.write("C CGI Env: " + strEnv[i]);
            ++i;
        }
        this.logContext.write("C CGI Starting " + imd.strFileToServe);
        this.lngProcStartTime = TimeFactory.getTime();
        this.proc = Runtime.getRuntime().exec(imd.strFileToServe, strEnv);
    }

    static final boolean url_match(String string, String string2) {
        if (string2.indexOf("*") != -1) {
            if (Helper.checkString(string, String.valueOf(string2) + "*")) {
                return true;
            }
        } else {
            String strMASK = Helper.pathFixup(String.valueOf(string2) + "/", "/");
            String strURL = Helper.pathFixup(String.valueOf(string) + "/", "/");
            if (strURL.startsWith(strMASK)) {
                return true;
            }
        }
        return false;
    }
}

