/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public abstract class Mod_Base {
    protected static final String CRLF = "\r\n";
    protected Configuration cnfConfig = null;
    protected LogContext logContext = null;
    protected String MOD_NAME = "you forgot to call super(....)";
    protected boolean blnIsRequestForUs = false;

    public Mod_Base(Configuration cnfConfig, LogContext logContext) {
        this.cnfConfig = cnfConfig;
        this.logContext = logContext;
        String s = this.getClass().getName();
        int pp = s.lastIndexOf(".");
        this.MOD_NAME = pp != -1 ? s.substring(pp + 1).toUpperCase() : s.toUpperCase();
    }

    protected static final Hashtable createEnvironment(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpR) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("SERVER_SOFTWARE", "ZeroToaster::HTTPD 1.30");
        h.put("SERVER_NAME", imd.strServerName);
        h.put("SERVER_PORT", String.valueOf(imd.intServerPort));
        h.put("SERVER_ROOT", new File("").getAbsolutePath());
        h.put("GATEWAY_INTERFACE", "CGI/1.1");
        h.put("SERVER_PROTOCOL", httpREQ.strProtocol);
        h.put("REQUEST_METHOD", httpREQ.strAction);
        h.put("REQUEST_URI", Helper.pathFixup(httpREQ.strURL, File.separator));
        h.put("PATH_INFO", imd.strCgiExtraPath);
        if (imd.strCgiScript.length() > 0) {
            h.put("SCRIPT_NAME", imd.strCgiScript);
            h.put("SCRIPT_FILENAME", Helper.pathFixup(String.valueOf(imd.strHTDOCS) + File.separator + imd.strCgiScript, File.separator));
        }
        h.put("DOCUMENT_ROOT", imd.strHTDOCS);
        if (httpREQ.strQuery.length() > 0) {
            h.put("QUERY_STRING", httpREQ.strQuery);
        }
        h.put("CONTENT_LENGTH", String.valueOf(httpREQ.lngContentLength));
        h.put("CONTENT_TYPE", httpREQ.strContentType);
        h.put("REMOTE_HOST", imd.inaLOG_INA.getHostName());
        h.put("REMOTE_ADDR", imd.inaLOG_INA.getHostAddress());
        h.put("HTTP_ACCEPT", httpREQ.qrtoString(httpREQ.qrAccept));
        h.put("HTTP_REFERER", httpREQ.strReferer);
        h.put("HTTP_COOKIE", httpREQ.strCookies);
        h.put("HTTP_USER_AGENT", httpREQ.strUserAgent);
        h.put("HTTP_HOST", httpREQ.strHost);
        h.put("HTTP_VHOST", httpREQ.strVHost);
        return h;
    }

    public abstract boolean processREQ(Http_Request var1, IntermediateModuleData var2, Http_Response var3);

    public abstract boolean processRES(Http_Request var1, IntermediateModuleData var2, Http_Response var3);

    public void reset() {
        this.blnIsRequestForUs = false;
    }

    public String toString() {
        return this.MOD_NAME;
    }

    protected boolean writeResponseHeader(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        try {
            String[] strHeader = httpRES.getHeader();
            int i = 0;
            while (i < strHeader.length) {
                httpRES.osResponse.write(strHeader[i].getBytes());
                this.logContext.write("H O:" + strHeader[i]);
                ++i;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

