/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.config;

import de.zwanzigeins.util.IniManager;
import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.StrTool;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.util.Helper;

public class VHost_Configuration {
    private Configuration cnfMaster = null;
    private LogContext logMaster = null;
    private Vector vecConfigFiles = null;
    private Hashtable hshVHosts = null;
    private int intCurrentDirDepth = 0;

    public VHost_Configuration(Configuration cnfMaster, LogContext logMaster) {
        this.cnfMaster = cnfMaster;
        this.logMaster = logMaster;
        this.init();
    }

    private final void find_configs_embedded(String string, String[] strConfigs) throws IOException {
        String strRoot = Helper.removeLeadingSlashes(string);
        strRoot = Helper.removeTrailingSlashes(strRoot);
        strRoot = Helper.pathFixup(strRoot, "/");
        strRoot = "/" + strRoot + "/";
        int j = 0;
        while (j < strConfigs.length) {
            String strFile = String.valueOf(strRoot) + strConfigs[j];
            InputStream is = this.getClass().getResourceAsStream(strFile);
            if (is != null) {
                if (!this.vecConfigFiles.contains(strFile)) {
                    this.vecConfigFiles.addElement(strFile);
                }
                Helper.close(is);
            }
            ++j;
        }
    }

    private final void find_configs_file(String string, String[] strConfigs) throws IOException {
        if (this.intCurrentDirDepth > this.cnfMaster.intVH_search_depth) {
            return;
        }
        ++this.intCurrentDirDepth;
        String strRoot = Helper.removeTrailingSlashes(string);
        File flRoot = new File(strRoot);
        String[] strFiles = flRoot.list();
        if (strFiles == null || strFiles.length == 0) {
            --this.intCurrentDirDepth;
            return;
        }
        int i = 0;
        while (i < strFiles.length) {
            File flTmp = new File(flRoot.getCanonicalPath(), strFiles[i]);
            if (flTmp.isDirectory()) {
                this.find_configs_file(flTmp.getCanonicalPath(), strConfigs);
            } else {
                int j = 0;
                while (j < strConfigs.length) {
                    String strFile;
                    if (StrTool.matches((String)strFiles[i], (String)strConfigs[j]) && !this.vecConfigFiles.contains(strFile = Helper.pathFixup(flTmp.getCanonicalPath(), File.separator))) {
                        this.vecConfigFiles.addElement(strFile);
                    }
                    ++j;
                }
            }
            ++i;
        }
        --this.intCurrentDirDepth;
    }

    public final String[] getAllHosts() {
        String[] s = new String[this.hshVHosts.size()];
        int i = 0;
        Enumeration e = this.hshVHosts.keys();
        while (e.hasMoreElements()) {
            s[i++] = (String)e.nextElement();
        }
        return s;
    }

    public final IniManager getIniManager(String strVHost) {
        IniManager ini = (IniManager)this.hshVHosts.get(strVHost.toLowerCase());
        if (ini == null) {
            ini = (IniManager)this.hshVHosts.get("@default@");
        }
        return ini;
    }

    private final void init() {
        this.hshVHosts = new Hashtable();
        this.vecConfigFiles = new Vector(10, 5);
        int i = 0;
        while (i < this.cnfMaster.strVH_vhost_root.length) {
            try {
                this.intCurrentDirDepth = 0;
                if (!this.cnfMaster.blnEmbeddedMode) {
                    this.find_configs_file(this.cnfMaster.strVH_vhost_root[i], this.cnfMaster.strVH_cnf_file);
                } else {
                    this.find_configs_embedded(this.cnfMaster.strVH_vhost_root[i], this.cnfMaster.strVH_cnf_file);
                }
            }
            catch (IOException e) {
                this.log("? " + e.toString());
            }
            ++i;
        }
        this.log("D Found " + this.vecConfigFiles.size() + " configuration files");
        i = 0;
        while (i < this.vecConfigFiles.size()) {
            String strConfig = (String)this.vecConfigFiles.elementAt(i);
            this.log("D Loading " + strConfig);
            IniManager ini = new IniManager(strConfig);
            if (!ini.hasLoaded()) {
                this.log("? Config file '" + strConfig + "' missing or empty, abort");
                throw new InitializationException();
            }
            String[] strServers = ini.getPropertiesString("VHOST", "server_name");
            if (strServers.length == 0) {
                this.log("? Config file '" + strConfig + "' doesn't contain any 'server_name' entry, ignored");
            } else {
                int j = 0;
                while (j < strServers.length) {
                    this.hshVHosts.put(strServers[j].toLowerCase(), ini);
                    ++j;
                }
            }
            ++i;
        }
        this.log("D Resolving 'extends' entries");
        Enumeration e = this.hshVHosts.elements();
        while (e.hasMoreElements()) {
            IniManager iniThis = (IniManager)e.nextElement();
            String[] strNames = iniThis.getPropertiesString("VHOST", "server_name");
            String strExtends = iniThis.getPropertyString("VHOST", "extends", "@default@");
            boolean blnDuplicate = false;
            int i2 = 0;
            while (i2 < strNames.length) {
                if (strNames[i2].equalsIgnoreCase(strExtends)) {
                    blnDuplicate = true;
                    break;
                }
                ++i2;
            }
            if (blnDuplicate) continue;
            IniManager iniMaster = (IniManager)this.hshVHosts.get(strExtends.toLowerCase());
            if (iniMaster == null) {
                this.log("? " + iniThis.getFileName() + " extends '" + strExtends + "' but cannot find a config which declares this - ignored");
                continue;
            }
            this.log("D " + iniThis.getFileName() + " extends " + iniMaster.getFileName());
            iniThis.setMaster(iniMaster);
        }
        if (!this.hshVHosts.containsKey("@default@")) {
            this.log("? VHost @default@ is not defined, abort");
            throw new InitializationException();
        }
        this.vecConfigFiles = null;
        this.log("# VHOST configuration loaded");
    }

    private final void log(String s) {
        if (this.logMaster != null) {
            this.logMaster.write(s);
        } else {
            System.out.println(">> " + s);
        }
    }

    public static void main(String[] args) {
        new VHost_Configuration(Configuration.getConfig(false), null);
    }

    public final void reload() {
        Hashtable hshOld = (Hashtable)this.hshVHosts.clone();
        try {
            this.init();
        }
        catch (InitializationException initializationException) {
            this.log("! Reverting to old configuration");
            this.hshVHosts = (Hashtable)hshOld.clone();
        }
    }
}

