/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.config;

import de.zwanzigeins.util.IniManager;
import java.util.TimeZone;

public class Configuration {
    private static Configuration cfg = null;
    private static IniManager iniMgr = null;
    public boolean blnEmbeddedMode = false;
    public String[] strVH_vhost_root = null;
    public String[] strVH_cnf_file = null;
    public int intVH_search_depth = 0;
    public int intHTTP_instances = 0;
    public boolean blnHTTP_roundrobin = false;
    public String strServer_Socket_listen_ip = "";
    public int intServer_Socket_listen_port = 0;
    public int intServer_Socket_backlog = 0;
    public long lngSocket_timeout = 0L;
    public long lngInstanceMaxWait = 0L;
    public int intStreamBufferSize = 0;
    public String strServer_admin_name = "";
    public String strServer_admin_mail = "";
    public boolean blnSimulateOverload = false;
    public boolean blnKeepAlive = false;
    public boolean blnLRWP_allowed = false;
    public String strLRWP_listen_ip = null;
    public int intLRWP_listen_port = -1;
    public long lngLRWP_client_timeout = 0L;
    public int intSemaphoreCheck = 0;
    public String strTimeZone = "";
    public long lngCheckpointSave = 0L;
    public String strServerCheckpointDir = null;
    public long lngStatusDump = 0L;
    public String strStatusExportFile = null;
    public String strStatusExportTo = null;
    public String strStatusExportSubject = null;
    public boolean blnDebug = false;
    public String strLogFile_Path = "";
    public String strLogFile_Praefix = "";
    public String strLogFile_Suffix = "";
    public String strLogFile_Options = "";
    public String strLogScrn_Options = "";
    public String strLogFile_DateFormat = "";
    public String strLogFile_TimeFormat = "";
    public String strLogFile_Yesterday = "";
    public int intLogFile_Keep = 0;
    public String[] strModules = null;

    private Configuration(boolean blnEmbedded) {
        this.init(blnEmbedded);
    }

    public static final void dispose() {
        cfg = null;
        iniMgr = null;
    }

    public static final Configuration getConfig(boolean blnEmbedded) {
        if (cfg == null) {
            cfg = new Configuration(blnEmbedded);
        }
        return cfg;
    }

    private final void init(boolean blnEmbedded) {
        iniMgr = new IniManager("zerotoaster.ini", blnEmbedded);
        String SECTION = "";
        this.blnEmbeddedMode = blnEmbedded;
        SECTION = "VHOSTS";
        this.strVH_vhost_root = iniMgr.getPropertiesString(SECTION, "vhost_root", new String[]{"www_root/"});
        this.strVH_cnf_file = iniMgr.getPropertiesString(SECTION, "cfg_file", new String[]{"vhost.cfg"});
        this.intVH_search_depth = iniMgr.getPropertyInt(SECTION, "search_depth", 2);
        SECTION = "SERVER BASE CONFIGURATION";
        this.intHTTP_instances = iniMgr.getPropertyInt(SECTION, "instances", 10);
        this.blnHTTP_roundrobin = iniMgr.getPropertyBoolean(SECTION, "round_robin", false);
        this.strServer_Socket_listen_ip = iniMgr.getPropertyString(SECTION, "server_socket_listen_ip", "*");
        this.intServer_Socket_listen_port = iniMgr.getPropertyInt(SECTION, "server_socket_listen_port", 80);
        this.intServer_Socket_backlog = iniMgr.getPropertyInt(SECTION, "server_socket_backlog", 10);
        this.lngSocket_timeout = iniMgr.getPropertyLong(SECTION, "socket_timeout", 1500L);
        this.lngInstanceMaxWait = iniMgr.getPropertyLong(SECTION, "instance_maxwait", 2500L);
        this.intStreamBufferSize = iniMgr.getPropertyInt(SECTION, "stream_buffer_size", 8192);
        this.strServer_admin_name = iniMgr.getPropertyString(SECTION, "server_admin_name", "Joe Sixpack");
        this.strServer_admin_mail = iniMgr.getPropertyString(SECTION, "server_admin_mail", "joe@solarsystem.tld");
        this.blnSimulateOverload = iniMgr.getPropertyBoolean(SECTION, "simulate_overload", false);
        this.blnKeepAlive = iniMgr.getPropertyBoolean(SECTION, "keep_alive", true);
        SECTION = "LRWP CONNECTOR";
        this.blnLRWP_allowed = iniMgr.getPropertyBoolean(SECTION, "lrwp_allowed", true);
        this.strLRWP_listen_ip = iniMgr.getPropertyString(SECTION, "lrwp_listen_ip", "*");
        this.intLRWP_listen_port = iniMgr.getPropertyInt(SECTION, "lrwp_listen_port", 81);
        this.lngLRWP_client_timeout = iniMgr.getPropertyLong(SECTION, "lrwp_client_timeout", 15L) * 1000L;
        SECTION = "MISC";
        this.intSemaphoreCheck = iniMgr.getPropertyInt(SECTION, "semaphorecheck", 2) * 1000;
        this.strTimeZone = iniMgr.getPropertyString(SECTION, "timezone", "");
        this.lngCheckpointSave = (long)iniMgr.getPropertyInt(SECTION, "checkpoint_save", 15) * 60L * 1000L;
        this.strServerCheckpointDir = iniMgr.getPropertyString(SECTION, "server_checkpoint_dir", "statistics");
        this.lngStatusDump = (long)iniMgr.getPropertyInt(SECTION, "status_dump", 0) * 60L * 1000L;
        this.strStatusExportFile = iniMgr.getPropertyString(SECTION, "status_export_file", "status.dump");
        this.strStatusExportTo = iniMgr.getPropertyString(SECTION, "status_export_to", "");
        this.strStatusExportSubject = iniMgr.getPropertyString(SECTION, "status_export_subject", "");
        this.blnDebug = iniMgr.getPropertyBoolean(SECTION, "debug", false);
        SECTION = "LOGGING";
        this.strLogFile_Path = iniMgr.getPropertyString(SECTION, "logfile_path", "logfiles");
        this.strLogFile_Praefix = iniMgr.getPropertyString(SECTION, "logfile_praefix", "");
        this.strLogFile_Suffix = iniMgr.getPropertyString(SECTION, "logfile_suffix", "");
        this.strLogFile_Options = iniMgr.getPropertyString(SECTION, "logfile_options", "#!?DMAR");
        this.strLogScrn_Options = iniMgr.getPropertyString(SECTION, "logscrn_options", "#!?DMAR");
        this.strLogFile_DateFormat = iniMgr.getPropertyString(SECTION, "logfile_dateformat", "dd.MM.yyyy");
        this.strLogFile_TimeFormat = iniMgr.getPropertyString(SECTION, "logfile_timeformat", "HH:mm:ss");
        this.strLogFile_Yesterday = iniMgr.getPropertyString(SECTION, "logfile_yesterday", "");
        this.intLogFile_Keep = iniMgr.getPropertyInt(SECTION, "logfile_keep", 0);
        SECTION = "MODULES";
        this.strModules = iniMgr.getPropertiesString(SECTION, "load_mod", new String[0]);
        if (this.strTimeZone.length() != 0) {
            TimeZone.setDefault(TimeZone.getTimeZone(this.strTimeZone));
        }
    }

    public static final boolean isModified() {
        if (iniMgr == null) {
            return false;
        }
        return iniMgr.isModified();
    }
}

