/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import de.zwanzigeins.codecs.HTMLCodec;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.StringBufferExtended;
import java.awt.Component;
import java.awt.FontMetrics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public final class StrTool {
    public static boolean isNumeric(char c) {
        return Character.isDigit(c) || c == '.';
    }

    public static boolean isNumeric(String strToTest) {
        if (strToTest == null || strToTest.length() == 0) {
            return false;
        }
        int i = 0;
        while (i < strToTest.length()) {
            if (!StrTool.isNumeric(strToTest.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String limit(String s, int i) {
        return s.length() > i ? s.substring(0, i) : s;
    }

    public static String lset(int value, int length, char filler) {
        return StrTool.lset(Integer.toString(value), length, filler);
    }

    public static String lset(String copyStr, int length, char filler) {
        byte fillChar = (byte)filler;
        int copyLen = copyStr.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < copyLen) {
            buffer[i] = (byte)copyStr.charAt(i);
            ++i;
        }
        i = copyLen++;
        while (i < length) {
            buffer[i] = fillChar;
            ++i;
        }
        return new String(buffer);
    }

    public static String ltrim(String str) {
        int pp = 0;
        int len = str.length();
        while (pp < len && str.charAt(pp) <= ' ') {
            ++pp;
        }
        return pp > 0 ? str.substring(pp, len) : str;
    }

    public static StringBufferExtended makeAlpha(StringBufferExtended str) {
        int strLen = str.getLength();
        char[] array = str.getCharArray();
        int i = strLen;
        while (i-- > 0) {
            char ch = array[i];
            if (ch > ' ' && ch <= '\u007f') continue;
            array[i] = 32;
        }
        return str;
    }

    public static String makeAlpha(String str) {
        return StrTool.makeAlpha(new StringBufferExtended(str)).toString();
    }

    public static String makeIndex(String str) {
        return StrTool.makeIndex(str, str.length());
    }

    public static String makeIndex(String str, int intLength) {
        int strLen = str.length();
        StringBuffer strb = new StringBuffer(strLen);
        int i = 0;
        while (i < strLen) {
            char ch = str.charAt(i);
            if (ch >= 'A' && ch <= 'Z') {
                strb.append(ch);
            } else if (ch >= 'a' && ch <= 'z') {
                strb.append((char)(ch - 32));
            } else if (ch >= '0' && ch <= '9') {
                strb.append(ch);
            } else if (ch == '%') {
                strb.append(ch);
            } else if (ch == '_') {
                strb.append(ch);
            } else if (ch >= '\u00c0' && ch <= '\u00c6' || ch >= '\u00e0' && ch <= '\u00e6') {
                strb.append('A');
            } else if (ch == '\u00c7' || ch == '\u00e7') {
                strb.append('C');
            } else if (ch >= '\u00c8' && ch <= '\u00cb' || ch >= '\u00e8' && ch <= '\u00eb') {
                strb.append('A');
            } else if (ch >= '\u00cc' && ch <= '\u00cf' || ch >= '\u00ec' && ch <= '\u00ef') {
                strb.append('A');
            } else if (ch == '\u00d0' || ch == '\u00d0') {
                strb.append('D');
            } else if (ch == '\u00d1' || ch == '\u00f1') {
                strb.append('N');
            } else if (ch >= '\u00d2' && ch <= '\u00d6' || ch >= '\u00f2' && ch <= '\u00f6') {
                strb.append('O');
            } else if (ch == '\u00d8' || ch == '\u00f8') {
                strb.append('O');
            } else if (ch >= '\u00d9' && ch <= '\u00dc' || ch >= '\u00f9' && ch <= '\u00fc') {
                strb.append('O');
            } else if (ch >= '\u00dd' && ch <= '\u00de' || ch >= '\u00fd' && ch <= '\u00ff') {
                strb.append('O');
            } else if (ch == '\u00df') {
                strb.append("S");
            }
            ++i;
        }
        if (strb.length() > intLength) {
            strb.setLength(intLength);
        }
        return strb.toString();
    }

    private static String makeNumber(String str, boolean trailingMinus) {
        int strLen = str.length();
        int off = 1;
        int pos = 1;
        char[] chArr = str.toCharArray();
        char[] result = new char[strLen + 3];
        boolean isNegative = false;
        boolean hasPoint = false;
        boolean inNumber = false;
        int i = 0;
        while (i < strLen) {
            char ch = chArr[i];
            if (ch == '-') {
                isNegative = true;
                if (inNumber) {
                    break;
                }
            } else if (ch >= '0' && ch <= '9') {
                inNumber = true;
                result[pos++] = ch;
            } else if (!(hasPoint || ch != '.' && ch != ',')) {
                hasPoint = true;
                if (inNumber) {
                    result[pos++] = 46;
                } else {
                    result[pos++] = 48;
                    result[pos++] = 46;
                    inNumber = true;
                }
            }
            ++i;
        }
        if (isNegative) {
            if (trailingMinus) {
                result[pos++] = 45;
            } else {
                off = 0;
                result[0] = 45;
            }
        }
        return new String(result, off, pos - off);
    }

    public static String makeNumberBook(String str) {
        return StrTool.makeNumber(str, true);
    }

    public static String makeNumberJava(String str) {
        return StrTool.makeNumber(str, false);
    }

    public static String makeNumeric(String str) {
        int strLen = str.length();
        int pos = 0;
        char[] chArr = str.toCharArray();
        char[] result = new char[strLen];
        int i = 0;
        while (i < strLen) {
            char ch = chArr[i];
            if (ch >= '0' && ch <= '9' || ch == '.') {
                result[pos++] = ch;
            }
            ++i;
        }
        return new String(result, 0, pos);
    }

    public static final boolean matches(String string, String string2) {
        String s = HelperFormat.toLowerCase(string);
        String templ = HelperFormat.toLowerCase(string2);
        int wildPos = templ.indexOf(42);
        if (wildPos == -1) {
            return s.equals(templ);
        }
        int templLen = templ.length();
        int strLen = s.length();
        int templIndex = 0;
        int strIndex = 0;
        boolean wildCard = false;
        while (templIndex < templLen) {
            if (templ.charAt(templIndex) == '*') {
                wildCard = true;
                ++templIndex;
                continue;
            }
            int nextWild = templ.indexOf(42, templIndex);
            if (nextWild == -1) {
                nextWild = templLen;
            }
            String templPart = templ.substring(templIndex, nextWild);
            templIndex = nextWild;
            if (wildCard) {
                int pos = s.indexOf(templPart);
                if (pos == -1) {
                    return false;
                }
                strIndex = pos + templPart.length();
            } else {
                if (!s.regionMatches(false, 0, templPart, 0, templPart.length())) {
                    return false;
                }
                strIndex += templPart.length();
            }
            wildCard = false;
        }
        return wildCard ? true : strIndex == strLen;
    }

    public static String reflow(String string, int n) {
        int intMargin;
        String strSeparator = System.getProperty("line.separator");
        String strLine = null;
        StringBuffer strb = new StringBuffer();
        if (n == 0) {
            intMargin = 40;
        }
        if (string.length() < intMargin) {
            return string;
        }
        int len = 0;
        String strText = StrTool.replaceMore(string, "  ", " ");
        strText = StrTool.replaceMore(strText, String.valueOf(strSeparator) + strSeparator, "\u0001");
        strText = StrTool.replaceMore(strText, strSeparator, " ");
        StringTokenizer strt = new StringTokenizer(strText, " ");
        while (strt.hasMoreTokens()) {
            strLine = strt.nextToken().trim();
            while (strLine.length() > intMargin) {
                strb.append(strLine.substring(0, intMargin)).append(strSeparator);
                strLine = strLine.substring(intMargin);
            }
            if (strLine.indexOf("\u0001") != -1) {
                strb.append(strLine.substring(0, strLine.indexOf("\u0001") + 1));
                strLine = strLine.substring(strLine.lastIndexOf("\u0001"));
                strb.append(strLine).append(" ");
                len = strLine.length() + 1;
                continue;
            }
            if ((len += strLine.length()) > intMargin) {
                strb.setLength(strb.length() - 1);
                strb.append(strSeparator).append(strLine).append(" ");
                len = strLine.length() + 1;
                continue;
            }
            strb.append(strLine).append(" ");
            ++len;
        }
        return StrTool.replaceMore(strb.toString(), "\u0001", strSeparator);
    }

    public static String reflowPixelWidth(String str, Component c) {
        if (str.length() == 0) {
            return str;
        }
        if (c == null) {
            return str;
        }
        String strText = str;
        String strLine = null;
        StringBuffer strb = new StringBuffer();
        FontMetrics fm = null;
        int len = 0;
        String strNL = System.getProperty("line.separator");
        int intXWidth = c.getSize().width;
        if (intXWidth == 0) {
            return str;
        }
        intXWidth -= 50;
        strText = StrTool.replaceMore(strText, "  ", " ");
        strText = StrTool.replaceMore(strText, "\r\n\r\n", "\n");
        strText = StrTool.replaceMore(strText, "\n\n", "\n");
        strText = StrTool.replaceMore(strText, "\r\r", "\r");
        strText = StrTool.replaceMore(strText, "\r\n", " ");
        try {
            fm = c.getToolkit().getFontMetrics(c.getFont());
        }
        catch (Exception exception) {
            return str;
        }
        StringTokenizer strt = new StringTokenizer(strText, " ");
        while (strt.hasMoreTokens()) {
            strLine = strt.nextToken();
            while (strLine.length() > intXWidth) {
                strb.append(strLine.substring(0, intXWidth)).append(strNL);
                strLine = strLine.substring(intXWidth);
            }
            if (strLine.startsWith("\n")) {
                strb.append(strLine);
                len = 0;
                continue;
            }
            if ((len += fm.stringWidth(strLine)) > intXWidth) {
                strb.setLength(strb.length() - 1);
                strb.append(strNL);
                strb.append(strLine);
                strb.append(" ");
                len = fm.stringWidth(strLine) + fm.stringWidth(strNL);
                continue;
            }
            strb.append(strLine).append(" ");
            ++len;
        }
        return strb.toString();
    }

    public static String removeHK(String string) {
        String str;
        if (string.startsWith("\"") && string.endsWith("\"")) {
            str = string.substring(1, string.length() - 1);
        }
        return str.trim();
    }

    public static String removeSpaces(String str) {
        return new StringBufferExtended(str).stripSpaces().toString();
    }

    public static String replaceMore(String strOrg, String strFind, String strReplace) {
        int intPos1 = 0;
        int intPos2 = 0;
        StringBuffer strb = new StringBuffer();
        String strCmp = strFind.toLowerCase();
        while ((intPos1 = strOrg.toLowerCase().indexOf(strCmp, intPos1)) != -1) {
            strb.append(strOrg.substring(intPos2, intPos1));
            strb.append(strReplace);
            intPos2 = intPos1 += strFind.length();
        }
        strb.append(strOrg.substring(intPos2));
        return strb.length() == 0 ? strOrg : strb.toString();
    }

    public static String reverse(String s) {
        StringBuffer strb = new StringBuffer(s);
        return strb.reverse().toString();
    }

    public static String rset(int value, int length, char filler) {
        return StrTool.rset(Integer.toString(value), length, filler);
    }

    public static String rset(String copyStr, int length, char filler) {
        byte fillChar = (byte)filler;
        int copyLen = copyStr.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = fillChar;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)copyStr.charAt(i);
            ++i;
        }
        return new String(buffer);
    }

    public static String rtrim(String str) {
        int pp = str.length();
        while (pp > 0 && str.charAt(pp - 1) <= ' ') {
            --pp;
        }
        return pp > 0 ? str.substring(0, pp) : "";
    }

    public static Vector string2vector(String s) {
        Vector<String> v = new Vector<String>();
        try {
            BufferedReader br = new BufferedReader(new StringReader(s));
            String strBuffer = null;
            while ((strBuffer = br.readLine()) != null) {
                v.addElement(strBuffer);
            }
            br.close();
            Object var2_2 = null;
        }
        catch (IOException iOException) {}
        return v;
    }

    public static String tab2space(String strIn, int intTabSize) {
        int intLength = strIn.length();
        int intCol = 0;
        StringBuffer strb = new StringBuffer(intLength * 2);
        int i = 0;
        while (i < intLength) {
            switch (strIn.charAt(i)) {
                case '\t': {
                    int intTabs = intTabSize - intCol % intTabSize;
                    int t = 0;
                    while (t < intTabs) {
                        strb.append(' ');
                        ++intCol;
                        ++t;
                    }
                    break;
                }
                default: {
                    strb.append(strIn.charAt(i));
                    ++intCol;
                }
            }
            ++i;
        }
        return strb.toString();
    }

    public static String toHTML(String value) {
        HTMLCodec htmlCodec = new HTMLCodec();
        return htmlCodec.encode(value);
    }

    public static String vec2string(Vector v) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < v.size()) {
            s.append((String)v.elementAt(i));
            s.append('\n');
            ++i;
        }
        return s.toString();
    }
}

