/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import de.zwanzigeins.util.HelperIO;
import de.zwanzigeins.util.VectorInt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class IniManager {
    private static final String SECTIONMARKER_LEFT = "[";
    private static final String SECTIONMARKER_RIGHT = "]";
    private static final String COMMENTCHARS = "#;!";
    private static final String SEPARATOR = "=";
    static final int TYPE_EMTPY = 0;
    static final int TYPE_COMMENT = 1;
    static final int TYPE_SECTION = 2;
    static final int TYPE_DATA = 3;
    static final int TYPE_UNKNOWN = 4;
    static final int TYPE_PLACEHOLDER = 5;
    private static final String PLACEHOLDER_CHAR = "$";
    private Hashtable hshPlaceholders = new Hashtable();
    private IniManager iniMaster = null;
    private String strIniFile = null;
    private boolean blnEmbeddedMode = false;
    private Vector vecData = new Vector();
    private boolean blnHasLoaded = false;
    private long lngCheckSum1 = 0L;
    private long lngCheckSum2 = 0L;
    private long lngCheckSum3 = 0L;

    private IniManager() {
        this(null, false);
    }

    public IniManager(String strFile) {
        this(strFile, false);
    }

    public IniManager(String strFile, boolean blnEmbed) {
        this.strIniFile = strFile;
        this.blnEmbeddedMode = blnEmbed;
        this.load();
    }

    public void dropKeys(String strSection, String strKey) {
        this.setPropertiesString(strSection, strKey, new String[0]);
    }

    public void dropSection(String strSection) {
        boolean blnInSection = false;
        if (strSection.length() == 0) {
            blnInSection = true;
        }
        int i = 0;
        while (i < this.vecData.size()) {
            Entry e = (Entry)this.vecData.elementAt(i);
            if (e.intType == 2) {
                if (blnInSection) break;
                blnInSection = e.strKey.equalsIgnoreCase(strSection);
            }
            if (blnInSection) {
                this.vecData.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    public String getFileName() {
        return this.strIniFile;
    }

    public Enumeration getKeys(String strSection, boolean blnInherit) {
        Vector<String> vecKeys = new Vector<String>();
        boolean blnInSection = false;
        if (strSection.length() == 0) {
            blnInSection = true;
        }
        int i = 0;
        while (i < this.vecData.size()) {
            Entry e = (Entry)this.vecData.elementAt(i);
            if (e.intType == 2) {
                if (blnInSection) break;
                blnInSection = e.strKey.equalsIgnoreCase(strSection);
            } else if (e.intType == 3 && blnInSection && vecKeys.indexOf(e.strKey) == -1) {
                vecKeys.addElement(e.strKey);
            }
            ++i;
        }
        if (this.iniMaster != null) {
            Enumeration e = this.iniMaster.getKeys(strSection, blnInherit);
            while (e.hasMoreElements()) {
                String str = (String)e.nextElement();
                if (vecKeys.indexOf(str) != -1) continue;
                vecKeys.addElement(str);
            }
        }
        return vecKeys.elements();
    }

    public String[] getPropertiesString(String strSection, String strKey) {
        return this.getPropertiesString(strSection, strKey, new String[0]);
    }

    public String[] getPropertiesString(String strSection, String strKey, String[] strDefaults) {
        VectorInt vecIdx = this.match(strSection, strKey);
        String[] strValues = new String[vecIdx.size()];
        int i = 0;
        while (i < vecIdx.size()) {
            String strPlaceholder;
            String tmp;
            Entry e = (Entry)this.vecData.elementAt(vecIdx.elementAt(i));
            String strData = e.strData;
            int pp1 = strData.indexOf(PLACEHOLDER_CHAR);
            int pp2 = strData.indexOf(PLACEHOLDER_CHAR, pp1 + 1);
            if (pp1 != -1 && pp2 != -1 && (tmp = (String)this.hshPlaceholders.get(strPlaceholder = strData.substring(pp1, pp2 + 1).toLowerCase())) != null) {
                strData = String.valueOf(strData.substring(0, pp1)) + tmp + strData.substring(pp2 + 1);
            }
            strValues[i] = strData;
            ++i;
        }
        if (strValues.length == 0 && this.iniMaster != null) {
            strValues = this.iniMaster.getPropertiesString(strSection, strKey, new String[0]);
        }
        if (strValues.length == 0) {
            strValues = strDefaults;
        }
        return strValues;
    }

    public boolean getPropertyBoolean(String strSection, String strKey) {
        return this.getPropertyBoolean(strSection, strKey, false);
    }

    public boolean getPropertyBoolean(String strSection, String strKey, boolean blnDefault) {
        return this.getPropertyString(strSection, strKey, blnDefault ? "1" : "0").equals("1");
    }

    public double getPropertyDouble(String strSection, String strKey) {
        return this.getPropertyDouble(strSection, strKey, 0.0);
    }

    public double getPropertyDouble(String strSection, String strKey, double dblDefault) {
        try {
            return Double.valueOf(this.getPropertyString(strSection, strKey, String.valueOf(dblDefault)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Cannot parse value '[" + strSection + "] " + strKey + "'");
        }
    }

    public double[] getPropertyDoubleAsArray(String strSection, String strKey) {
        return this.getPropertyDoubleAsArray(strSection, strKey, new double[0]);
    }

    public double[] getPropertyDoubleAsArray(String strSection, String strKey, double[] dblDefaults) {
        String[] strDefaults = new String[dblDefaults.length];
        int i = 0;
        while (i < dblDefaults.length) {
            strDefaults[i] = String.valueOf(dblDefaults[i]);
            ++i;
        }
        String[] s = this.getPropertyStringAsArray(strSection, strKey, strDefaults);
        double[] x = new double[s.length];
        int i2 = 0;
        while (i2 < x.length) {
            x[i2] = Double.valueOf(s[i2]);
            ++i2;
        }
        return x;
    }

    public int getPropertyInt(String strSection, String strKey) {
        return this.getPropertyInt(strSection, strKey, 0);
    }

    public int getPropertyInt(String strSection, String strKey, int intDefault) {
        return (int)this.getPropertyLong(strSection, strKey, intDefault);
    }

    public int[] getPropertyIntAsArray(String strSection, String strKey) {
        return this.getPropertyIntAsArray(strSection, strKey, new int[0]);
    }

    public int[] getPropertyIntAsArray(String strSection, String strKey, int[] intDefaults) {
        String[] strDefaults = new String[intDefaults.length];
        int i = 0;
        while (i < intDefaults.length) {
            strDefaults[i] = String.valueOf(intDefaults[i]);
            ++i;
        }
        String[] s = this.getPropertyStringAsArray(strSection, strKey, strDefaults);
        int[] x = new int[s.length];
        int i2 = 0;
        while (i2 < x.length) {
            x[i2] = Integer.valueOf(s[i2]);
            ++i2;
        }
        return x;
    }

    public long getPropertyLong(String strSection, String strKey) {
        return this.getPropertyLong(strSection, strKey, 0L);
    }

    public long getPropertyLong(String strSection, String strKey, long lngDefault) {
        try {
            return Long.parseLong(this.getPropertyString(strSection, strKey, String.valueOf(lngDefault)));
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Cannot parse value '[" + strSection + "] " + strKey + "'");
        }
    }

    public long[] getPropertyLongAsArray(String strSection, String strKey) {
        return this.getPropertyLongAsArray(strSection, strKey, new long[0]);
    }

    public long[] getPropertyLongAsArray(String strSection, String strKey, long[] lngDefaults) {
        String[] strDefaults = new String[lngDefaults.length];
        int i = 0;
        while (i < lngDefaults.length) {
            strDefaults[i] = String.valueOf(lngDefaults[i]);
            ++i;
        }
        String[] s = this.getPropertyStringAsArray(strSection, strKey, strDefaults);
        long[] x = new long[s.length];
        int i2 = 0;
        while (i2 < x.length) {
            x[i2] = Long.valueOf(s[i2]);
            ++i2;
        }
        return x;
    }

    public String getPropertyString(String strSection, String strKey) {
        return this.getPropertyString(strSection, strKey, "");
    }

    public String getPropertyString(String strSection, String strKey, String strDefault) {
        String[] s = this.getPropertiesString(strSection, strKey, new String[]{strDefault});
        return s == null ? "" : s[0];
    }

    public String[] getPropertyStringAsArray(String strSection, String strKey) {
        return this.getPropertyStringAsArray(strSection, strKey, new String[]{""});
    }

    public String[] getPropertyStringAsArray(String strSection, String strKey, String[] strDefaults) {
        String s = this.getPropertyString(strSection, strKey);
        if (s == null || s.length() == 0) {
            if (strDefaults != null && strDefaults.length > 0) {
                String xx = "";
                int i = 0;
                while (i < strDefaults.length) {
                    xx = String.valueOf(xx) + strDefaults[i] + ",";
                    ++i;
                }
                xx = xx.substring(0, xx.length() - 1);
                this.setPropertyString(strSection, strKey, xx);
            }
            return strDefaults;
        }
        StringTokenizer strt = new StringTokenizer(s, ",");
        String[] x = new String[strt.countTokens()];
        int i = 0;
        while (i < x.length) {
            x[i] = strt.nextToken().trim();
            ++i;
        }
        return x;
    }

    public Enumeration getSections(boolean blnInherit) {
        Vector<String> vecSections = new Vector<String>();
        int i = 0;
        while (i < this.vecData.size()) {
            Entry e = (Entry)this.vecData.elementAt(i);
            if (e.intType == 2 && vecSections.indexOf(e.strKey) == -1) {
                vecSections.addElement(e.strKey);
            }
            ++i;
        }
        if (blnInherit && this.iniMaster != null) {
            Enumeration e = this.iniMaster.getSections(blnInherit);
            while (e.hasMoreElements()) {
                String str = (String)e.nextElement();
                if (vecSections.indexOf(str) != -1) continue;
                vecSections.addElement(str);
            }
        }
        return vecSections.elements();
    }

    public boolean hasLoaded() {
        return this.blnHasLoaded;
    }

    public boolean isModified() {
        if (!this.hasLoaded()) {
            return false;
        }
        if (this.blnEmbeddedMode) {
            return false;
        }
        long lngCSum1 = 0L;
        long lngCSum2 = 0L;
        File flFile = new File(this.strIniFile);
        if (!flFile.exists()) {
            return false;
        }
        this.lngCheckSum3 = flFile.lastModified();
        if (this.lngCheckSum3 == flFile.lastModified()) {
            return false;
        }
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(flFile));
                String strBuffer = null;
                while ((strBuffer = br.readLine()) != null) {
                    if ((strBuffer = strBuffer.trim()).length() == 0 || COMMENTCHARS.indexOf(strBuffer.charAt(0)) != -1) continue;
                    lngCSum1 = lngCSum1 + (long)strBuffer.hashCode() & 0x7FFFL;
                    lngCSum2 ^= (long)strBuffer.hashCode();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            HelperIO.close(br);
            throw throwable;
        }
        Object var7_9 = null;
        HelperIO.close(br);
        return lngCSum1 != this.lngCheckSum1 || lngCSum2 != this.lngCheckSum2;
    }

    private void load() {
        this.vecData.removeAllElements();
        this.hshPlaceholders.clear();
        this.blnHasLoaded = false;
        this.lngCheckSum1 = 0L;
        this.lngCheckSum2 = 0L;
        this.lngCheckSum3 = 0L;
        InputStream is = null;
        if (!this.blnEmbeddedMode) {
            File flFile = new File(this.strIniFile);
            if (!flFile.exists()) {
                return;
            }
            this.lngCheckSum3 = flFile.lastModified();
            try {
                is = new FileInputStream(flFile);
            }
            catch (IOException iOException) {
                is = null;
            }
        } else {
            is = this.getClass().getResourceAsStream("/" + this.strIniFile);
        }
        if (is == null) {
            return;
        }
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(is));
                String strBuffer = null;
                while ((strBuffer = br.readLine()) != null) {
                    strBuffer = strBuffer.trim();
                    Entry e = new Entry(this);
                    if (strBuffer.length() == 0) {
                        e.intType = 0;
                        this.vecData.addElement(e);
                        continue;
                    }
                    if (COMMENTCHARS.indexOf(strBuffer.charAt(0)) != -1) {
                        e.intType = 1;
                        e.strKey = strBuffer;
                        this.vecData.addElement(e);
                        continue;
                    }
                    this.lngCheckSum1 = this.lngCheckSum1 + (long)strBuffer.hashCode() & 0x7FFFL;
                    this.lngCheckSum2 ^= (long)strBuffer.hashCode();
                    if (strBuffer.startsWith(SECTIONMARKER_LEFT) && strBuffer.endsWith(SECTIONMARKER_RIGHT)) {
                        e.intType = 2;
                        e.strKey = strBuffer.substring(1, strBuffer.length() - 1);
                        this.vecData.addElement(e);
                        continue;
                    }
                    if (strBuffer.indexOf(SEPARATOR) != -1) {
                        String strKey = strBuffer.substring(0, strBuffer.indexOf(SEPARATOR)).trim();
                        String strDat = strBuffer.substring(strBuffer.indexOf(SEPARATOR) + 1).trim();
                        if (strKey.startsWith(PLACEHOLDER_CHAR) && strKey.endsWith(PLACEHOLDER_CHAR)) {
                            e.intType = 5;
                            this.hshPlaceholders.put(strKey.toLowerCase(), strDat);
                        } else {
                            e.intType = 3;
                        }
                        e.strKey = strKey;
                        e.strData = strDat;
                        this.vecData.addElement(e);
                        continue;
                    }
                    e.intType = 4;
                    e.strKey = strBuffer;
                    this.vecData.addElement(e);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            HelperIO.close(br);
            throw throwable;
        }
        Object var3_10 = null;
        HelperIO.close(br);
        this.blnHasLoaded = this.vecData.size() > 0;
    }

    public static void main(String[] args) {
        IniManager im = new IniManager("c:\\test.ini");
        System.out.println(im.getPropertyString("", "key1"));
        System.out.println(im.getPropertyString("", "key2"));
        System.out.println(im.getPropertyString("", "key3"));
        System.out.println(im.getPropertyString("", "key4"));
        im.save();
    }

    private VectorInt match(String strSection, String strKey) {
        VectorInt vecMatches = new VectorInt();
        boolean blnInSection = false;
        if (strSection.length() == 0) {
            blnInSection = true;
        }
        int i = 0;
        while (i < this.vecData.size()) {
            Entry e = (Entry)this.vecData.elementAt(i);
            if (e.intType == 2) {
                blnInSection = e.strKey.equalsIgnoreCase(strSection);
            } else if (e.intType == 3 && blnInSection && e.strKey.equalsIgnoreCase(strKey)) {
                vecMatches.addElement(i);
            }
            ++i;
        }
        return vecMatches;
    }

    public void save() {
        if (this.blnEmbeddedMode) {
            return;
        }
        PrintWriter pw = null;
        try {
            try {
                pw = new PrintWriter(new FileWriter(new File(this.strIniFile)));
                int i = 0;
                while (i < this.vecData.size()) {
                    Entry e = (Entry)this.vecData.elementAt(i);
                    pw.println(e.toString());
                    ++i;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var2_6 = null;
            HelperIO.close(pw);
            throw throwable;
        }
        Object var2_7 = null;
        HelperIO.close(pw);
    }

    public boolean sectionExists(String strSection, boolean blnInherit) {
        if (strSection.length() == 0) {
            return true;
        }
        int i = 0;
        while (i < this.vecData.size()) {
            Entry e = (Entry)this.vecData.elementAt(i);
            if (e.intType == 2 && e.strKey.equalsIgnoreCase(strSection)) {
                return true;
            }
            ++i;
        }
        return blnInherit && this.iniMaster != null && this.iniMaster.sectionExists(strSection, blnInherit);
    }

    public void setMaster(IniManager iniMaster) {
        this.iniMaster = iniMaster;
    }

    public void setPropertiesString(String strSection, String strKey, String[] strData) {
        Entry e;
        VectorInt vecIdx = this.match(strSection, strKey);
        if (vecIdx.size() != 0) {
            int i = 0;
            while (i < vecIdx.size()) {
                this.vecData.removeElementAt(vecIdx.elementAt(i) - i);
                ++i;
            }
            int intBasePtr = vecIdx.elementAt(0);
            int i2 = 0;
            while (i2 < strData.length) {
                Entry e2 = new Entry(this);
                e2.intType = 3;
                e2.strKey = strKey;
                e2.strData = strData[i2];
                this.vecData.insertElementAt(e2, intBasePtr + i2);
                ++i2;
            }
            return;
        }
        int intSectionPtr = -1;
        int i = 0;
        while (i < this.vecData.size()) {
            e = (Entry)this.vecData.elementAt(i);
            if (e.intType == 2 && e.strKey.equalsIgnoreCase(strSection)) {
                intSectionPtr = i + 1;
                break;
            }
            ++i;
        }
        if (intSectionPtr == -1) {
            if (strSection.length() != 0) {
                Entry e3 = new Entry(this);
                e3.intType = 2;
                e3.strKey = strSection;
                this.vecData.addElement(e3);
            }
            intSectionPtr = this.vecData.size();
        }
        i = 0;
        while (i < strData.length) {
            e = new Entry(this);
            e.intType = 3;
            e.strKey = strKey;
            e.strData = strData[i];
            this.vecData.insertElementAt(e, intSectionPtr + i);
            ++i;
        }
    }

    public void setPropertyBoolean(String strSection, String strKey, boolean blnData) {
        this.setPropertyString(strSection, strKey, blnData ? "1" : "0");
    }

    public void setPropertyDouble(String strSection, String strKey, double dblData) {
        this.setPropertyString(strSection, strKey, String.valueOf(dblData));
    }

    public void setPropertyInt(String strSection, String strKey, int intData) {
        this.setPropertyString(strSection, strKey, String.valueOf(intData));
    }

    public void setPropertyLong(String strSection, String strKey, long lngData) {
        this.setPropertyString(strSection, strKey, String.valueOf(lngData));
    }

    public void setPropertyString(String strSection, String strKey, String strData) {
        this.setPropertiesString(strSection, strKey, new String[]{strData});
    }

    class Entry
    implements Serializable {
        /* synthetic */ IniManager this$0;
        int intType = -1;
        String strKey = null;
        String strData = null;

        public String toString() {
            switch (this.intType) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.strKey;
                }
                case 2: {
                    return IniManager.SECTIONMARKER_LEFT + this.strKey + IniManager.SECTIONMARKER_RIGHT;
                }
                case 3: {
                    return " " + this.strKey + IniManager.SEPARATOR + this.strData;
                }
                case 5: {
                    return String.valueOf(this.strKey) + IniManager.SEPARATOR + this.strData;
                }
                case 4: {
                    return this.strKey;
                }
            }
            return "????";
        }

        Entry(IniManager this$0) {
            this.this$0 = this$0;
        }
    }
}

