/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class HelperIO {
    private static final Object objLock = new Object();

    private HelperIO() {
    }

    public static final boolean close(Object o) {
        if (o == null) {
            return true;
        }
        try {
            if (o instanceof RandomAccessFile) {
                ((RandomAccessFile)o).close();
                return true;
            }
            if (o instanceof InputStream) {
                ((InputStream)o).close();
                return true;
            }
            if (o instanceof OutputStream) {
                ((OutputStream)o).close();
                return true;
            }
            if (o instanceof Writer) {
                ((Writer)o).close();
                return true;
            }
            if (o instanceof Reader) {
                ((Reader)o).close();
                return true;
            }
            if (o instanceof ServerSocket) {
                ((ServerSocket)o).close();
                return true;
            }
            if (o instanceof Socket) {
                ((Socket)o).close();
                return true;
            }
            if (o instanceof Connection) {
                ((Connection)o).close();
                return true;
            }
            if (o instanceof Statement) {
                ((Statement)o).close();
                return true;
            }
            if (o instanceof PreparedStatement) {
                ((PreparedStatement)o).close();
                return true;
            }
            if (o instanceof ResultSet) {
                ((ResultSet)o).close();
                return true;
            }
            HelperIO.writeLog("Unknown close object: " + o);
        }
        catch (Throwable throwable) {}
        return false;
    }

    public static final boolean commit(Connection con) {
        if (con == null) {
            return true;
        }
        try {
            con.commit();
            return true;
        }
        catch (Throwable t) {
            HelperIO.writeLog(t);
            return false;
        }
    }

    public static final void flush(Object o) {
        if (o == null) {
            return;
        }
        try {
            if (o instanceof OutputStream) {
                ((OutputStream)o).flush();
                return;
            }
            if (o instanceof Writer) {
                ((Writer)o).flush();
                return;
            }
            HelperIO.writeLog("Unknown flush object: " + o);
        }
        catch (Throwable throwable) {}
    }

    public static final String platformPath(String string) {
        if (string == null) {
            return null;
        }
        String strPath = string.replace('\\', File.separatorChar);
        strPath = strPath.replace('/', File.separatorChar);
        return strPath;
    }

    public static final boolean rollback(Connection con) {
        if (con == null) {
            return true;
        }
        try {
            con.rollback();
            return true;
        }
        catch (Throwable t) {
            HelperIO.writeLog(t);
            return false;
        }
    }

    public static final void writeLog(String strMsg) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter("err.dmp"));
                pw.println(strMsg);
                pw.flush();
                pw.close();
            }
            catch (Throwable t2) {
                System.out.println("close: " + t2);
            }
        }
    }

    public static final void writeLog(Throwable t) {
        Object object = objLock;
        synchronized (object) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter("err.dmp"));
                t.printStackTrace(pw);
                pw.flush();
                pw.close();
            }
            catch (Throwable t2) {
                System.out.println("close: " + t2);
            }
        }
    }
}

