/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;

public class HelperFormat {
    private static final int CASEDIFF = 32;
    private static final Object objLock = new Object();

    private HelperFormat() {
    }

    public static final String buildID(int intNb, int intMaxNb) {
        int fillChar = 48;
        String strLeft = String.valueOf(intNb);
        String strRight = String.valueOf(intMaxNb);
        int length = strRight.length();
        int copyLen = strLeft.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = fillChar;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)strLeft.charAt(i);
            ++i;
        }
        return "[" + new String(buffer) + "/" + strRight + "]";
    }

    public static final String filterBackspace(String string) {
        String strMsg;
        int i = 0;
        while (i < strMsg.length()) {
            char ch = string.charAt(i);
            if (ch == '\b') {
                strMsg = String.valueOf(string.substring(0, i - 1)) + string.substring(i + 1);
                i = 0;
            }
            ++i;
        }
        return strMsg;
    }

    public static final String formatMemoryString(long lngSize) {
        double result = lngSize;
        String tail = " Bt";
        if (lngSize > 0x10000000000L) {
            result = (double)lngSize / 1.099511627776E12;
            tail = " TB";
        } else if (lngSize > 0x40000000L) {
            result = (double)lngSize / 1.073741824E9;
            tail = " GB";
        } else if (lngSize >= 0x100000L) {
            result = (double)lngSize / 1048576.0;
            tail = " MB";
        } else if (lngSize >= 1024L) {
            result = (double)lngSize / 1024.0;
            tail = " KB";
        }
        if (!tail.equals(" Bt")) {
            String ret = String.valueOf(result = (double)Math.round(result * 100.0) / 100.0);
            int point = ret.indexOf(46);
            if (point == -1) {
                ret = String.valueOf(ret) + ".00";
            } else {
                int diff = ret.length() - point;
                if (diff < 3) {
                    ret = String.valueOf(ret) + "0";
                } else if (diff > 3) {
                    ret = ret.substring(0, point + 2);
                }
            }
            return result + tail;
        }
        return lngSize + tail;
    }

    public static final String getArg(String str) {
        int pp = str.indexOf(" ");
        if (pp == -1) {
            return null;
        }
        return str.substring(pp + 1).trim();
    }

    public static final String getCmd(String str) {
        int pp = str.indexOf(" ");
        if (pp == -1) {
            return str.trim();
        }
        return str.substring(0, pp).trim();
    }

    public static final String limit(String str, int intLength) {
        return str.length() > intLength ? str.substring(0, intLength) : str;
    }

    public static String lset(long value, int length, char filler) {
        return HelperFormat.lset(Long.toString(value), length, filler);
    }

    public static String lset(String copyStr, int length, char filler) {
        byte fillChar = (byte)filler;
        int copyLen = copyStr.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < copyLen) {
            buffer[i] = (byte)copyStr.charAt(i);
            ++i;
        }
        i = copyLen++;
        while (i < length) {
            buffer[i] = fillChar;
            ++i;
        }
        return new String(buffer);
    }

    public static String makeIndex(String string, boolean blnKeepSpace) {
        String str = string.trim();
        int strLen = str.length();
        StringBuffer strb = new StringBuffer(strLen);
        int i = 0;
        while (i < strLen) {
            char ch = str.charAt(i);
            if (ch == ' ') {
                if (blnKeepSpace) {
                    strb.append(ch);
                }
            } else if (ch >= 'A' && ch <= 'Z') {
                strb.append(ch);
            } else if (ch >= 'a' && ch <= 'z') {
                strb.append((char)(ch - 32));
            } else if (ch >= '0' && ch <= '9') {
                strb.append(ch);
            } else if (ch == '%') {
                strb.append(ch);
            } else if (ch == '_') {
                strb.append(ch);
            } else if (ch == '\u00df') {
                strb.append("S");
            } else if (ch >= '\u00c0' && ch <= '\u00c6' || ch >= '\u00e0' && ch <= '\u00e6') {
                strb.append('A');
            } else if (ch == '\u00c7' || ch == '\u00e7') {
                strb.append('C');
            } else if (ch >= '\u00c8' && ch <= '\u00cb' || ch >= '\u00e8' && ch <= '\u00eb') {
                strb.append('A');
            } else if (ch >= '\u00cc' && ch <= '\u00cf' || ch >= '\u00ec' && ch <= '\u00ef') {
                strb.append('A');
            } else if (ch == '\u00d0' || ch == '\u00d0') {
                strb.append('D');
            } else if (ch == '\u00d1' || ch == '\u00f1') {
                strb.append('N');
            } else if (ch >= '\u00d2' && ch <= '\u00d6' || ch >= '\u00f2' && ch <= '\u00f6') {
                strb.append('O');
            } else if (ch == '\u00d8' || ch == '\u00f8') {
                strb.append('O');
            } else if (ch >= '\u00d9' && ch <= '\u00dc' || ch >= '\u00f9' && ch <= '\u00fc') {
                strb.append('O');
            } else if (ch >= '\u00dd' && ch <= '\u00de' || ch >= '\u00fd' && ch <= '\u00ff') {
                strb.append('O');
            }
            ++i;
        }
        if (strb.length() > str.length()) {
            strb.setLength(str.length());
        }
        return strb.toString();
    }

    public static final String number(double dbl, int intNKS) {
        DecimalFormatSymbols decfs = new DecimalFormatSymbols();
        decfs.setDecimalSeparator('.');
        decfs.setGroupingSeparator(',');
        DecimalFormat decf = new DecimalFormat("0", decfs);
        ((NumberFormat)decf).setMinimumIntegerDigits(1);
        ((NumberFormat)decf).setMinimumFractionDigits(intNKS);
        return decf.format(dbl);
    }

    public static final String number_rset(double dbl, int intVKS, int intNKS) {
        DecimalFormatSymbols decfs = new DecimalFormatSymbols();
        decfs.setDecimalSeparator('.');
        decfs.setGroupingSeparator(',');
        DecimalFormat decf = new DecimalFormat("0", decfs);
        ((NumberFormat)decf).setMinimumIntegerDigits(1);
        ((NumberFormat)decf).setMinimumFractionDigits(intNKS);
        if (intVKS == 0) {
            return decf.format(dbl);
        }
        return HelperFormat.rset(decf.format(dbl), intVKS + (intNKS == 0 ? 0 : 1) + intNKS, ' ');
    }

    public static String rset(long value, int length, char filler) {
        return HelperFormat.rset(Long.toString(value), length, filler);
    }

    public static String rset(String copyStr, int length, char filler) {
        byte fillChar = (byte)filler;
        int copyLen = copyStr.length();
        if (copyLen > length) {
            copyLen = length;
        }
        byte[] buffer = new byte[length];
        int i = 0;
        while (i < length - copyLen) {
            buffer[i] = fillChar;
            ++i;
        }
        i = 0;
        while (i < copyLen) {
            buffer[i + length - copyLen] = (byte)copyStr.charAt(i);
            ++i;
        }
        return new String(buffer);
    }

    public static String tab2space(String strIn, int intTabSize) {
        int intLength = strIn.length();
        int intCol = 0;
        StringBuffer strb = new StringBuffer(intLength * 2);
        int i = 0;
        while (i < intLength) {
            switch (strIn.charAt(i)) {
                case '\t': {
                    int intTabs = intTabSize - intCol % intTabSize;
                    int t = 0;
                    while (t < intTabs) {
                        strb.append(' ');
                        ++intCol;
                        ++t;
                    }
                    break;
                }
                default: {
                    strb.append(strIn.charAt(i));
                    ++intCol;
                }
            }
            ++i;
        }
        return strb.toString();
    }

    public static final String toLowerCase(String str) {
        char[] ch = str.toCharArray();
        HelperFormat.toLowerCase(ch);
        return new String(ch);
    }

    public static final void toLowerCase(char[] chars) {
        int len = chars.length;
        int i = 0;
        while (i < len) {
            char ch = chars[i];
            if (ch >= 'A' && ch <= 'Z') {
                int n = i;
                chars[n] = (char)(chars[n] + 32);
            }
            ++i;
        }
    }

    public static final String validateDomainName(String strDomain) {
        String s = HelperFormat.toLowerCase(strDomain.trim());
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch < '0' && ch != '-' && ch != '.') {
                return null;
            }
            if (ch > '9' && ch < 'a') {
                return null;
            }
            if (ch > 'z') {
                return null;
            }
            ++i;
        }
        int pp = s.indexOf(".");
        if (pp == -1) {
            return null;
        }
        if (s.length() - pp < 3) {
            return null;
        }
        if (pp < 2) {
            return null;
        }
        return s;
    }

    public static final String validateName(String string) {
        String strName = string.trim();
        if (strName.length() == 0) {
            return null;
        }
        boolean blnValid = true;
        int i = 0;
        while (i < strName.length() && blnValid) {
            char ch = strName.charAt(i);
            if (ch < '0') {
                blnValid = false;
            }
            if (ch > '9' && ch < 'a') {
                blnValid = false;
            }
            if (ch > 'z') {
                blnValid = false;
            }
            ++i;
        }
        return blnValid ? strName : null;
    }
}

