/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.email;

import de.zwanzigeins.codecs.QuotedPrintableCodec;
import de.zwanzigeins.email.MailSendException;
import de.zwanzigeins.util.HelperIO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;

public class MailSend {
    private String strDNS = null;
    private String strFrom_Name = null;
    private String strFrom_EMail = null;
    private String strTo_Name = null;
    private String strTo_EMail = null;
    private String strSubject = null;
    private String strContent = null;
    private PrintWriter pwOut = null;
    private BufferedReader brIn = null;
    private String strMXHostUsed = null;
    private String strLastSent = null;
    private String strLastRecv = null;
    private long lngBytes = 0L;
    private String strSM_Host = null;
    private String strSM_Auth = null;
    private String strSM_User = null;
    private String strSM_Pass = null;
    public static final String AUTH_SMTP_AFTER_POP3 = "AUTH_SMTP_AFTER_POP3";
    public static final String AUTH_PLAIN = "AUTH_PLAIN";
    public static final String AUTH_LOGIN = "AUTH_LOGIN";
    public static final String AUTH_CRAM_MD5 = "AUTH_CRAM_MD5";
    public static final String AUTH_NONE = "AUTH_NONE";

    public MailSend(String strDNS) {
        this.strDNS = strDNS;
    }

    private Socket getAuthConnection() {
        if (this.strSM_Auth.equals(AUTH_SMTP_AFTER_POP3)) {
            Socket sok = null;
            try {
                try {
                    String strBuffer = "";
                    sok = new Socket(this.strSM_Host, 110);
                    sok.setSoTimeout(2000);
                    PrintWriter pw = new PrintWriter(sok.getOutputStream(), true);
                    BufferedReader br = new BufferedReader(new InputStreamReader(sok.getInputStream()));
                    strBuffer = br.readLine();
                    if (!strBuffer.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on logon");
                    }
                    pw.println("User " + this.strSM_User);
                    strBuffer = br.readLine();
                    if (!strBuffer.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on USER [" + strBuffer + "]");
                    }
                    pw.println("Pass " + this.strSM_Pass);
                    strBuffer = br.readLine();
                    if (!strBuffer.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on PASS [" + strBuffer + "]");
                    }
                }
                catch (IOException e) {
                    throw new MailSendException("AUTH_SMTP_AFTER_POP3 Cannot connect to POP3 server " + this.strSM_Host + " Reason: " + e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var2_8 = null;
                HelperIO.close(sok);
                throw throwable;
            }
            Object var2_9 = null;
            HelperIO.close(sok);
            try {
                return new Socket(this.strSM_Host, 25);
            }
            catch (IOException e) {
                throw new MailSendException("AUTH_SMTP_AFTER_POP3 Cannot connect to SMTP server " + this.strSM_Host + " Reason: " + e.toString());
            }
        }
        if (this.strSM_Auth.equals(AUTH_NONE)) {
            try {
                return new Socket(this.strSM_Host, 25);
            }
            catch (IOException e) {
                throw new MailSendException("AUTH_NONE Cannot connect to SMTP server " + this.strSM_Host + " Reason: " + e.toString());
            }
        }
        throw new MailSendException("Unsupported smarthost auth " + this.strSM_Auth);
    }

    public long getBytes() {
        return this.lngBytes;
    }

    public String getLastReceived() {
        return this.strLastRecv;
    }

    public String getLastSent() {
        return this.strLastSent;
    }

    private Socket getMXConnection(String strDomain) {
        String[] strMX_Hosts = this.getMXHosts(strDomain);
        if (strMX_Hosts == null) {
            throw new MailSendException("Cannot find an MX server for " + strDomain);
        }
        InetAddress inaLocal = null;
        int i = 0;
        while (i < strMX_Hosts.length) {
            try {
                Socket sokMX = new Socket(strMX_Hosts[i], 25, inaLocal, 0);
                sokMX.setSoTimeout(30000);
                return sokMX;
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        throw new MailSendException("Cannot connect to any MX server for domain " + strDomain);
    }

    private String[] getMXHosts(String strDomain) {
        ((Hashtable)System.getProperties()).put("dns.server", this.strDNS);
        Record[] records = null;
        int i = 0;
        while (i < 5) {
            records = dns.getRecords((String)strDomain, (short)15);
            if (records == null) {
                records = dns.getRecords((String)strDomain, (short)1);
            }
            if (records != null) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (records == null) {
            return null;
        }
        if (records[0] instanceof MXRecord && records.length > 0) {
            boolean blnNotSorted;
            do {
                blnNotSorted = false;
                int j = 0;
                while (j < records.length - 1) {
                    MXRecord mxrecord = (MXRecord)records[j];
                    MXRecord mxrecord2 = (MXRecord)records[j + 1];
                    if (mxrecord.getPriority() > mxrecord2.getPriority()) {
                        records[j] = mxrecord2;
                        records[j + 1] = mxrecord;
                        blnNotSorted = true;
                    }
                    ++j;
                }
            } while (blnNotSorted);
        }
        String[] strMX_Hosts = new String[records.length];
        int i2 = 0;
        while (i2 < records.length) {
            String strTmp = records[i2] instanceof MXRecord ? ((MXRecord)records[i2]).getTarget().toString() : ((ARecord)records[i2]).getName().toString();
            if (strTmp.endsWith(".")) {
                strTmp = strTmp.substring(0, strTmp.length() - 1);
            }
            strMX_Hosts[i2] = strTmp;
            ++i2;
        }
        return strMX_Hosts;
    }

    public String getMXHostUsed() {
        return this.strMXHostUsed;
    }

    public static void main(String[] args) throws IOException {
        MailSend ms = new MailSend("80.242.134.170");
        ms.setSmartHost("daisy.harddiskcafe.de", AUTH_SMTP_AFTER_POP3, "hohmann@harddiskcafe.de", "bernd");
        ms.setFrom_EMail("hohmann@harddiskcafe.de");
        ms.setSubject("Testmail mit Umlauten \u00e4\u00f6\u00fc \u00c4\u00d6\u00dc \u00df");
        ms.setContent("Hi,\r\nIch habe hier eine kleine Testmail aus einer Toolbox generiert.\r\nKommen die Umlaute bei euch korrekt an?\r\n>>\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df<<\r\nBernd\r\n");
        ms.setTo_EMail("marianne.kestler@arcor.de");
        ms.send();
        System.out.println("Sent 1");
        ms.setTo_EMail("ms@web-creative.org");
        ms.send();
        System.out.println("Sent 2");
    }

    public boolean send() throws IOException {
        boolean bl;
        QuotedPrintableCodec qpCodec = new QuotedPrintableCodec();
        String ENCODING = "iso-8859-1";
        if (this.strFrom_Name == null) {
            this.strFrom_Name = this.strFrom_EMail;
        }
        if (this.strTo_Name == null) {
            this.strTo_Name = this.strTo_EMail;
        }
        StringBuffer strb = new StringBuffer();
        strb.append("From: \"" + this.strFrom_Name + "\" <" + this.strFrom_EMail + ">\r\n");
        strb.append("To: \"" + this.strTo_Name + "\" <" + this.strTo_EMail + ">\r\n");
        strb.append("Date: " + new Date().toString() + "\r\n");
        strb.append("Subject: =?" + ENCODING + "?Q?" + qpCodec.encode(this.strSubject) + "?=\r\n");
        strb.append("MIME-Version: 1.0\r\n");
        strb.append("Content-type: text/plain; charset=" + ENCODING + "\r\n");
        strb.append("Content-transfer-encoding: quoted-printable\r\n");
        strb.append("\r\n");
        strb.append(qpCodec.encode(this.strContent));
        strb.append("\r\n.");
        this.lngBytes = 0L;
        String strDomain = this.strTo_EMail.substring(this.strTo_EMail.indexOf("@") + 1);
        this.strMXHostUsed = null;
        Socket sok = null;
        sok = this.strSM_Host == null ? this.getMXConnection(strDomain) : this.getAuthConnection();
        this.strMXHostUsed = sok.getInetAddress().getHostName();
        try {
            bl = this.send0(sok, strb.toString());
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            HelperIO.close(sok);
            HelperIO.close(this.brIn);
            HelperIO.close(this.pwOut);
            throw throwable;
        }
        HelperIO.close(sok);
        HelperIO.close(this.brIn);
        HelperIO.close(this.pwOut);
        return bl;
    }

    private boolean send0(Socket sok, String strMsg) throws IOException {
        this.pwOut = new PrintWriter(sok.getOutputStream(), true);
        this.brIn = new BufferedReader(new InputStreamReader(sok.getInputStream()));
        if (!this.waitFor("220")) {
            return false;
        }
        if (!this.sendLine("HELO WORLD")) {
            return false;
        }
        if (!this.sendLine("MAIL FROM: <" + this.strFrom_EMail + ">")) {
            return false;
        }
        if (!this.sendLine("RCPT TO: <" + this.strTo_EMail + ">")) {
            return false;
        }
        if (!this.sendLine("DATA")) {
            return false;
        }
        if (!this.sendLine(strMsg)) {
            return false;
        }
        this.sendLine("QUIT");
        return true;
    }

    private boolean sendLine(String string) {
        try {
            String strCmd;
            this.strLastSent = string;
            this.strLastRecv = "";
            this.pwOut.println(string);
            this.pwOut.flush();
            this.lngBytes += (long)string.length();
            do {
                this.strLastRecv = strCmd = this.brIn.readLine();
            } while (strCmd.substring(3, 4).equals("-"));
            return strCmd.startsWith("2") || strCmd.startsWith("3");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setContent(String s) {
        this.strContent = s;
    }

    public void setFrom_EMail(String s) {
        this.strFrom_EMail = s;
    }

    public void setFrom_Name(String s) {
        this.strFrom_Name = s;
    }

    public void setSmartHost(String strHost, String strAuth, String strUser, String strPass) {
        this.strSM_Host = strHost;
        this.strSM_Auth = strAuth;
        this.strSM_User = strUser;
        this.strSM_Pass = strPass;
    }

    public void setSubject(String s) {
        this.strSubject = s;
    }

    public void setTo_EMail(String s) {
        this.strTo_EMail = s;
    }

    public void setTo_Name(String s) {
        this.strTo_Name = s;
    }

    private boolean waitFor(String strCmd) {
        try {
            String strResult;
            this.strLastSent = "";
            do {
                this.strLastRecv = strResult = this.brIn.readLine();
            } while (strResult.substring(3, 4).equals("-"));
            return strResult.startsWith(strCmd);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

