/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.codecs;

import de.zwanzigeins.codecs.TextCodec;
import java.util.BitSet;

public class QuotedPrintableCodec
extends TextCodec {
    private static final BitSet PRINTABLE_CHARS = new BitSet(256);
    private static char ESCAPE_CHAR = (char)61;
    private static char TAB = (char)9;
    private static char SPACE = (char)32;

    static {
        int i = 33;
        while (i <= 60) {
            PRINTABLE_CHARS.set(i);
            ++i;
        }
        i = 62;
        while (i <= 126) {
            PRINTABLE_CHARS.set(i);
            ++i;
        }
        PRINTABLE_CHARS.set(TAB);
        PRINTABLE_CHARS.set(SPACE);
    }

    public String decode(String strIn) {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < strIn.length()) {
            char ch = strIn.charAt(i);
            if (ch != ESCAPE_CHAR) {
                strb.append(ch);
            } else {
                try {
                    int u = Character.digit(strIn.charAt(++i), 16);
                    int l = Character.digit(strIn.charAt(++i), 16);
                    if (u == -1 || l == -1) break;
                    strb.append((char)((u << 4) + l));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
            }
            ++i;
        }
        return strb.toString();
    }

    public String encode(String strIn) {
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < strIn.length()) {
            char ch = strIn.charAt(i);
            if (PRINTABLE_CHARS.get(ch)) {
                strb.append(ch);
            } else {
                strb.append(ESCAPE_CHAR);
                strb.append(Character.toUpperCase(Character.forDigit(ch >> 4 & 0xF, 16)));
                strb.append(Character.toUpperCase(Character.forDigit(ch & 0xF, 16)));
            }
            ++i;
        }
        return strb.toString();
    }

    public static void main(String[] args) {
    }
}

