/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.awt;

import de.zwanzigeins.awt.StateChangeEvent;
import de.zwanzigeins.awt.StateChangeListener;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;
import net.zerotoaster.event.MTAEvent;
import net.zerotoaster.event.MTAEventListener;
import net.zerotoaster.event.MTAEventQueue;

public class StateChanger
extends Component
implements MTAEventListener {
    private static final String TXT_NEW = "New ...";
    private static final String TXT_STORE = "Store";
    private static final String TXT_DELETE = "Delete";
    private static final String TXT_CANCEL = "Cancel";
    private static final String TXT_HELP = "Help";
    private String strName;
    public static final int STATE_UNDEFINED = 0;
    public static final int STATE_BROWSE = 1;
    public static final int STATE_CHANGE = 2;
    public static final int STATE_NEW = 3;
    public static final int STATE_DELETE = 4;
    public static final int STATE_STORE = 5;
    public static final int STATE_CANCEL = 6;
    public static final int STATE_HELP = 7;
    private int intState = 0;
    private Vector vecKeyFields;
    private boolean blnKeyField;
    private Vector vecUserFields;
    private boolean blnUserFields;
    private Vector vecStateChangeListeners;
    private Vector vecAdditionalChangers;
    private boolean blnRecordExists;
    private boolean blnRecordNew;
    private boolean blnNew;
    private boolean blnStore;
    private boolean blnDelete;
    private boolean blnCancel;
    private boolean blnHelp;
    private Button btnNew;
    private Button btnStore;
    private Button btnDelete;
    private Button btnCancel;
    private Button btnHelp;
    private boolean blnGuiLocked;
    private Menu mnuEdit = null;
    private MenuItem mniSeparator = null;
    private MenuItem mniNew = null;
    private MenuItem mniStore = null;
    private MenuItem mniDelete = null;
    private MenuItem mniCancel = null;
    private MenuItem mniChange = null;
    private MenuItem mniHelp = null;
    private Font fntMenu = new Font("dialog", 1, 12);
    private Vector vecLockedObjects = null;
    private Dispatcher dispatcher = new Dispatcher(this);

    public StateChanger() {
        this("Anonymous Coward");
    }

    public StateChanger(String strName) {
        this.vecKeyFields = new Vector(2, 2);
        this.vecStateChangeListeners = new Vector(5);
        this.vecUserFields = new Vector(5);
        this.vecAdditionalChangers = new Vector(2);
        this.vecAdditionalChangers.addElement(this);
        this.vecLockedObjects = new Vector(5);
        this.enableEvents(128L);
        this.setName(strName);
        MTAEventQueue.addListener((MTAEventListener)this);
    }

    public synchronized void addStateChangeListener(StateChangeListener l) {
        if (l == null) {
            return;
        }
        if (!this.vecStateChangeListeners.contains(l)) {
            this.vecStateChangeListeners.addElement(l);
        }
    }

    public void disableAll() {
        int i = 0;
        while (i < this.vecAdditionalChangers.size()) {
            StateChanger stchng = (StateChanger)this.vecAdditionalChangers.elementAt(i);
            stchng.blnGuiLocked = true;
            stchng.setGUIState();
            ++i;
        }
        this.blnGuiLocked = true;
    }

    public void dispose() {
        MTAEventQueue.removeListener((MTAEventListener)this);
        if (this.vecKeyFields != null) {
            this.vecKeyFields.removeAllElements();
            this.vecKeyFields = null;
        }
        if (this.vecStateChangeListeners != null) {
            this.vecStateChangeListeners.removeAllElements();
            this.vecStateChangeListeners = null;
        }
        if (this.vecUserFields != null) {
            this.vecUserFields.removeAllElements();
            this.vecUserFields = null;
        }
        if (this.vecAdditionalChangers != null) {
            this.vecAdditionalChangers.removeAllElements();
            this.vecAdditionalChangers = null;
        }
        if (this.vecLockedObjects != null) {
            this.vecLockedObjects.removeAllElements();
            this.vecLockedObjects = null;
        }
    }

    public void doBrowse() {
        this.setState(1, "doBrowse()");
    }

    public void doCancel() {
        this.setState(6, "doCancel()");
    }

    public void doChange() {
        this.setState(2, "doChange()");
    }

    public void doDelete() {
        this.setState(4, "doDelete()");
    }

    public void doHelp() {
        this.setState(7, "doHelp()");
    }

    public void doNew() {
        this.blnRecordExists = false;
        this.setState(3, "doNew()");
    }

    public void doStore() {
        this.setState(5, "doStore()");
    }

    public void enableAll() {
        this.blnGuiLocked = false;
        int i = 0;
        while (i < this.vecAdditionalChangers.size()) {
            StateChanger stchng = (StateChanger)this.vecAdditionalChangers.elementAt(i);
            stchng.blnGuiLocked = false;
            stchng.setGUIState();
            ++i;
        }
    }

    public void eventDisable(Component c) {
        this.vecLockedObjects.addElement(c);
    }

    public void eventEnable(Component c) {
        this.vecLockedObjects.removeElement(c);
    }

    private void fieldEnabler(Vector vec, boolean blnEnabled) {
        if (vec == null) {
            return;
        }
        int i = 0;
        while (i < vec.size()) {
            this.fieldEnabler0(vec.elementAt(i), blnEnabled);
            ++i;
        }
    }

    private void fieldEnabler0(Object obj, boolean blnEnabled) {
        if (obj == null) {
            return;
        }
        if (this.vecLockedObjects.indexOf(obj) == -1) {
            return;
        }
        if (obj instanceof Checkbox[]) {
            Checkbox[] chk = (Checkbox[])obj;
            int i = 0;
            while (i < chk.length) {
                if (this.vecLockedObjects.indexOf(chk[i]) == -1) {
                    chk[i].setEnabled(blnEnabled);
                }
                ++i;
            }
            return;
        }
        if (obj instanceof Component) {
            ((Component)obj).setEnabled(blnEnabled);
            return;
        }
    }

    public void finalize() {
        this.dispose();
    }

    public String getName() {
        return this.strName;
    }

    public boolean getRecordExists() {
        return this.blnRecordExists;
    }

    private void handleChangeEvent(Object obj) {
        if (this.vecLockedObjects.indexOf(obj) != -1) {
            return;
        }
        if (this.blnRecordNew) {
            if (!this.blnStore) {
                if (obj == null) {
                    this.setState(2, "<null>");
                } else {
                    this.setState(2, obj.toString());
                }
            }
            return;
        }
        if (this.blnRecordExists) {
            if (!this.blnStore) {
                this.setState(2, obj.toString());
            }
        } else if (obj != null && obj instanceof KeyEvent) {
            ((KeyEvent)obj).consume();
        }
    }

    public boolean isChanged() {
        return this.blnStore;
    }

    public boolean isGuiLocked() {
        return this.blnGuiLocked;
    }

    public boolean isNewRecord() {
        return this.blnRecordNew;
    }

    public void mtaEvent(MTAEvent e) {
        if (!(e instanceof StateChangeEvent)) {
            return;
        }
        StateChangeEvent ev = (StateChangeEvent)e;
        if (ev.getSource() != this) {
            return;
        }
        this.setInternalState(ev.getState());
        this.setGUIState();
        if (this.vecStateChangeListeners != null) {
            int j = 0;
            while (j < this.vecStateChangeListeners.size()) {
                StateChangeListener l = (StateChangeListener)this.vecStateChangeListeners.elementAt(j);
                l.stateChanged(ev);
                ++j;
            }
            if (ev.isReset()) {
                this.setInternalState(this.intState);
                this.setGUIState();
            } else {
                this.intState = ev.getState();
            }
        }
    }

    private void rebuildMenu() {
        if (this.mnuEdit == null) {
            return;
        }
        if (this.btnNew != null) {
            this.mniNew.setEnabled(this.btnNew.isEnabled());
            this.mnuEdit.add(this.mniNew);
        }
        if (this.btnStore != null) {
            this.mniStore.setEnabled(this.btnStore.isEnabled());
            this.mnuEdit.add(this.mniStore);
        }
        if (this.btnCancel != null) {
            this.mniCancel.setEnabled(this.btnCancel.isEnabled());
            this.mnuEdit.add(this.mniCancel);
        }
        if (this.btnDelete != null) {
            this.mniDelete.setEnabled(this.btnDelete.isEnabled());
            this.mnuEdit.add(this.mniDelete);
        }
        if (this.btnHelp != null) {
            this.mniHelp.setEnabled(this.btnHelp.isEnabled());
            this.mnuEdit.add(this.mniHelp);
        }
    }

    public void registerAdditionalStateChanger(StateChanger stchng) {
        this.vecAdditionalChangers.addElement(stchng);
    }

    public void registerBtnCancel(Button btn) {
        btn.setEnabled(this.blnCancel);
        btn.addActionListener(this.dispatcher);
        this.btnCancel = btn;
        if (this.mnuEdit != null) {
            this.mnuEdit.setEnabled(true);
            this.rebuildMenu();
        }
    }

    public void registerBtnDelete(Button btn) {
        btn.setEnabled(this.blnDelete);
        btn.addActionListener(this.dispatcher);
        this.btnDelete = btn;
        if (this.mnuEdit != null) {
            this.mnuEdit.setEnabled(true);
            this.rebuildMenu();
        }
    }

    public void registerBtnHelp(Button btn) {
        btn.setEnabled(this.blnHelp);
        btn.addActionListener(this.dispatcher);
        this.btnHelp = btn;
        if (this.mnuEdit != null) {
            this.mnuEdit.setEnabled(true);
            this.rebuildMenu();
        }
    }

    public void registerBtnNew(Button btn) {
        btn.setEnabled(this.blnNew);
        btn.addActionListener(this.dispatcher);
        this.btnNew = btn;
        if (this.mnuEdit != null) {
            this.mnuEdit.setEnabled(true);
            this.rebuildMenu();
        }
    }

    public void registerBtnStore(Button btn) {
        btn.setEnabled(this.blnStore);
        btn.addActionListener(this.dispatcher);
        this.btnStore = btn;
        if (this.mnuEdit != null) {
            this.mnuEdit.setEnabled(true);
            this.rebuildMenu();
        }
    }

    public void registerChangeTrigger(Object obj) {
        this.registerUserField(obj);
        if (obj instanceof TextField) {
            ((TextField)obj).addKeyListener(this.dispatcher);
        } else if (obj instanceof TextArea) {
            ((TextArea)obj).addKeyListener(this.dispatcher);
        }
        if (obj instanceof ItemSelectable) {
            ((ItemSelectable)obj).addItemListener(this.dispatcher);
        }
        if (obj instanceof Checkbox[]) {
            Checkbox[] chk = (Checkbox[])obj;
            int i = 0;
            while (i < chk.length) {
                chk[i].addItemListener(this.dispatcher);
                ++i;
            }
        }
    }

    public void registerKeyField(Object obj) {
        this.vecKeyFields.addElement(obj);
    }

    public void registerMenuBar(MenuBar mnuMenuBar) {
        if (this.mnuEdit != null) {
            this.mnuEdit.removeAll();
        } else {
            this.mnuEdit = new Menu("Edit");
            this.mnuEdit.setFont(this.fntMenu);
            mnuMenuBar.add(this.mnuEdit);
        }
        this.mnuEdit.setEnabled(false);
        this.mniSeparator = new MenuItem("-");
        this.mniNew = new MenuItem(TXT_NEW, new MenuShortcut(78, false));
        this.mniNew.setFont(this.fntMenu);
        this.mniNew.addActionListener(this.dispatcher);
        this.mniStore = new MenuItem(TXT_STORE, new MenuShortcut(83, false));
        this.mniStore.setFont(this.fntMenu);
        this.mniStore.addActionListener(this.dispatcher);
        this.mniDelete = new MenuItem(TXT_DELETE, new MenuShortcut(68, false));
        this.mniDelete.setFont(this.fntMenu);
        this.mniDelete.addActionListener(this.dispatcher);
        this.mniCancel = new MenuItem(TXT_CANCEL, new MenuShortcut(67, false));
        this.mniCancel.setFont(this.fntMenu);
        this.mniCancel.addActionListener(this.dispatcher);
        this.mniHelp = new MenuItem(TXT_HELP, new MenuShortcut(72, false));
        this.mniHelp.setFont(this.fntMenu);
        this.mniHelp.addActionListener(this.dispatcher);
    }

    public void registerUserField(Object obj) {
        this.vecUserFields.addElement(obj);
    }

    public synchronized void removeStateChangeListener(StateChangeListener l) {
        this.vecStateChangeListeners.removeElement(l);
    }

    private void setGUIState() {
        if (this.btnNew != null && this.vecLockedObjects.indexOf(this.btnNew) == -1) {
            this.btnNew.setLabel(" New ... ");
            this.btnNew.setEnabled(this.blnNew && !this.blnGuiLocked);
            if (this.mnuEdit != null) {
                this.mniNew.setEnabled(this.blnNew && !this.blnGuiLocked);
            }
        }
        if (this.btnStore != null && this.vecLockedObjects.indexOf(this.btnStore) == -1) {
            this.btnStore.setLabel(" Store ");
            this.btnStore.setEnabled(this.blnStore && !this.blnGuiLocked);
            if (this.mnuEdit != null) {
                this.mniStore.setEnabled(this.blnStore && !this.blnGuiLocked);
            }
        }
        if (this.btnDelete != null && this.vecLockedObjects.indexOf(this.btnDelete) == -1) {
            this.btnDelete.setLabel(" Delete ");
            this.btnDelete.setEnabled(this.blnDelete && !this.blnGuiLocked);
            if (this.mnuEdit != null) {
                this.mniDelete.setEnabled(this.blnDelete && !this.blnGuiLocked);
            }
        }
        if (this.btnCancel != null && this.vecLockedObjects.indexOf(this.btnCancel) == -1) {
            this.btnCancel.setLabel(" Cancel ");
            this.btnCancel.setEnabled(this.blnCancel && !this.blnGuiLocked);
            if (this.mnuEdit != null) {
                this.mniCancel.setEnabled(this.blnCancel && !this.blnGuiLocked);
            }
        }
        if (this.btnHelp != null && this.vecLockedObjects.indexOf(this.btnHelp) == -1) {
            this.btnHelp.setLabel(" Help ");
            this.btnHelp.setEnabled(this.blnHelp && !this.blnGuiLocked);
            if (this.mnuEdit != null) {
                this.mniHelp.setEnabled(this.blnHelp && !this.blnGuiLocked);
            }
        }
        this.fieldEnabler(this.vecKeyFields, this.blnKeyField && !this.blnGuiLocked);
        this.fieldEnabler(this.vecUserFields, this.blnUserFields && !this.blnGuiLocked);
        if (this.btnCancel != null) {
            this.btnCancel.getParent().doLayout();
        }
    }

    private void setInternalState(int intState) {
        switch (intState) {
            case 0: {
                this.blnNew = false;
                this.blnStore = false;
                this.blnDelete = false;
                this.blnCancel = false;
                this.blnKeyField = false;
                this.blnUserFields = false;
                this.blnRecordNew = false;
                this.blnHelp = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.blnNew = false;
                this.blnStore = false;
                this.blnDelete = false;
                this.blnCancel = false;
                this.blnKeyField = false;
                this.blnUserFields = false;
                this.blnHelp = true;
                break;
            }
            case 1: {
                this.blnNew = true;
                this.blnStore = false;
                this.blnDelete = this.getRecordExists();
                this.blnCancel = false;
                this.blnKeyField = true;
                this.blnUserFields = this.getRecordExists();
                this.blnRecordNew = false;
                this.blnHelp = true;
                break;
            }
            case 2: {
                this.blnNew = false;
                this.blnStore = true;
                this.blnDelete = false;
                this.blnCancel = true;
                this.blnKeyField = false;
                this.blnUserFields = true;
                this.blnHelp = true;
                break;
            }
            case 3: {
                this.blnNew = false;
                this.blnStore = false;
                this.blnDelete = false;
                this.blnCancel = true;
                this.blnKeyField = false;
                this.blnUserFields = true;
                this.blnRecordNew = true;
                this.blnHelp = true;
            }
        }
    }

    public void setName(String str) {
        this.strName = str;
    }

    public void setRecordExists(boolean flag) {
        this.blnRecordExists = flag;
        this.setInternalState(this.intState);
        this.setGUIState();
    }

    private void setState(int intNewState, String strSource) {
        StateChangeEvent e = new StateChangeEvent(this, strSource, intNewState, this.isNewRecord(), this.isChanged());
        MTAEventQueue.postEvent((MTAEvent)e);
    }

    public String toString() {
        return new StateChangeEvent(this, "StateChanger.toString()", this.intState, this.isNewRecord(), this.isChanged()).toString();
    }

    static MenuItem access$mniCancel(StateChanger stateChanger) {
        return stateChanger.mniCancel;
    }

    static MenuItem access$mniHelp(StateChanger stateChanger) {
        return stateChanger.mniHelp;
    }

    static MenuItem access$mniStore(StateChanger stateChanger) {
        return stateChanger.mniStore;
    }

    static Button access$btnStore(StateChanger stateChanger) {
        return stateChanger.btnStore;
    }

    static Button access$btnDelete(StateChanger stateChanger) {
        return stateChanger.btnDelete;
    }

    static Button access$btnHelp(StateChanger stateChanger) {
        return stateChanger.btnHelp;
    }

    static Button access$btnCancel(StateChanger stateChanger) {
        return stateChanger.btnCancel;
    }

    static MenuItem access$mniDelete(StateChanger stateChanger) {
        return stateChanger.mniDelete;
    }

    static Button access$btnNew(StateChanger stateChanger) {
        return stateChanger.btnNew;
    }

    static MenuItem access$mniNew(StateChanger stateChanger) {
        return stateChanger.mniNew;
    }

    static void access$handleChangeEvent(StateChanger stateChanger, Object object) {
        stateChanger.handleChangeEvent(object);
    }

    static void access$setState(StateChanger stateChanger, int n, String string) {
        stateChanger.setState(n, string);
    }

    class Dispatcher
    extends KeyAdapter
    implements ItemListener,
    ActionListener,
    TextListener {
        /* synthetic */ StateChanger this$0;

        public void textValueChanged(TextEvent e) {
            StateChanger.access$handleChangeEvent(this.this$0, e);
        }

        public void keyPressed(KeyEvent e) {
            if (e.getSource() instanceof TextField && !((TextField)e.getSource()).isEditable()) {
                return;
            }
            if (e.isActionKey()) {
                return;
            }
            if (e.getKeyCode() >= 33 && e.getKeyCode() <= 40) {
                return;
            }
            switch (e.getKeyCode()) {
                case 16: 
                case 17: 
                case 18: 
                case 37: {
                    return;
                }
            }
            switch (e.getKeyChar()) {
                case '\t': 
                case '\n': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0014': 
                case '\u001b': 
                case '#': {
                    return;
                }
            }
            StateChanger.access$handleChangeEvent(this.this$0, e);
        }

        public void itemStateChanged(ItemEvent e) {
            StateChanger.access$handleChangeEvent(this.this$0, e);
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == StateChanger.access$btnCancel(this.this$0) || e.getSource() == StateChanger.access$mniCancel(this.this$0) && StateChanger.access$mniCancel(this.this$0).isEnabled()) {
                StateChanger.access$setState(this.this$0, 6, e.toString());
                return;
            }
            if (e.getSource() == StateChanger.access$btnDelete(this.this$0) || e.getSource() == StateChanger.access$mniDelete(this.this$0) && StateChanger.access$mniDelete(this.this$0).isEnabled()) {
                StateChanger.access$setState(this.this$0, 4, e.toString());
                return;
            }
            if (e.getSource() == StateChanger.access$btnNew(this.this$0) || e.getSource() == StateChanger.access$mniNew(this.this$0) && StateChanger.access$mniNew(this.this$0).isEnabled()) {
                StateChanger.access$setState(this.this$0, 3, e.toString());
                return;
            }
            if (e.getSource() == StateChanger.access$btnStore(this.this$0) || e.getSource() == StateChanger.access$mniStore(this.this$0) && StateChanger.access$mniStore(this.this$0).isEnabled()) {
                StateChanger.access$setState(this.this$0, 5, e.toString());
                return;
            }
            if (e.getSource() == StateChanger.access$btnHelp(this.this$0) || e.getSource() == StateChanger.access$mniHelp(this.this$0) && StateChanger.access$mniHelp(this.this$0).isEnabled()) {
                StateChanger.access$setState(this.this$0, 7, e.toString());
                return;
            }
        }

        Dispatcher(StateChanger this$0) {
            this.this$0 = this$0;
        }
    }
}

