#!/bin/bash
#
# Normally, editing this script should not be required.
# Only case is to set up JAVA_HOME if it's not already defined.
#
# To specify an alternative JVM, edit and uncomment the following 
# line and change the path accordingly.
#SMARTCVS_JAVA_HOME=/usr/lib/java

# If you experience problems, e.g. incorrectly painted windows, try to uncomment one of the following two lines
#export AWT_TOOLKIT=MToolkit
#export AWT_TOOLKIT=XToolkit

if [ "$SMARTCVS_JAVA_HOME" = "" ] ; then
    SMARTCVS_JAVA_HOME=$JAVA_HOME
fi

_JAVA_EXEC="java"
if [ "$SMARTCVS_JAVA_HOME" != "" ] ; then
    _TMP="$SMARTCVS_JAVA_HOME/bin/java"
    if [ -f "$_TMP" ] ; then
        if [ -x "$_TMP" ] ; then
            _JAVA_EXEC="$_TMP"
        else
            echo "Warning: $_TMP is not executable"
        fi
    else
        echo "Warning: $_TMP does not exist"
    fi
fi

if ! which "$_JAVA_EXEC" >/dev/null ; then
    echo "Error: No Java Runtime Environment found"
    echo "Please set the environment variable JAVA_HOME to the root directory of your SUN Java installation, e.g. by editing the 7th line in this launcher script."
    exit 1
fi

#
# Resolve the location of the smartcvs installation.
# This includes resolving any symlinks.
PRG=$0
while [ -h "$PRG" ]; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
    if expr "$link" : '^/' 2> /dev/null >/dev/null; then
        PRG="$link"
    else
        PRG="`dirname "$PRG"`/$link"
    fi
done

SMARTCVS_BIN=`dirname "$PRG"`

# absolutize dir
oldpwd=`pwd`
cd "${SMARTCVS_BIN}"; SMARTCVS_BIN=`pwd`
cd "${oldpwd}"; unset oldpwd

SMARTCVS_HOME=`dirname "$SMARTCVS_BIN"`
_CP="$SMARTCVS_HOME/lib/smartcvs.jar:$SMARTCVS_HOME/lib/tools.jar"
_CP="$_CP:$SMARTCVS_HOME/lib/help.jar"

_VMOPTIONS="$_VMOPTIONS -Djava.net.preferIPv4Stack=true" 

#
# Where settings are stored?
#
# SmartCVS stores its setting per default in '$HOME/.smartcvs' . If you want
# to change this (e.g. to install different SmartCVS versions on the same
# machine and under the same user account), you need to set the Java system
# property 'smartcvs.home'. You could use other system properties by
# surrounding them with '${<system-property>}'.
#
# Example:
# To tell SmartCVS to store its settings in '$HOME/.smartcvs2',
# you must know, that the user's home directory is represented in Java through
# the system property 'user.home'.
# The following line will do the job (if uncommented):
# _VMOPTIONS="$_VMOPTIONS -Dsmartcvs.home=\${user.home}/.smartcvs2"

# To set a different look-and-feel, uncomment the following two lines and edit
# them to point to the look-and-feel-jar-file and the look-and-feel-class
# _VMOPTIONS="$_VMOPTIONS -Dsmartcvs.lookandfeel=look.and.feel.clazz"
# _CP="$_CP:/path/to/look/and/feel/jar-file"

$_JAVA_EXEC $_VMOPTIONS $SMARTCVS_VMOPTIONS -classpath "$_CP" SmartCVS
