package org.netbeans.lib.cvsclient.response;

import java.text.*;
import java.util.*;

import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
final class ResponseUtils {

	// Static =================================================================

	private static SimpleDateFormat dateFormatter;

	public static synchronized Date parseDateString(String dateString) throws ParseException {
		return getFormatter().parse(dateString);
	}

	// Utils ==================================================================

	private static DateFormat getFormatter() {
		if (dateFormatter == null) {
			dateFormatter = new SimpleDateFormat("dd MMM yy HH:mm:ss", Locale.US);
			dateFormatter.setTimeZone(TimeZoneUtils.getGMT());
		}
		return dateFormatter;
	}
}
