/*****************************************************************************
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version
 * 1.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is available at http://www.sun.com/
 *
 * The Original Code is the CVS Client Library.
 * The Initial Developer of the Original Code is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.
 *
 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.request;

import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * Sends the server a copy of a locally modified file.
 *
 * @author Robert Greig
 */
public final class ModifiedRequest extends AbstractFileStateRequest {

	// Fields =================================================================

	private final FileDetails fileDetails;
	private final FilePermissions permissions;

	// Setup ==================================================================

	public ModifiedRequest(FsFilePath fsFile, boolean isBinary, FilePermissions permissions) {
		super(fsFile);

		BugLog.assertNotNull(permissions);

		this.fileDetails = new FileDetails(fsFile, isBinary);
		this.permissions = permissions;
	}

	// Implemented ============================================================

	/**
	 * Get the request String that will be passed to the server
	 *
	 * @return the request String
	 */
	public String getRequestString() {
		final StringBuffer request = new StringBuffer();
		request.append("Modified ");
		request.append(getFileName());
		request.append('\n');
		request.append(permissions.toUnixString());
		request.append('\n');
		return request.toString();
	}

	/**
	 * If a file transmission is required, get the file object representing
	 * the file to transmit after the request string. The default
	 * implementation returns null, indicating no file is to be transmitted
	 *
	 * @return the file details object, if one should be transmitted, or null
	 *         if no file object is to be transmitted.
	 */
	@Override
	public FileDetails getFileForTransmission() {
		return fileDetails;
	}
}
