package org.netbeans.lib.cvsclient.request;

import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public class KoptRequest extends AbstractRequest {

	// Fields =================================================================

	private final KeywordSubstitution keywordSubstMode;

	// Setup ==================================================================

	public KoptRequest(KeywordSubstitution keywordSubstMode) {
		BugLog.assertNotNull(keywordSubstMode);

		this.keywordSubstMode = keywordSubstMode;
	}

	// Implemented ============================================================

	public String getRequestString() {
		return "Kopt -k" + keywordSubstMode.toString() + '\n';
	}
}
