/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.file;

/**
 * @author Thomas Singer
 */
public class LocalFileStatus {

	// Constants ==============================================================

	public static final LocalFileStatus UP_TO_DATE = new LocalFileStatus("Up-to-date");
	public static final LocalFileStatus MODIFIED = new LocalFileStatus("Modified");
	public static final LocalFileStatus ADDED = new LocalFileStatus("Added");
	public static final LocalFileStatus REMOVED = new LocalFileStatus("Removed");
	public static final LocalFileStatus NOT_EXISTING = new LocalFileStatus("Not existing");

	// Fields =================================================================

	private final String name;

	// Setup ==================================================================

	private LocalFileStatus(String name) {
		this.name = name;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		return name;
	}
}
