/*****************************************************************************
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version
 * 1.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is available at http://www.sun.com/
 *
 * The Original Code is the CVS Client Library.
 * The Initial Developer of the Original Code is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.
 *
 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.file;

import java.io.*;
import java.util.*;

/**
 * Handles the reading and writing of files to and from the server. Different
 * implementations of this interface can use different formats for sending or
 * receiving the files, for example gzipped format.
 *
 * @author Robert Greig
 */
public interface ILocalFileWriter {

	void writeTextFile(FsFilePath fsFile, int length, InputStream inputStream, Date modificationDate, IReaderFactory readerFactory) throws IOException;

	void writeTemplateFile(FsFilePath fsFile, int length, InputStream inputStream, IReaderFactory readerFactory) throws IOException;

	void writeBinaryFile(FsFilePath fsFile, int length, InputStream inputStream, Date modificationDate) throws IOException;

	/**
	 * Remove the specified file from the local disk.
	 */
	void removeLocalFile(FsFilePath fsFile) throws IOException;

	/**
	 * Rename the local file
	 */
	void renameLocalFile(FsFilePath fsFile, String newFileName) throws IOException;

	void setFilePermissions(FsFilePath fsFile, FilePermissions permissions) throws IOException;

	long getModificationTime(FsFilePath fsFile);
}
