/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.*;

import org.netbeans.lib.cvsclient.admin.*;

/**
 * @author Thomas Singer
 */
public interface ICvsFileSystem {

	FsFilePath getFsFile(String relativeLocalDirectoryPath, String repositoryFilePath);

	FsDirectoryPath getFsDirectory(String relativeLocalDirectoryPath);

	FsDirectoryPath getRelativeRepositoryRootPath(IAdminReader adminReader) throws IOException;

	String getRelativeRepositoryPath(String repositoryPath);

	String getAbsoluteRepositoryPath(String relativeRepositoryPath);

	String getAbsoluteRepositoryPathForDirectory(FsDirectoryPath fsDirectory, IAdminReader adminReader) throws IOException;

	String getAbsoluteRepositoryRootPath();
}

