/*****************************************************************************
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version
 * 1.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is available at http://www.sun.com/
 *
 * The Original Code is the CVS Client Library.
 * The Initial Developer of the Original Code is Thomas Singer.
 * All Rights Reserved.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.command.remove;

import java.io.*;
import java.util.*;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.admin.*;
import org.netbeans.lib.cvsclient.command.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.request.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
final class RemoveRequestFactory extends AbstractRequestFactory implements ICommandRequestFactory {

	// Constants ==============================================================

	private static final ILogger LOG = LoggerManager.getLogger("javacvs.remove");

	// Fields =================================================================

	private final ICvsFiles cvsFiles;
	private final Collection<FsFilePath> fsFiiles;
	private final boolean deleteBeforeRemove;
	private final boolean ignoreLocallyExistingFiles;

	// Setup ==================================================================

	public RemoveRequestFactory(ICvsFiles cvsFiles, Collection<FsFilePath> fsFiles, boolean deleteBeforeRemove, boolean ignoreLocallyExistingFiles) {
		this.cvsFiles = cvsFiles;
		this.fsFiiles = fsFiles;
		this.deleteBeforeRemove = deleteBeforeRemove;
		this.ignoreLocallyExistingFiles = ignoreLocallyExistingFiles;
	}

	// Implemented ============================================================

	public ResponseExpectingRequest getResponseExpectingRequest() {
		return CommandRequest.REMOVE;
	}

	public void sendCommandRequests(IRequestSender requestSender, IClientEnvironment clientEnvironment) throws CommandAbortedException, IOException {
		Requests.addArgumentRequest("--", requestSender);
		addFileAndLocalPathRequests(cvsFiles, IgnoreFileFilter.IGNORE_ALL, clientEnvironment, requestSender);
		Requests.addArgumentRequests(fsFiiles, requestSender);
	}

	@Override
	protected void addRequestForFile(FsFilePath fsFile, Entry entry, boolean fileExists, IIgnoreFileFilter ignoreFileFilter, IClientEnvironment clientEnvironment, IRequestSender requestSender) throws CommandAbortedException, IOException {
		if (deleteBeforeRemove) {
			try {
				clientEnvironment.getLocalFileWriter().removeLocalFile(fsFile);
			}
			catch (IOException ex) {
				LOG.error("", ex);
			}
			fileExists = false;
		}
		if (ignoreLocallyExistingFiles) {
			fileExists = false;
		}
		super.addRequestForFile(fsFile, entry, fileExists, ignoreFileFilter, clientEnvironment, requestSender);
	}
}
