/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command;

import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public final class GlobalOptions
		implements IGlobalOptions {

	// Fields =================================================================

	private boolean checkedOutFilesReadOnly;
	private boolean doNoChanges;
	private boolean noHistoryLogging;
	private boolean someQuiet;
	private boolean useGzip;

	// Setup ==================================================================

	public GlobalOptions() {
	}

	public GlobalOptions(IGlobalOptions globalOptions) {
		BugLog.assertNotNull(globalOptions);

		checkedOutFilesReadOnly = globalOptions.isCheckedOutFilesReadOnly();
		doNoChanges = globalOptions.isDoNoChanges();
		noHistoryLogging = globalOptions.isNoHistoryLogging();
		someQuiet = globalOptions.isSomeQuiet();
		useGzip = globalOptions.isUseGzip();
	}

	// Implemented ============================================================

	public boolean isCheckedOutFilesReadOnly() {
		return checkedOutFilesReadOnly;
	}

	public boolean isDoNoChanges() {
		return doNoChanges;
	}

	public boolean isNoHistoryLogging() {
		return noHistoryLogging;
	}

	public boolean isUseGzip() {
		return useGzip;
	}

	public boolean isSomeQuiet() {
		return someQuiet;
	}

	// Accessing ==============================================================

	public void setCheckedOutFilesReadOnly(boolean checkedOutFilesReadOnly) {
		this.checkedOutFilesReadOnly = checkedOutFilesReadOnly;
	}

	public void setDoNoChanges(boolean doNoChanges) {
		this.doNoChanges = doNoChanges;
	}

	public void setNoHistoryLogging(boolean noHistoryLogging) {
		this.noHistoryLogging = noHistoryLogging;
	}

	public void setUseGzip(boolean useGzip) {
		this.useGzip = useGzip;
	}

	public void setSomeQuiet(boolean someQuiet) {
		this.someQuiet = someQuiet;
	}

}
