/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command;

import java.io.*;

import org.netbeans.lib.cvsclient.admin.*;
import org.netbeans.lib.cvsclient.event.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
public class DefaultEntryParser
		implements ICvsListener, IEntryListener {

	// Fields =================================================================

	private final IEventSender eventSender;
	private final ILocalFileSystem localFileSystem;

	// Setup ==================================================================

	public DefaultEntryParser(IEventSender eventSender, ILocalFileSystem localFileSystem) {
		BugLog.assertNotNull(eventSender);
		BugLog.assertNotNull(localFileSystem);

		this.eventSender = eventSender;
		this.localFileSystem = localFileSystem;
	}

	// Implemented ============================================================

	public void registerListeners(ICvsListenerRegistry listenerRegistry) {
		listenerRegistry.addEntryListener(this);
	}

	public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
		listenerRegistry.removeEntryListener(this);
	}

	public void gotEntry(FsFilePath fsFile, Entry entry) {
		final File file = localFileSystem.getFile(fsFile);
		eventSender.notifyFileInfoListeners(new DefaultFileInfo(fsFile, file));
	}
}

