/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */
package org.netbeans.lib.cvsclient.command;

import org.netbeans.lib.cvsclient.admin.*;
import org.netbeans.lib.cvsclient.file.*;
import org.netbeans.lib.cvsclient.util.*;

/**
 * @author Thomas Singer
 */
final class CvsFile {

	// Static =================================================================

	public static CvsFile createCvsFileForEntry(FsFilePath fsFile, Entry entry, boolean exists) {
		BugLog.assertNotNull(fsFile);
		BugLog.assertNotNull(entry);

		return new CvsFile(fsFile, exists, entry, false);
	}

	public static CvsFile createCvsFileForExistingFile(FsFilePath fsFile) {
		BugLog.assertNotNull(fsFile);

		return new CvsFile(fsFile, true, null, false);
	}

	public static CvsFile createCvsDirectory(FsDirectoryPath fsDirectory) {
		BugLog.assertNotNull(fsDirectory);

		return new CvsFile(fsDirectory, true, null, true);
	}

	// Fields =================================================================

	private final FsPath fsEntry;
	private final Entry entry;
	private final boolean directory;
	private final boolean exists;

	// Setup ==================================================================

	private CvsFile(FsPath fsEntry, boolean exists, Entry entry, boolean directory) {
		BugLog.assertNotNull(fsEntry);

		this.fsEntry = fsEntry;
		this.exists = exists;
		this.entry = entry;
		this.directory = directory;
	}

	// Implemented ============================================================

	@Override
	public String toString() {
		final StringBuffer buffer = new StringBuffer(50);
		buffer.append("fsEntry='");
		buffer.append(fsEntry.toString());
		if (directory) {
			buffer.append('/');
		}
		buffer.append("', entry=");
		if (entry != null) {
			buffer.append("'");
			buffer.append(entry);
			buffer.append("'");
		}
		else {
			buffer.append((String)null);
		}
		return buffer.toString();
	}

	// Accessing ==============================================================

	public boolean isDirectory() {
		return directory;
	}

	public Entry getEntry() {
		return entry;
	}

	public FsPath getFsEntry() {
		return fsEntry;
	}

	public boolean exists() {
		return exists;
	}
}
