/*****************************************************************************
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version
 * 1.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is available at http://www.sun.com/
 *
 * The Original Code is the CVS Client Library.
 * The Initial Developer of the Original Code is Robert Greig.
 * Portions created by Robert Greig are Copyright (C) 2000.
 * All Rights Reserved.
 *
 * Contributor(s): Robert Greig.
 *****************************************************************************/
package org.netbeans.lib.cvsclient.command;

import org.netbeans.lib.cvsclient.*;
import org.netbeans.lib.cvsclient.event.*;
import org.netbeans.lib.cvsclient.progress.*;

/**
 * All commands must extend this class. A command is essentially a
 * collection of requests that make up what is logically known as a CVS
 * command (from a user's perspective). Commands correspond to operations the
 * user can perform with CVS, for example checkout a module or perform a
 * diff on two file versions.<br>
 * Commands are automatically added as CVS event listeners. They can act
 * on particular events and perhaps fire new events.
 *
 * @author Robert Greig
 */
public abstract class AbstractCommand {

	// Abstract ===============================================================

	public abstract boolean execute(IRequestProcessor requestProcessor, IEventSender eventSender, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment,
	                                IProgressViewer progressViewer) throws CommandException;

	/**
	 * This method returns how the command would looklike when typed on the
	 * command line.
	 * <p/>
	 * Each command is responsible for constructing this information.
	 *
	 * @return <command's name> [<parameters>] files/dirs. Example: checkout -p CvsCommand.java
	 */
	public abstract String getCvsCommandLine();

	// Fields =================================================================

	private final GlobalOptions globalOptions = new GlobalOptions();

	// Setup ==================================================================

	protected AbstractCommand() {
	}

	// Accessing ==============================================================

	public final IGlobalOptions getGlobalOptions() {
		return globalOptions;
	}

	public final GlobalOptions getGlobalOptionsImpl() {
		return globalOptions;
	}
}
