package org.netbeans.lib.cvsclient;

import java.util.*;

/**
 * @author Thomas Singer
 */
public final class ValidRequests {

	// Fields =================================================================

	private final Set<String> validRequests = new HashSet<String>();

	// Setup ==================================================================

	public ValidRequests() {
	}

	// Accessing ==============================================================

	public void setValidRequests(String validRequestsResponse) {
		validRequests.clear();

		for (StringTokenizer tokenizer = new StringTokenizer(validRequestsResponse, " "); tokenizer.hasMoreTokens();) {
			final String validRequest = tokenizer.nextToken();
			validRequests.add(validRequest);
		}
	}

	public boolean hasValidRequests() {
		return validRequests != null;
	}

	public boolean isValid(String request) {
		return validRequests.contains(request);
	}
}
