/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.io;

import java.math.BigInteger;

public class UnsignedInteger64 {
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    public static final BigInteger MIN_VALUE = new BigInteger("0");
    private BigInteger A;

    public UnsignedInteger64(String string) throws NumberFormatException {
        this.A = new BigInteger(string);
        if (this.A.compareTo(MIN_VALUE) < 0 || this.A.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public UnsignedInteger64(byte[] byArray) throws NumberFormatException {
        this.A = new BigInteger(byArray);
        if (this.A.compareTo(MIN_VALUE) < 0 || this.A.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public UnsignedInteger64(long l) {
        this.A = BigInteger.valueOf(l);
    }

    public UnsignedInteger64(BigInteger bigInteger) {
        this.A = new BigInteger(bigInteger.toString());
        if (this.A.compareTo(MIN_VALUE) < 0 || this.A.compareTo(MAX_VALUE) > 0) {
            throw new NumberFormatException();
        }
    }

    public boolean equals(Object object) {
        try {
            UnsignedInteger64 unsignedInteger64 = (UnsignedInteger64)object;
            return unsignedInteger64.A.equals(this.A);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public BigInteger bigIntValue() {
        return this.A;
    }

    public long longValue() {
        return this.A.longValue();
    }

    public String toString() {
        return this.A.toString(10);
    }

    public int hashCode() {
        return this.A.hashCode();
    }

    public static UnsignedInteger64 add(UnsignedInteger64 unsignedInteger64, UnsignedInteger64 unsignedInteger642) {
        return new UnsignedInteger64(unsignedInteger64.A.add(unsignedInteger642.A));
    }

    public static UnsignedInteger64 add(UnsignedInteger64 unsignedInteger64, int n) {
        return new UnsignedInteger64(unsignedInteger64.A.add(BigInteger.valueOf(n)));
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[8];
        byte[] byArray2 = this.bigIntValue().toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        return byArray;
    }
}

