/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.engines;

public class RC4Engine {
    private static final int D = 256;
    private byte[] C = null;
    private int B = 0;
    private int E = 0;
    private byte[] A = null;

    public void init(boolean bl, byte[] byArray) {
        this.A = byArray;
        this.A(this.A);
    }

    public String getAlgorithmName() {
        return "RC4";
    }

    public byte returnByte(byte by) {
        this.B = this.B + 1 & 0xFF;
        this.E = this.C[this.B] + this.E & 0xFF;
        byte by2 = this.C[this.B];
        this.C[this.B] = this.C[this.E];
        this.C[this.E] = by2;
        return (byte)(by ^ this.C[this.C[this.B] + this.C[this.E] & 0xFF]);
    }

    public void processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n + n2 > byArray.length) {
            throw new RuntimeException("input buffer too short");
        }
        if (n3 + n2 > byArray2.length) {
            throw new RuntimeException("output buffer too short");
        }
        for (int i = 0; i < n2; ++i) {
            this.B = this.B + 1 & 0xFF;
            this.E = this.C[this.B] + this.E & 0xFF;
            byte by = this.C[this.B];
            this.C[this.B] = this.C[this.E];
            this.C[this.E] = by;
            byArray2[i + n3] = (byte)(byArray[i + n] ^ this.C[this.C[this.B] + this.C[this.E] & 0xFF]);
        }
    }

    public void reset() {
        this.A(this.A);
    }

    private void A(byte[] byArray) {
        int n;
        this.A = byArray;
        this.B = 0;
        this.E = 0;
        if (this.C == null) {
            this.C = new byte[256];
        }
        for (n = 0; n < 256; ++n) {
            this.C[n] = (byte)n;
        }
        n = 0;
        int n2 = 0;
        for (int i = 0; i < 256; ++i) {
            n2 = (byArray[n] & 0xFF) + this.C[i] + n2 & 0xFF;
            byte by = this.C[i];
            this.C[i] = this.C[n2];
            this.C[n2] = by;
            n = (n + 1) % byArray.length;
        }
    }
}

