/*
 * Decompiled with CFR 0.152.
 */
package com.maverick.crypto.digests;

import com.maverick.crypto.digests.Digest;

public abstract class GeneralDigest
implements Digest {
    private byte[] A;
    private int B;
    private long C;

    protected GeneralDigest() {
        this.A = new byte[4];
        this.B = 0;
    }

    protected GeneralDigest(GeneralDigest generalDigest) {
        this.A = new byte[generalDigest.A.length];
        System.arraycopy(generalDigest.A, 0, this.A, 0, generalDigest.A.length);
        this.B = generalDigest.B;
        this.C = generalDigest.C;
    }

    public void update(byte by) {
        this.A[this.B++] = by;
        if (this.B == this.A.length) {
            this.processWord(this.A, 0);
            this.B = 0;
        }
        ++this.C;
    }

    public void update(byte[] byArray, int n, int n2) {
        while (this.B != 0 && n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
        while (n2 > this.A.length) {
            this.processWord(byArray, n);
            n += this.A.length;
            n2 -= this.A.length;
            this.C += (long)this.A.length;
        }
        while (n2 > 0) {
            this.update(byArray[n]);
            ++n;
            --n2;
        }
    }

    public void finish() {
        long l = this.C << 3;
        this.update((byte)-128);
        while (this.B != 0) {
            this.update((byte)0);
        }
        this.processLength(l);
        this.processBlock();
    }

    public void reset() {
        this.C = 0L;
        this.B = 0;
        for (int i = 0; i < this.A.length; ++i) {
            this.A[i] = 0;
        }
    }

    protected abstract void processWord(byte[] var1, int var2);

    protected abstract void processLength(long var1);

    protected abstract void processBlock();

    public abstract int getDigestSize();

    public abstract int doFinal(byte[] var1, int var2);

    public abstract String getAlgorithmName();
}

