/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.publickey;

import com.maverick.crypto.publickey.Dsa;
import com.maverick.crypto.publickey.DsaPrivateKey;
import com.maverick.crypto.publickey.Rsa;
import com.maverick.crypto.publickey.RsaPrivateCrtKey;
import com.maverick.crypto.security.SecureRandom;
import com.maverick.ssh.SshDsaPrivateKey;
import com.maverick.ssh.SshRsaPrivateCrtKey;
import com.maverick.ssh1.Ssh1RsaPublicKey;
import com.maverick.ssh2.Ssh2DsaPublicKey;
import com.maverick.ssh2.Ssh2RsaPublicKey;
import com.sshtools.publickey.SshKeyPair;
import java.io.IOException;
import java.math.BigInteger;

public class SshKeyPairGenerator {
    public static final String SSH1_RSA = "rsa1";
    public static final String SSH2_RSA = "ssh-rsa";
    public static final String SSH2_DSA = "ssh-dss";

    public static SshKeyPair generateKeyPair(String string, int n) throws IOException {
        if (!(SSH1_RSA.equalsIgnoreCase(string) || SSH2_RSA.equalsIgnoreCase(string) || SSH2_DSA.equalsIgnoreCase(string))) {
            throw new IOException(string + " is not a supported key algorithm!");
        }
        SshKeyPair sshKeyPair = new SshKeyPair();
        if (SSH1_RSA.equalsIgnoreCase(string)) {
            RsaPrivateCrtKey rsaPrivateCrtKey = Rsa.generateKey((int)n, (SecureRandom)SecureRandom.getInstance());
            sshKeyPair.A = new Ssh1RsaPublicKey(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
            sshKeyPair.B = new SshRsaPrivateCrtKey(rsaPrivateCrtKey);
        } else if (SSH2_RSA.equalsIgnoreCase(string)) {
            RsaPrivateCrtKey rsaPrivateCrtKey = Rsa.generateKey((int)n, (SecureRandom)SecureRandom.getInstance());
            sshKeyPair.A = new Ssh2RsaPublicKey(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
            sshKeyPair.B = new SshRsaPrivateCrtKey(rsaPrivateCrtKey);
        } else {
            DsaPrivateKey dsaPrivateKey = Dsa.generateKey((int)n, (SecureRandom)SecureRandom.getInstance());
            sshKeyPair.A = new Ssh2DsaPublicKey(dsaPrivateKey.getP(), dsaPrivateKey.getQ(), dsaPrivateKey.getG(), Dsa.generatePublicKey((BigInteger)dsaPrivateKey.getG(), (BigInteger)dsaPrivateKey.getP(), (BigInteger)dsaPrivateKey.getX()));
            sshKeyPair.B = new SshDsaPrivateKey(dsaPrivateKey);
        }
        return sshKeyPair;
    }
}

